/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * Memory Functions
 */
#ifndef	_CMD_HDCVI_UPGRADE_H
#define _CMD_HDCVI_UPGRADE_H

#include "armboot.h"

#define CMD_LEN			    8

#define REPLY_LEN			8
#define FRAME_DATA_LEN		1024
#define FRAME_HEAD_LEN		4
#define FRAME_CRC_LEN		2
#define FRM_LEN		        (FRAME_DATA_LEN + FRAME_HEAD_LEN + FRAME_CRC_LEN)

//#define WR_FLAH_WAIT_TIME   800
#define WR_FLAH_WAIT_TIME   800


/* HDCVI_MODE ģʽ */
#define HDCVI_MODE_720_25           0
#define HDCVI_MODE_720_30           1
#define HDCVI_MODE_720_50           2
#define HDCVI_MODE_720_60           3
#define HDCVI_MODE_1080_25          4 
#define HDCVI_MODE_1080_30          5
#define HDCVI_MODE_MAX              6



/* ״̬ */
#define STATE_BOOT_START            0 /* bootʼ */

#define STATE_VER_CK                1 /* Э汾У״̬  */ 
#define STATE_PDT_NAME_CK           2 /* 豸У״̬  */

#define STATE_CHGB                  3 /* ޸״̬  */
#define STATE_TYPE_CK               4 /* У  */
#define STATE_ERASE                 5 /*  */
#define STATE_RX485_FRAME           6 /* ݰշУ */
#define STATE_FRAME_END             7 /* ݰշ */

#define STATE_UPGRADE_WR            8  /* д */
#define STATE_UPGRADE_DONE          9  /*  */
#define STATE_UPGRADE_ERR           10 /*  */



/*******************************************************************************
*   : hdcvi_upgrade_init
*     : hdcvi:rs485оƬĴسʼݰ洢ʼ
*           ״̬ʼ
*     : 
*     : 
* ֵ  : < 0:ʧܡ
*           ==0:ɹ 
*******************************************************************************/
void hdcvi_upgrade_init(bd_t *bd);



/*******************************************************************************
*   : hdcvi_upgrade
*     : hdcviӿ:շӦͻظݴ洢д.         
*     : 
*     : 
* ֵ  :             
*******************************************************************************/
int hdcvi_upgrade(void);

/*******************************************************************************
*   : pack_write
*     : hdcvi:дFlashظ         
*     : 
*     : 
* ֵ  : < 0:ʧܡ
*           ==0:ɹ 
*******************************************************************************/
int pack_write(ulong mem_addr, bd_t *bd);



/*******************************************************************************
*   : hdcvi_reply_up_result
*     : hdcvi:ظ         
*     : 
*     : 
* ֵ  : < 0:ʧܡ
*           ==0:ɹ 
*******************************************************************************/
int hdcvi_reply_up_result(int result);



/*******************************************************************************
*   : hdcvi_enable_wdt
*     : Ź. 
* 
*     :       
*     : 
* ֵ  : 
*                    
*******************************************************************************/
void hdcvi_enable_wdt(void);



/*******************************************************************************
*   : hdcvi_disable_wdt
*     : رտŹ 
* 
*     :       
*     : 
* ֵ  : 
*                    
*******************************************************************************/
void hdcvi_disable_wdt(void);



/*******************************************************************************
*   : hdcvi_wdt_setTimeout
*     : ÿŹʱʱ 
* 
*     :       
*     : 
* ֵ  : 
*                    
*******************************************************************************/
void  hdcvi_wdt_setTimeout(void);


/*******************************************************************************
*   : hdcvi_wdt_feed
*     :ιӿ 
* 
*     :       
*     : 
* ֵ  : 
*                    
*******************************************************************************/
void hdcvi_wdt_feed(void); 


/*******************************************************************************
*   : appauto_init
*     : ʼȡappautoֵ 
* 
*     :       
*     : 
* ֵ  : 
*                    
*******************************************************************************/
void appauto_init(void);



#endif	/* _CMD_HDCVI_UPGRADE_H */
