#ifndef __LOG_H__
#define __LOG_H__

//-----------------------------------------------------------------------------
// Description : Log library
// Author	   : Jongil Park <laminaz.park@samsung.com>
// Date		   : 2002.06.14
// Revision	   :
//-----------------------------------------------------------------------------

#include "config.h"

enum LogLevel
{
	NODELAY	= 1 << 1 ,
	CRIT 	= 1 << 2 ,
	ERR		= 1 << 3 ,
	WARN	= 1 << 4 ,
	INFO	= 1 << 5 ,
	NOTICE	= 1 << 6 ,
	DEBUG	= 1 << 7 ,
	MSG		= 1 << 8 ,
	DUMPMSG	= 1 << 9 ,
	SM		= 1 << 10 ,			// only for State Machine
	CALLID	= 1 << 11 ,			// only for Printing Call ID

	LOCAL1	= 1 << 18,
	LOCAL2	= 1 << 19,
	LOCAL3	= 1 << 20,
	LOCAL4	= 1 << 21,
	LOCAL5	= 1 << 22,
	LOCAL6	= 1 << 23,
	LOCAL7	= 1 << 24,
	LOCAL8	= 1 << 25,
	LOCAL9	= 1 << 26
};


#define	NUM_OF_LOGLEVEL		19
#define Log(Loglevel, format, args...) \
	do { \
			char __buf[100]; \
			sprintf(__buf, format ,##args); \
			_Log(Loglevel, "%-60s %s[%d], %s()\n", __buf, __FILE__, __LINE__, __FUNCTION__ ); \
	}while(0) 

//	_Log(Loglevel, format##"   [%s: %d, %s()]\n" ,##args, __FILE__, __LINE__, __FUNCTION__)

struct _LOG_INFO {
	char *szLevelName;
	int	nLevelValue;
};

/*
 * function prototypes
 */
int InitLog(void);
int _Log(int , char *, ...);
int ComputeLogLevel(char *);
int OpenLog(int);

#endif /* __LOG_H__ */
