#ifndef _W25Q64CV_H_
#define _W25Q64CV_H_
#include "types.h"
#define W25Q64CV_ADDR           1

#define SPANSION                0x01
#define ATMEL                   0x1F
#define WINBOND                 0xEF
#define MXIC                    0xC2


/* SPI Flash command */

/* read command */
#define CMD_READ            0x03
#define CMD_READ_1DUMMY     0x0B

/* erase command */
#define CMD_4K_ERASE        0x20
#define CMD_32K_ERASE       0x52
#define CMD_64K_ERASE       0xD8
//#define CMD_CHIP_ERASE       0x60
#define CMD_CHIP_ERASE      0xC7


/* program command  */
#define CMD_PAGE_PROG       0x02

/* program or erase other operation */
#define CMD_SUSPEND         0x75
#define CMD_RESUME          0x7A


/* protection command */
#define CMD_WRITE_EN        0x06
#define CMD_WRITE_DIS       0x04

/* security command */
#define CMD_SECTOR_LOCKD    0x33
#define CMD_SECTOR_FREEZ    0x34
#define CMD_SECTOR_READ_ST  0x35
#define CMD_SECTOR_PROGOTP  0x9B
#define CMD_SECTOR_READOTP  0x77

/* status register command */
#define CMD_STATUS_READ     0x05
#define CMD_STATUS_READ2    0x35
#define CMD_STATUS_WRITE_1B 0x01

/* miscellaneous command */
#define CMD_RESET           0xFF
#define CMD_READ_ID         0x9F
#define CMD_DEEP_PWRD       0xB9
#define CMD_DEEP_RESUME     0xAB



/* Max size of oen packet */
#define MAX_RDPK            ( 32 * 4 )
#define MAX_TXPK            ( 31 * 4 )
#define PAGE_MASK           0xFF
#define BLOCK_MASK          0xFFF
#define SECTOR_MASK         0xFFFF

#define PAGE_SIZE           ( 0x100 )
#define SECTOR_SIZE         (4*1024)
#define BLOCK32_SIZE        (32*1024)
#define BLOCK64_SIZE        (64*1024)


enum
{
    flash_erase_4k_mode   =  CMD_4K_ERASE,
    flash_erase_32k_mode  = CMD_32K_ERASE,
    flash_erase_64k_mode  = CMD_64K_ERASE
};

enum
{
    big_endian,
    little_endian
    
};
int w25q64cv_read_device_id(u32 *mf_id, u32 *dev_id);
int w25q64cv_read(u8 *buf,u32 addr,u32 count);
int w25q64cv_write(u8 *buf,u32 addr,u32 count,u8 endian);
int w25q64cv_erase(u32 startAddr,u32 sectorCont,u8 eraseMode);
#endif
