#ifndef CONFIG_H
#define CONFIG_H

#define S5N8947			0x00000001
#define S3C2500			0x00000002
#define S3C2510			0x00000004
#define VS28xx			0x00000008

#define ARM7TDMI		0x00000010
#define ARM940T			0x00000020
#define CK510			0x00000040


#define MAC8947			0x00000100
#define MAC2500			0x00000200
#define MAC2510			0x00000400
#define MACPLD			0x00000800

#define K8B1616UBA		0x00001000
#define AM29LV160D		0x00002000
#define MBM29LV160BE		0x00004000
#define MBM29DL640E		0x00005000
#define S29GL064M		0x00006000
#define M29W160DB		0x00008000
#define SST39VF160		0x00010000
#define AM29LV320D		0x00020000
#define AT49BV321		0x00040000
#define HY29LV320B		0x00080000
#define SD8MB			0x01000000
#define SD16MB			0x02000000
#define SD32MB			0x04000000
#define SD16BIT			0x10000000
#define SD32BIT			0x20000000
#define SD1BANK			0x40000000
#define SD2BANK			0x80000000

#define CFG_BOARD_TABLE             { S5N8947, S3C2500, S3C2510, VS28xx}
#define CFG_CPU_TABLE               { ARM7TDMI, ARM940T ,ARM940T, CK510}
#define CFG_DRIVER_TABLE            { MAC8947, MAC2500, MAC2510, MACPLD }
#define CFG_FLASH_TABLE             { K8B1616UBA, AM29LV160D, MBM29LV160BE, M29W160DB, SST39VF160, AM29LV320D, AT49BV321, HY29LV320B, MBM29DL640E, S29GL064M }
#define CFG_SDRAM_SIZE_TABLE        { SD8MB, SD16MB, SD32MB }
#define CFG_SDRAM_DATAWIDTH_TABLE   { SD16BIT, SD32BIT }
#define CFG_SDRAM_BANK_TABLE        { SD1BANK, SD2BANK }

#define CFG_BOARD			0x0000000f
#define CFG_CPU				0x000000f0
#define CFG_DRIVER			0x00000f00
#define CFG_FLASH			0x00fff000
#define CFG_SDRAM_SIZE			0x0f000000
#define CFG_SDRAM_CONFIG		0xf0000000

int Board_Selection (void);
int Flash_Selection (void);
int Sdram_Selection (void);
int Configuration_Setting (int);

#endif
