/*
 * unpackage the old image
 */
#include <stdio.h>
#include <stdlib.h>

int main(int argc, char **argv)
{
	int  ch	= 0;
	long int filesize;
	
	FILE *sf;
	FILE *df;
    
 	if (argc < 3)
    {
		printf(("\nToo less param!\nUsage: rmimg [sf] [df]\n\n"));
		exit(0);
    }
 	else
    {
     	printf("Prepare to open source[%s] and dist[%s] files ...\n", argv[1], argv[2]);
    }

 	if ((sf = fopen(argv[1], "rb")) == NULL)
    {
     	printf(("Open source file [%s] fail!\n", argv[1]));
     	exit(0);
    }

 	if ((df = fopen(argv[2], "wb")) == NULL)
    {
     	printf(("Open dst file [%s] fail!\n", argv[2]));
     	exit(0);
    }

 	fseek(sf, 0, SEEK_SET);
 	fseek(sf, 0, SEEK_END);
 	if ((filesize = ftell(sf)) == -1L)
    {
     	printf(("ftell(%s) failed, exit now!\n", argv[1]));
     	exit(0);
    };

 	fseek(sf, 0x04, SEEK_SET);
 	while ((ch = fgetc(sf)) != EOF)
    {
     	fprintf(df, "%c", ch);
    }

 	printf(("Finish Unpackage Image File.\n"));

 	fclose(sf);
 	fclose(df);
 	exit(0);
}
