#!/bin/sh
 echo
 echo "System Image Making Utility: Use gunzip/uart to enhance loading speed."
 echo "(C) Copyright 2006 ImageSilicon, March.30 2006, Xinhong Wang"
 echo

 SRC=`pwd`

 if [ $# -eq 0 ]; then
 	echo "Too less parameters!"
	echo "Usage: umaker.sh [elf-file-name]"
	exit
 fi
 
 echo "Remove $SRC/$1.bin"
 rm -f $SRC/$1.bin

 echo "Strip the source elf file[$1] to binary file [$SRC/$1.bin] ..."
 ckcore-elf-objcopy -O binary $1 $SRC/$1.bin

 echo "Remove ./image.bin.gz"
 rm -f $SRC/$1.bin.gz

 echo "Gzipping the source image: ./image.bin ..."
 gzip --best ./$1.bin

 ./genuimg.elf ./$1.bin.gz ./$1.img
