/*
 * This program is used to generate definitions needed by
 * assembly language modules.
 *
 * We use the technique used in the OSF Mach kernel code:
 * generate asm statements containing #defines,
 * compile this file to assembler, and then extract the
 * #defines from the assembly-language output.
 */

#include <linux/stddef.h>
#include <linux/sched.h>
#include <linux/kernel_stat.h>
#include <asm/bootinfo.h>
#include <asm/irq.h>
#include <asm/hardirq.h>
#if DAVIDM
#include <asm/amigahw.h>
#include <video/font.h>
#endif

#define DEFINE(sym, val) \
	asm volatile("\n#define " #sym " %c0" : : "i" (val))

int main(void)
{
	/* offsets into the task struct */
	DEFINE(TASK_STATE, offsetof(struct task_struct, state));
	DEFINE(TASK_FLAGS, offsetof(struct task_struct, flags));
	DEFINE(TASK_PID, offsetof(struct task_struct, pid));
	DEFINE(TASK_PTRACE, offsetof(struct task_struct, ptrace));
	DEFINE(TASK_BLOCKED, offsetof(struct task_struct, blocked));
	DEFINE(TASK_COUNTER, offsetof(struct task_struct, counter));
	DEFINE(TASK_SIGPENDING, offsetof(struct task_struct, sigpending));
	DEFINE(TASK_NEEDRESCHED, offsetof(struct task_struct, need_resched));
	DEFINE(TASK_THREAD, offsetof(struct task_struct, thread));
	DEFINE(TASK_MM, offsetof(struct task_struct, mm));
	DEFINE(TASK_ACTIVE_MM, offsetof(struct task_struct, active_mm));

	/* offsets into the thread struct */
	DEFINE(CPUSTAT_SOFTIRQ_PENDING, offsetof(irq_cpustat_t, __softirq_pending));
	DEFINE(CPUSTAT_LOCAL_IRQ_COUNT, offsetof(irq_cpustat_t, __local_irq_count));

	/* offsets into the thread struct */
	DEFINE(THREAD_KSP, offsetof(struct thread_struct, ksp));
	DEFINE(THREAD_USP, offsetof(struct thread_struct, usp));
	DEFINE(THREAD_SR, offsetof(struct thread_struct, sr));
	DEFINE(THREAD_CRP, offsetof(struct thread_struct, crp));
	DEFINE(THREAD_ESP0, offsetof(struct thread_struct, esp0));

	/* offsets into the pt_regs */
	DEFINE(PT_PC, offsetof(struct pt_regs, pc));
	DEFINE(PT_R1, offsetof(struct pt_regs, r1));
	DEFINE(PT_SYSCALLR1, offsetof(struct pt_regs, syscallr2));	//syscallr1->syscallr2, Modified by Li Chunqiang 20050626, please refer asm/ptrace.h
	DEFINE(PT_SR, offsetof(struct pt_regs, sr));
	DEFINE(PT_R2, offsetof(struct pt_regs, r2));
	DEFINE(PT_R3, offsetof(struct pt_regs, r3));
	DEFINE(PT_R4, offsetof(struct pt_regs, r4));
	DEFINE(PT_R5, offsetof(struct pt_regs, r5));
	DEFINE(PT_R6, offsetof(struct pt_regs, r6));
	DEFINE(PT_R7, offsetof(struct pt_regs, r7));
	DEFINE(PT_R8, offsetof(struct pt_regs, r8));
	DEFINE(PT_R9, offsetof(struct pt_regs, r9));
        DEFINE(PT_R10, offsetof(struct pt_regs, r10));
        DEFINE(PT_R11, offsetof(struct pt_regs, r11));
        DEFINE(PT_R12, offsetof(struct pt_regs, r12));
        DEFINE(PT_R13, offsetof(struct pt_regs, r13));
        DEFINE(PT_R14, offsetof(struct pt_regs, r14));
        DEFINE(PT_R15, offsetof(struct pt_regs, r15)); 

#ifndef CONFIG_COLDFIRE
	/* offsets into the irq_handler struct */
	DEFINE(IRQ_HANDLER, offsetof(struct irq_node, handler));
	DEFINE(IRQ_DEVID, offsetof(struct irq_node, dev_id));
	DEFINE(IRQ_NEXT, offsetof(struct irq_node, next));
#endif

	/* offsets into the kernel_stat struct */
	DEFINE(STAT_IRQ, offsetof(struct kernel_stat, irqs));


	/* signal defines */
	DEFINE(SIGSEGV, SIGSEGV);
	DEFINE(SEGV_MAPERR, SEGV_MAPERR);
	DEFINE(SIGTRAP, SIGTRAP);
	DEFINE(TRAP_TRACE, TRAP_TRACE);

	DEFINE(PT_PTRACED, PT_PTRACED);
	DEFINE(PT_TRACESYS, PT_TRACESYS);
	DEFINE(PT_DTRACE, PT_DTRACE);


	return 0;
}
