

#include <linux/types.h>
#include <linux/autoconf.h>

#include <asm/system.h>
#include <asm/cache.h>

/*
int memcmp(const void * cs,const void * ct,size_t count)
{
  const unsigned char *su1, *su2;

  for( su1 = cs, su2 = ct; 0 < count; ++su1, ++su2, count--)
    if (*su1 != *su2)
      return((*su1 < *su2) ? -1 : +1);
  return(0);
}
*/


/*
 *	dmacpy with dma funtion 
 *	without another task interfering.
 */
 
asmlinkage int sys_dmacpy( void * s1, const void * s2, int n)
{
    unsigned long  flags;
#define DMA_MODE				((volatile unsigned long *)0x60030000)
#define DMA_SRCADDR				((volatile unsigned long *)0x60030004)
#define DMA_DSTADDR				((volatile unsigned long *)0x60030008)
#define DMA_CTRSLEN				((volatile unsigned long *)0x6003000c)
#define DMA_RTRSX				((volatile unsigned long *)0x60030010)
#define DMA_RTRSY				((volatile unsigned long *)0x60030014)
#define DMA_RTRWTH_S			((volatile unsigned long *)0x60030018)
#define DMA_RTRWTH_G			((volatile unsigned long *)0x6003001c)
#define DMA_START				((volatile unsigned long *)0x60030020)

#define DMA_STATUS				((volatile unsigned long *)0x60100000)

#define DMA_STATUS_BUSY			4
#define DMA_STATUS_END 			2
#define DMA_STATUS_ERROR		1

//#define NEEDCOMPARE

       local_irq_save(flags);
//        printk("copy now\n");
	//busy
	if(*DMA_STATUS & DMA_STATUS_BUSY)
	{
		printk("dma busy!\n");
		//return 0;
		goto _dma_out;
	}
	
	*DMA_MODE = 0;
	*DMA_SRCADDR = (unsigned long)s2;
	*DMA_DSTADDR = (unsigned long)s1;
	*DMA_CTRSLEN = n;
	*DMA_START = 1;
	
	//busy
	while(*DMA_STATUS & DMA_STATUS_BUSY)
	{
//		printk("Dma start 0x%x, 0x%x, len 0x%x", s2, s1, n);
            ;
	}
	
	//error
	if(*DMA_STATUS & DMA_STATUS_ERROR)
	{
		printk("dma error!\n");
		//return 0;
		goto _dma_out;
	}

//       printk("dma return\n");
	
    InvCache();
#ifdef NEEDCOMPARE
	if(memcmp(s2, s1, n))
	{
		printk("compare error!\n");
		//return 0;
	}
#endif

_dma_out:
       local_irq_restore(flags);

	return 0;
}


