#
# DH2004/Makefile
#
# This file is included by the global makefile so that you can add your own
# platform-specific flags and dependencies.
#
# This file is subject to the terms and conditions of the GNU General Public
# License.  See the file "COPYING" in the main directory of this archive
# for more details.
#
# Copyright (C) 1999,2001  Greg Ungerer (gerg@snapgear.com)
# Copyright (C) 1998,1999  D. Jeff Dionne <jeff@uClinux.org>
# Copyright (C) 1998       Kenneth Albanowski <kjahds@kjahds.com>
# Copyright (C) 1994 by Hamish Macdonald
# Copyright (C) 2000  Lineo Inc. (www.lineo.com)
# Copyright (C) 2004 Kang Sun (sunk@vlsi.zju.edu.cn)

GCC_DIR = $(shell $(CC) -v 2>&1 | grep specs | sed -e 's/.* \(.*\)specs/\1\./')

INCGCC = $(GCC_DIR)/include #-I/home/backup/zxj/vs2811/kernel/linux-2.4.x/drivers/vsgeneral/reg
#LIBGCC = $(GCC_DIR)/big/libgcc.a
LIBGCC = $(GCC_DIR)/libgcc.a

#-mno-stm -mbig-endian
#CFLAGS :=  -fsigned-char -mcpu=ck610 -fno-builtin-ffs $(CFLAGS) -I$(INCGCC) -pipe -DNO_MM -DNO_FPU -D__ELF__  -DMAGIC_ROM_PTR -DUTS_SYSNAME=\"uClinux\" -D__linux__ -DNO_TEXT_SECTIONS

#CFLAGS :=  -fsigned-char  -mbig-endian $(CFLAGS) -mno-stm
#CFLAGS += -I$(INCGCC) -pipe -DNO_MM -DNO_FPU -D__ELF__  

CFLAGS :=  -fsigned-char -mno-stm -fno-builtin-ffs $(CFLAGS) -I$(INCGCC) -pipe -DNO_MM -DNO_FPU -D__ELF__  -DMAGIC_ROM_PTR -DUTS_SYSNAME=\"uClinux\" -D__linux__ -DNO_TEXT_SECTIONS
CFLAGS += -DMAGIC_ROM_PTR -DUTS_SYSNAME=\"uClinux\" -D__linux__ -DNO_TEXT_SECTIONS


AFLAGS := $(CFLAGS)

LINKFLAGS = -T arch/$(ARCH)/platform/$(PLATFORM)/$(BOARD)/$(MODEL).ld

HEAD := arch/$(ARCH)/platform/$(PLATFORM)/$(BOARD)/crt0_$(MODEL).o

SUBDIRS := arch/$(ARCH)/kernel arch/$(ARCH)/mm arch/$(ARCH)/lib \
           arch/$(ARCH)/platform/$(PLATFORM) $(SUBDIRS)
CORE_FILES := arch/$(ARCH)/kernel/kernel.o arch/$(ARCH)/mm/mm.o \
            arch/$(ARCH)/platform/$(PLATFORM)/platform.o $(CORE_FILES)
LIBS += arch/$(ARCH)/lib/lib.a $(LIBGCC)

MAKEBOOT = $(MAKE) -C arch/$(ARCH)/boot

archclean:
	@$(MAKEBOOT) clean
	rm -f arch/$(ARCH)/platform/$(PLATFORM)/ckcore_defs.h

