/* 
 *  linux/arch/ckcorenommu/platfrom/CK1000EVB/entry.S
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 *  Copyright (C) 2006-2008  Hangzhou C-SKY Microsystems co,. ltd.
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file README.legal in the main directory of this archive
 * for more details.
 *
 * entry.S  contains the system-call and fault low-level handling routines.
 * This also contains the timer-interrupt handler, as well as all interrupts
 * and faults that can result in a task-switch.
 *
 * NOTE: This code handles signal-recognition, which happens every time
 * after a timer-interrupt and after each system call.
 *
 */

/*
 * 12/03/96 Jes: Currently we only support ckcore single-cpu systems, so
 *               all pointers that used to be 'current' are now entry
 *               number 0 in the 'current_set' list.
 */

#include <linux/sys.h>
#include <linux/config.h>
#include <linux/linkage.h>
#include <asm/entry.h>
#include <asm/errno.h>
#include <asm/setup.h>
#include <asm/segment.h>
#include <asm/traps.h>
#include <asm/cksim.h>
#include <asm/ckpic.h>

#include "ckcore_defs.h"

#define C_UNSTM
//#undef C_UNSTM

#define IRQ_DEBUG
#undef IRQ_DEBUG

//#define IMMED #
//#define DBG_PUTC(x) moveb IMMED x,0xfffff907; \
//					moveb IMMED '\r',0xfffff907; \
//					moveb IMMED '\n',0xfffff907

.globl SYMBOL_NAME(system_call)
.globl SYMBOL_NAME(buserr)
.globl SYMBOL_NAME(trap)
.globl SYMBOL_NAME(reschedule)
.globl SYMBOL_NAME(inthandler)
.globl SYMBOL_NAME(autohandler)
.globl  SYMBOL_NAME(fasthandler)
.globl SYMBOL_NAME(fastautohandler)
.globl SYMBOL_NAME(resume), SYMBOL_NAME(ret_from_exception)
.globl SYMBOL_NAME(ret_from_signal)
.globl SYMBOL_NAME(sys_fork), SYMBOL_NAME(sys_clone)
.globl SYMBOL_NAME(sys_sigsuspend), SYMBOL_NAME(sys_sigreturn)
.globl SYMBOL_NAME(sw_usp)
.globl SYMBOL_NAME(sw_ksp)
.globl SYMBOL_NAME(sys_call_table)

#ifdef IRQ_DEBUG
.globl SYMBOL_NAME(tm_addr)
#endif

.import irq_stat
.data
sw_ksp:
.long 0
sw_usp:
.long 0

#ifdef IRQ_DEBUG
tm_addr:
.long 0xC4000000
#endif

.text
ENTRY(buserr)
	SAVE_ALL
	lrw     r2, -1                  /* Not a syscall*/
        stw     r2, (r0, LSAVE_SYSCALLR1)
        mov     r2, r0                  /* Stack address is arg[0] */
        jbsr    SYMBOL_NAME(buserr_c)   /* Call C level handler */
        jmpi    SYMBOL_NAME(ret_from_exception) 

ENTRY(reschedule)
        mov     r2, r0                  /* Stack address is arg[0] */
        jbsr    SYMBOL_NAME(set_esp0)   /* Call C level */
        lrw     r1, SYMBOL_NAME(ret_from_exception)
        mov     r15, r1                 /* Return address in link */
        jmpi    SYMBOL_NAME(schedule)

ENTRY(system_call)
        SAVE_ALL
		
        /*
         * Do not user r2-r6 here, because the arguments are saved in r2-r6
         * and the syscall number is saved in r1, when the exception is a
         * systemcall. Use temp regs instead
         * When excuting a trap instruction, the pc does not increase.
         * The pc should be increased manully and save in epc register.
         */
        mfcr    r7, epc                /* Get the trap point */
        addi    r7, 2                  /* Increase the epc */
        mtcr    r7, epc                /* Save return point */
        stw     r7, (r0)               /* Save it in stack*/

        /*
         * Why the kernel panic when we enable interrupt?
         * Ok Now! we must disable interrupt when RESTORE_ALL!!! 
         *
         * Enable interrupt
         * Enable exception, psr::6(IE)=1 can not enable interrupt
         * without psr::8(EE)=1, at the same time, we must enable EE bit
         * for "trap 0" instruction in system call.
         */
        psrset  ee, ie

        mov     r2, r0                 /* arg[0] is sp */
        jbsr    SYMBOL_NAME(set_esp0)  /* Stack frame for syscall */
        ldw     r2, (r0, LSAVE_R2)     /* Restore r2 */
        ldw     r6, (r0, LSAVE_R6)     /* for 5 pars system calls, the call
                                          of set_esp0 will scratch r6 ... */
        lrw     r7, NR_syscalls
        cmphs   r1, r7                 /* Check nr of syscall */
        bt      SYMBOL_NAME(ret_from_exception)

        lrw     r7, SYMBOL_NAME(sys_call_table)
        ixw     r7, r1                 /* Index into syscall table */
        ldw     r7, (r7)               /* Get syscall function */
        cmpnei  r7, 0                  /* Check for not null */
        bf      SYMBOL_NAME(ret_from_exception)
   
        lrw     r8, SYMBOL_NAME(_current_task)  /* Get task pointer */
        ldw     r8, (r8)
        addi    r8, TASK_FLAGS                /* Get flag offset */
        ldw     r8, (r8)                      /* Get flags value */
        btsti   r8, 5                         /* Check if PF_TRACESYS set */
        bt      1f

        jsr     r7                     /* Do system call */
        stw     r2, (r0, LSAVE_R2)     /* Save return value */
        jmpi    SYMBOL_NAME(ret_from_exception)

  1:
        SAVE_SWITCH_STACK
        jbsr    SYMBOL_NAME(syscall_trace)
        RESTORE_SWITCH_STACK

        jsr      r7                     /* Do system call */
        stw      r2, (r0, LSAVE_R2)     /* Save return value */
        
        SAVE_SWITCH_STACK
        jbsr     SYMBOL_NAME(syscall_trace)

ENTRY(ret_from_signal)
        RESTORE_SWITCH_STACK

ENTRY(ret_from_fork)
        subi      r0, 4      /* make stack room */
        stw       r2, (r0)   /* save r2 */
        mfcr      r2, ss4    /* fork return, r2 is prev */
        jbsr      SYMBOL_NAME(schedule_tail)
        ldw       r2, (r0)   /* retore r2 */
        addi      r0, 4      /* restore stack point */ 
        jbsr      SYMBOL_NAME(ret_from_exception)

ENTRY(ret_from_exception)
        /*
         * Why the kernel panic when we enable interrupt in system_call. 
         * Ok noew, we must disable interrupt when RESTORE_ALL, 
         * if we enable interrupt!
         */
        psrclr  ie          /* Disable interrupt */
        /* Check if return to kernel, we must get epsr from stack. */
        ldw      r1, (r0, 12)
        btsti    r1, 31
        bt       2f

        /*
         * Load address of _current_task,then Get address of task_struct
         * Get task_needreshed in task_struct
         */ 
        lrw      r1, SYMBOL_NAME(_current_task)
        ldw      r1, (r1)
        ldw      r2, (r1, TASK_NEEDRESCHED)
        cmpnei   r2, 0
        bt       SYMBOL_NAME(reschedule)

        lrw      r1, SYMBOL_NAME(_current_task) /* Address of current_set */
        ldw      r1, (r1)                       /* Address of _current_task struct */  
        lrw      r2, SYMBOL_NAME(init_tasks)    /* Address of init_tasks */
        ldw      r2, (r2)                       /* Address of task_struct of task[0]*/
        cmpne    r1, r2
        bf       2f                           /* Exit if task[0] */

        ldw      r2, (r1, TASK_FLAGS)         /* Get flags value */
        btsti    r2, 5                        /* Check if delay trace */
        bclri    r2, 5                        /* Clear it anyway */
        bf       1f

        ldw      r2, (r1, TASK_FLAGS)         /* Get PSR */
        bclri    r2, 14                       /* Clear out trace mode */
        bclri    r2, 15                       /* Clear out trace mode */
        stw      r2, (r1, TASK_FLAGS)

        movi     r4, 1                        /* arg[2] is SIGTRAP */
        mov      r3, r1                       /* arg[1] is task pointer */
        movi     r2, 5                        /* arg[0] is const 5 */
        jbsr     SYMBOL_NAME(send_sig)        /* Send signal to task */
        
        lrw      r1, SYMBOL_NAME(_current_task) /* Address of current_set */
        ldw      r1, (r1)                     /* Address of _current_task struct */
  1:
        ldw      r2, (r1, TASK_STATE)        /* Get task STATE */
        cmpnei   r2, 0                        /* Check for non-zero */
        bt       SYMBOL_NAME(reschedule)
        
        //zxj 2008-10-20
		//lrw		r3,0x42000000
       	//movi 	r2,'-'
        //stb r2, (r3, 0x0b)
  
  #if 1
        ldw      r2, (r1, TASK_COUNTER)      /* Get task counter */
        subi    r2, 1
        cmpnei   r2, 0                       /* Check for zero */
        bf       SYMBOL_NAME(reschedule)
	#endif
        
        //zxj 2008-10-20
        //lrw		r3,0x42000000
       	//movi 	r2,'*'
        //stb r2, (r3, 0x0b)

        lrw      r3, TASK_BLOCKED            /* Get offset of blocked */
        add      r3, r1
        ldw      r2, (r3)                    /* Get blocked indicator */
        mov      r3, r2                      /* Save value for later */
        not      r2
        ldw      r4, (r1, TASK_FLAGS)        /* Get task flags */
        btsti    r4, 4                        /* Check if PTRACED */
        bt       1f
        lrw      r2, -1                       /* See all signals */
  1:    
        ldw      r4, (r1, TASK_SIGPENDING)    /* Get task signal */
        and      r4, r2                       /* Update signals */
        stw      r4, (r1, TASK_SIGPENDING)
        cmpnei   r4, 0                        /* Check if signal */
        bt       Lsignal_return
  2:
        RESTORE_ALL                           /* All done */

Lsignal_return:
        SAVE_SWITCH_STACK
        movi     r3, SWITCH_STACK_SIZE        /* arg[1] is pt_regs frame */
        addu     r3, r0
        movi     r2, 0
        jbsr     SYMBOL_NAME(do_signal)       /* Call signal handler */
        RESTORE_SWITCH_STACK
        RESTORE_ALL

/*-------------------------------------------------------------------*/

/*  
 *       Common trap handler. Standard traps come through here first
 */

ENTRY(trap)
        SAVE_ALL
        /*

        */
        
        lrw      r2, -1              /* Not a syscall */
        stw      r2, (r0, LSAVE_SYSCALLR1)

        mfcr     r2, psr             /* Get psr register */
        lsri     r2, 16              /* Get vector in base 8 bits */
        sextb    r2                  /* Fill upper bytes with zero */
        mov      r3, r0              /* Push Stack pointer arg */
        jbsr     SYMBOL_NAME(trap_c) /* Call C-level trap handler */
        jmpi     SYMBOL_NAME(ret_from_exception)

/*
 *  This is the generic interrupt handler (for all hardware interrupt
 *  sources). It figures out the vector number and calls the appropriate
 *  interrupt service routine directly. This is for vectored normal 
 *  interrupts.
 */

ENTRY(inthandler)
        SAVE_ALL
        
        lrw      r2, -1              /* Not a syscall */
        stw      r2, (r0, LSAVE_SYSCALLR1)
 //       psrset   ee               /* Then we can enable exception */

        lrw      r1, SYMBOL_NAME(irq_stat)    /* Get address */
        ldw      r2, (r1, 4)         /* Get current local_irq_count */
        addi     r2, 1            /* Increase local_irq_count */
        stw      r2, (r1, 4)         /* Update it in memory */

        /*
         * If we enable fast interrupt,
         * Maybe there is a bug to set psr here,
         * when return from fast interrupt here
         * psr.vec = fpsr.vec, so psr.vec here
         * is not the normal or exception vec now.
         * So we must use epsr.vec.
         */
        mfcr     r2, epsr             /* Get PSR register */
        lsri     r2, 16               /* Get vector in 7 bits */
        sextb    r2                   /* Fill upper bytes with zero */
        
        psrset   ee               /* Then we can enable exception */
        
			#ifdef IRQ_DEBUG

				mov r3, r2
				subi r3, 31

				cmpnei r3, 6		    /* timer1? */
				bt _continue
				
                lrw r3, tm_addr
                ldw r6, (r3, 0)
							
				lrw r4, 0x7000007C      /* high */
				ldw r5, (r4, 0)
				stw r5, (r6, 0)

				lrw r4, 0x70000078      /* low */
				ldw r5, (r4, 0)
				stw r5, (r6, 4)

				addi r6, 8
				stw r6, (r3, 0)

		_continue:
			#endif
       
        lrw      r3, SYMBOL_NAME(irq_kstat_interrupt)
        ixw      r3, r2               /* Get pointer to irq */
        ldw      r4, (r3)             /* Get current value */
        addi     r4, 1                /* Increase irq_counter */
        stw      r4, (r3)             /* Update it in memory */

        lrw      r5, SYMBOL_NAME(irq_list)
        mov      r3, r2
        lsli     r3, 4                /* Get array/struct offset */
        addu     r5, r3
        ldw      r1, (r5)             /* Get function handler */
                                      /* arg[0] is set to vector nr */
        ldw      r3, (r5, 8)          /* arg[1] is devID */
        mov      r4, r0               /* arg[2] is stack pointer */
        jsr      r1                   /* Call handler */
done_intrhandler:
        /* 
         * Why we substract  "local_irq_count" with "1" ?
         * I think we must deal with it after we have finished the softirq,
         * or we will get "local_irq_count" always "1" here because
         * the interrupt is disable yet here.
         * Pointer to local_irq_count
         */
        lrw      r1, SYMBOL_NAME(irq_stat)      
        ldw      r2, (r1, 4)             /* Get current local_irq_count */
        subi     r2, 1
        stw      r2, (r1, 4)             /* Save local_irq_count */
        lrw      r3, (CKSIM_PIC_BASE) /* cow reg of pic */
        //psrset   ee               /* Then we can enable exception */
#if 1

////////////
/*0*/
	 ldw      r4, (r3, 0x08)        /* get cow word, offset if 0xc */
       bclri     r4, 15                     /* Check if interrupts on */
       stw      r4, (r3, 0x08)        /* store COW */
////////////
/*0ɹ˳*/
jmprpt1:  
   	ldw      r4, (r3, 0x08)        /* get cow word, offset if 0xc */
      btsti     r4, 15                     /* Check if interrupts on */
      bt        jmprpt1
////////////



        ldw      r4, (r3, 0x10)        /* get cow word, offset if 0xc */
        bseti    r4, 2                /* set EOI, tell pic interrupt complete */
        stw      r4, (r3, 0x10)        /* store COW */

////////////
/*1*/
	 ldw      r4, (r3, 0x08)        /* get cow word, offset if 0xc */
       bseti     r4, 15                     /* Check if interrupts on */
       stw      r4, (r3, 0x08)        /* store COW */

/*1ɹ˳*/
jmprpt:  
   	ldw      r4, (r3, 0x08)        /* get cow word, offset if 0xc */
      btsti     r4, 15                     /* Check if interrupts on */
      bf        jmprpt
////////////

////////////
/*0*/
	 ldw      r4, (r3, 0x08)        /* get cow word, offset if 0xc */
       bclri     r4, 15                     /* Check if interrupts on */
       stw      r4, (r3, 0x08)        /* store COW */
////////////

#else

        ldw      r4, (r3, 0x10)        /* get cow word, offset if 0xc */
        bseti    r4, 2                /* set EOI, tell pic interrupt complete */
        stw      r4, (r3, 0x10)        /* store COW */
      
#endif

       cmpnei   r2, 0                /* Check for non-zero */
        
        bt       3f
        
        psrset   ie               /* Then we can enable interrupts */

  2:
        /*
         * get irq_stat pointer,  Get irq_stat[0].__softirq_pending
         */
        lrw      r2, SYMBOL_NAME(irq_stat)  
        ldw      r2, (r2, CPUSTAT_SOFTIRQ_PENDING) 
       	cmpnei   r2, 0                      /* Check for non-zero */
        bf       SYMBOL_NAME(ret_from_exception)
        
      	lrw      r7, SYMBOL_NAME(ret_from_exception)
      	mov      r15, r7
      	jmpi     SYMBOL_NAME(do_softirq)      

  3: 
        RESTORE_ALL
/*---------------------------------------------------------------*/

/*
 *      This is the auto-vectored interrupt handler (for all hardware interrupt
 *      sources). It figures out the vector number and calls the appropriate
 *      interrupt service routine directly. This is for auto-vectored normal
 *      interrupts only.
 */

ENTRY(autohandler)
         SAVE_ALL
		
         lrw     r2, -1                           /* Not a syscall */
         stw     r2, (r0,LSAVE_SYSCALLR1)

         lrw     r1, SYMBOL_NAME(irq_stat)      /* Get address */
         ldw     r2, (r1, 4)                   /* Get current local_irq_count */
         addi    r2, 1                      /* Increment local_irq_count */
         stw     r2, (r1, 4)                   /* Update it in memory */
         
         /*
          * If we enable fast interrupt,
          * Maybe there is a bug to set psr here.
          * when return from fast interrupt here
          * psr.vec = fpsr.vec, then psr.vec here
          * is not the normal or exception vec now,
          * So we must use epsr.vec.
          */
         mfcr    r2, epsr                      /* Get PSR register */
         lsri    r2, 16                           /* Get vector in base 8 bits */
         sextb   r2                              /* Fill upper bytes with 0 */

         lrw     r3, SYMBOL_NAME(irq_kstat_interrupt)
         ixw     r3, r2                           /* Get pointer to irq_... */
         ldw     r4, (r3)                         /* Get current value */
         addi    r4, 1                            /* Increemnt irq_... counter */
         stw     r4, (r3)                         /* Update it in memory */

         lrw     r5, SYMBOL_NAME(irq_list)
         mov     r3, r2
         lsli    r3, 4                            /* Get array/struct offet */
         addu    r5, r3
         ldw     r1, (r5)                         /* Get function handler */
                                                /* arg[0] is set to vector nr */
         ldw     r3, (r5,8)                       /* arg[1] is devid */
         mov     r4, r0                           /* arg[2] is stack pointer */
         jsr     r1                              /* Call handler */

         jmpi    SYMBOL_NAME(done_intrhandler)

/*----------------------------------------------------------------*/
 
/* 
 *      This is the fast interrupt handler (for certain hardware interrupt
 *      sources). Unlike the normal interrupt handler it doesn't bother
 *      doing the bottom half handlers.
 */

	ENTRY(fasthandler)
//        mtcr    r1, ss2                          /* Save original r1 */
//        mfcr    r1, fpsr                         /* Get original PSR */
 //       btsti   r1, 31                           /* Check if was supervisor */
 //       bt      1f
//        mtcr    r0, ss1                          /* Save user stack */
 //       mfcr    r0, ss0                          /* Set kernel stack */
//1:
  //      subi    r0, 30
    //    subi    r0, 30
     //   stm     r1-r15, (r0)                     /* Save all user regs */
     //   subi    r0, 12                           /* Make room for PC/PSR/r1 */
     //   mfcr    r1, ss2                          /* Save original r1 on stack */
     //   stw     r1, (r0,8)
     //   stw     r1, (r0,4)                       /* Save syscall r1 on stack */
   //     mfcr    r1, fpc                          /* Save PC on stack */
   //     stw     r1, (r0)

        
        mfcr    r2, psr                          /* Get PSR register */
        lsri    r2, 16                           /* Get vector in base 8 bits */
        sextb   r2                              /* Fill upper bytes with 0 */

 //       lrw     r3, SYMBOL_NAME(irq_kstat_interrupt)
 //       ixw     r3, r2                           /* Get pointer to irq_... */
 //       ldw     r4, (r3)                         /* Get current value */
 //       addi    r4, 1                            /* Increemnt irq_... counter */
//        stw     r4, (r3)                         /* Update it in memory */

        lrw     r5, SYMBOL_NAME(irq_list)
        mov     r3, r2
        lsli    r3, 4                           /* Get array/struct offet */
        addu    r5, r3
        ldw     r1, (r5)                        /* Get function handler */
                                                /* arg[0] is set to vector nr */
        ldw     r3, (r5,8)                      /* arg[1] is devid */
        mov     r4, r0                          /* arg[2] is stack pointer */
        jsr     r1                              /* Call handler */

        jmpi    SYMBOL_NAME(done_fasthandler)

done_fasthandler:

	//add by phosor at 2008/01/10
        lrw      r3, (CKSIM_PIC_BASE) /* cow reg of pic */
        ldw      r4, (r3, 0x10)        /* get cow word, offset if 0xc */
        bseti    r4, 3                /* set EOI, tell pic interrupt complete */
        stw      r4, (r3, 0x10)        /* store COW */
	//end add by phosor at 2008/01/10

	rfi
	

/*
 *      This is the fast aotu-vector interrupt handler (for certain hardware
 *      interrupt sources). Unlike the normal interrupt handler it doesn't
 *      bother doing the bottom half handlers.
 */

ENTRY(fastautohandler)
        mtcr    r1,ss2                          /* Save original r1 */
        mfcr    r1,fpsr                         /* Get original PSR */
        btsti   r1,31                           /* Check if was supervisor */
        bt      1f
        mtcr    r0,ss1                          /* Save user stack */
        mfcr    r0,ss0                          /* Set kernel stack */
1:
        subi    r0,32
        subi    r0,28
        
       #ifdef C_UNSTM
		stw     r1, (r0, 0)
        stw     r2, (r0, 4)
        stw     r3, (r0, 8)
        stw     r4, (r0, 12)
        stw     r5, (r0, 16)
        stw     r6, (r0, 20)
        stw     r7, (r0, 24)
        stw     r8, (r0, 28)
        stw     r9, (r0, 32)
        stw     r10, (r0, 36)
        stw     r11, (r0, 40)
        stw     r12, (r0, 44)
        stw     r13, (r0, 48)
        stw     r14, (r0, 52)
        stw     r15, (r0, 56)
       #else
        stm     r1-r15,(r0)                     /* Save all user regs */
        #endif
        
        
        subi    r0,12                           /* Make room for PC/PSR/r1 */
        mfcr    r1,ss2                          /* Save original r1 on stack */
        stw     r1,(r0,8)
        stw     r1,(r0,4)                       /* Save syscall r1 on stack */
        mfcr    r1,fpc                          /* Save PC on stack */
        stw     r1,(r0)

        mfcr    r2,psr                          /* Get PSR register */
        lsri    r2,16                           /* Get vector in base 8 bits */
        sextb   r2                              /* Fill upper bytes with 0 */

        lrw     r3,SYMBOL_NAME(irq_kstat_interrupt)
        ixw     r3,r2                           /* Get pointer to irq_... */
        ldw     r4,(r3)                         /* Get current value */
        addi    r4,1                            /* Increemnt irq_... counter */
        stw     r4,(r3)                         /* Update it in memory */

        /* FIXME: need to use MCORE peripherals here */

        lrw     r5,SYMBOL_NAME(irq_list)
        mov     r3,r2
        lsli    r3,4                            /* Get array/struct offet */
        addu    r5,r3
        ldw     r1,(r5)                         /* Get function handler */
                                                /* arg[0] is set to vector nr */
        ldw     r3,(r5,8)                       /* arg[1] is devid */
        mov     r4,r0                           /* arg[2] is stack pointer */
        jsr     r1                              /* Call handler */

        jmpi    done_fasthandler
/*-----------------------------------------------------------*/

ENTRY(sys_fork)
        SAVE_SWITCH_STACK
        lrw     r2, SWITCH_STACK_SIZE           /* arg[0] is pt_regs frame */
        addu    r2, r0
        jbsr    SYMBOL_NAME(ckcore_vfork)        /* Call fork routine */
        stw     r2, (r0, 4)                     /* Save return value */
        RESTORE_SWITCH_STACK
        rts

/*----------------------------------------------------------*/

ENTRY(sys_clone)
        SAVE_SWITCH_STACK
        lrw     r2, SWITCH_STACK_SIZE           /* arg[0] is pt_regs frame */
        addu    r2, r0
        jbsr    SYMBOL_NAME(ckcore_clone)       /* Call clone routine */
        stw     r2, (r0, 4)                     /* Save return value */
        RESTORE_SWITCH_STACK
        rts

/*---------------------------------------------------------*/

ENTRY(sys_sigsuspend)
        SAVE_SWITCH_STACK
        lrw     r2, SWITCH_STACK_SIZE          /* arg[0] is pt_regs frame */
        addu    r2, r0
        jbsr    SYMBOL_NAME(do_rt_sigsuspend)     /* Call sigsuspend routine */
        stw     r2, (r0, 4)                    /* Save return value */ 
        RESTORE_SWITCH_STACK
        rts

/*--------------------------------------------------------*/

ENTRY(sys_sigreturn)
        SAVE_SWITCH_STACK

	/* Added by Li Chunqiang 20050615 */
        lrw     r2, SWITCH_STACK_SIZE          /* arg[0] is pt_regs frame */
        addu    r2, r0

        jbsr    SYMBOL_NAME(do_sigreturn)

	/* Modified by Li Chunqiang 20050615  */
        //stw     r2, (r0, 4)                    /* Save return value */
        RESTORE_SWITCH_STACK
        //stw     r2, (r0, 4)                    /* Save return value */

        rts

ENTRY(sys_rt_sigreturn)
        SAVE_SWITCH_STACK

	/* Added by Li Chunqiang 20050615 */
        lrw     r2, SWITCH_STACK_SIZE          /* arg[0] is pt_regs frame */
        addu    r2, r0

        jbsr    SYMBOL_NAME(do_sigreturn)

	/* Modified by Li Chunqiang 20050615  */
        //stw     r2, (r0, 4)                    /* Save return value */
        RESTORE_SWITCH_STACK
        //stw     r2, (r0, 4)                    /* Save return value */

        rts

ENTRY(sys_rt_sigsuspend)
        SAVE_SWITCH_STACK
        lrw     r2, SWITCH_STACK_SIZE          /* arg[0] is pt_regs frame */
        addu    r2, r0
        jbsr    SYMBOL_NAME(do_rt_sigsuspend)     /* Call sigsuspend routine */
        stw     r2, (r0, 4)                    /* Save return value */ 
        RESTORE_SWITCH_STACK
        rts

ENTRY(sys_vfork)
        SAVE_SWITCH_STACK
        lrw     r2, SWITCH_STACK_SIZE           /* arg[0] is pt_regs frame */
        addu    r2, r0
        jbsr    SYMBOL_NAME(ckcore_vfork)        /* Call fork routine */
        stw     r2, (r0, 4)                     /* Save return value */
        RESTORE_SWITCH_STACK
        rts

/*-------------------------------------------------------*/

//LTSS_KSP        = 0
//LTSS_USP        = 4
//LTSS_SR         = 8
//LTSS_FS         = 12
LTSS_CRP        = 16
LTSS_FPCTXT     = 28

/*
 *      Resume execution of a new process.
 *      Register definitions comming in:
 *
 *      r2   =  current task
 *      r3   =  new task
 *      r4   =  offset of tss
 *      r5   =  shared
 */

ENTRY(resume)
        subi    r0, 8                          
        stw     r7, (r0)             /* save r7 */
        stw     r8, (r0, 4)          /* save r8 */
        lrw     r8, TASK_THREAD               /* struct_thread offset in task_struct */ 
        addu    r8, r2                        /* r8 point to thread in task_struct */
        mfcr    r7, psr                       /* Save PSR value */
        mtcr    r2, ss4                       /* save prev in ss4, for ret_from_fork */

        stw     r7, (r8, THREAD_SR)           /* Save PSR in task struct */
        bclri   r7, 6                         /* Disable interrupts */
        mtcr    r7, psr
        
        ldw     r7, (r0)                      /* restore r7 */
        ldw     r8, (r0, 4)                   /* restore r8 */
        addi    r0, 8
        SAVE_SWITCH_STACK
        lrw     r8, TASK_THREAD               /* the position of thread in task_struct */
        addu    r8, r2                     
        mfcr    r6, ss1                       /* Get current usp */
        stw     r6, (r8, THREAD_USP)          /* Save usp in task struct */
        stw     r0, (r8, THREAD_KSP)          /* Save ksp in task struct */
       
        lrw     r8, TASK_THREAD               
        lrw     r7, SYMBOL_NAME(_current_task)
        stw     r3, (r7)                      /* Set new task */
        addu    r8, r3                        /* Pointer to thread in task_struct */

        /* Set up next process to run */
        ldw     r0, (r8, THREAD_KSP)            /* Set next ksp */
        ldw     r6, (r8, THREAD_USP)            /* Set next usp */
        mtcr    r6, ss1
        ldw     r7, (r8, THREAD_SR)             /* Set next PSR */
        mtcr    r7, psr
        RESTORE_SWITCH_STACK
        rts

.data
ALIGN
/* SYMBOL_NAME_LABEL(sys_call_table) */
sys_call_table:
	.long SYMBOL_NAME(sys_ni_syscall)	/* 0  -  old "setup()" syscall holder */
	.long SYMBOL_NAME(sys_exit)
	.long SYMBOL_NAME(sys_fork)		/* same to sys_vfork */
	.long SYMBOL_NAME(sys_read)
	.long SYMBOL_NAME(sys_write)
	.long SYMBOL_NAME(sys_open)		/* 5 */
	.long SYMBOL_NAME(sys_close)
	.long SYMBOL_NAME(sys_waitpid)
	.long SYMBOL_NAME(sys_creat)
	.long SYMBOL_NAME(sys_link)
	.long SYMBOL_NAME(sys_unlink)		/* 10 */
	.long SYMBOL_NAME(sys_execve)
	.long SYMBOL_NAME(sys_chdir)
	.long SYMBOL_NAME(sys_time)
	.long SYMBOL_NAME(sys_mknod)
	.long SYMBOL_NAME(sys_chmod)		/* 15 */
	.long SYMBOL_NAME(sys_chown16)
	.long SYMBOL_NAME(sys_ni_syscall)	/* old 'break' syscall */
	.long SYMBOL_NAME(sys_stat)
	.long SYMBOL_NAME(sys_lseek)
	.long SYMBOL_NAME(sys_getpid)		/* 20 */
	.long SYMBOL_NAME(sys_mount)
	.long SYMBOL_NAME(sys_oldumount)
	.long SYMBOL_NAME(sys_setuid16)
	.long SYMBOL_NAME(sys_getuid16)
	.long SYMBOL_NAME(sys_stime)		/* 25 */
	.long SYMBOL_NAME(sys_ptrace)
	.long SYMBOL_NAME(sys_alarm)
	.long SYMBOL_NAME(sys_fstat)
	.long SYMBOL_NAME(sys_pause)
	.long SYMBOL_NAME(sys_utime)		/* 30 */
	.long SYMBOL_NAME(sys_ni_syscall)	/* old 'stty' syscall */
	.long SYMBOL_NAME(sys_ni_syscall)	/* old 'gtty' syscall */
	.long SYMBOL_NAME(sys_access)
	.long SYMBOL_NAME(sys_nice)
	.long SYMBOL_NAME(sys_ni_syscall)	/* 35 - old 'ftime' syscall */
	.long SYMBOL_NAME(sys_sync)
	.long SYMBOL_NAME(sys_kill)
	.long SYMBOL_NAME(sys_rename)
	.long SYMBOL_NAME(sys_mkdir)
	.long SYMBOL_NAME(sys_rmdir)		/* 40 */
	.long SYMBOL_NAME(sys_dup)
	.long SYMBOL_NAME(sys_pipe)
	.long SYMBOL_NAME(sys_times)
	.long SYMBOL_NAME(sys_ni_syscall)	/* old 'prof' syscall */
	.long SYMBOL_NAME(sys_brk)		/* 45 */
	.long SYMBOL_NAME(sys_setgid16)
	.long SYMBOL_NAME(sys_getgid16)
	.long SYMBOL_NAME(sys_signal)
	.long SYMBOL_NAME(sys_geteuid16)
	.long SYMBOL_NAME(sys_getegid16)	/* 50 */
	.long SYMBOL_NAME(sys_acct)
	.long SYMBOL_NAME(sys_umount)		/* recycled never used phys() */
	.long SYMBOL_NAME(sys_ni_syscall)	/* old lock syscall holder */
	.long SYMBOL_NAME(sys_ioctl)
	.long SYMBOL_NAME(sys_fcntl)		/* 55 */
	.long SYMBOL_NAME(sys_ni_syscall)	/* old mpx syscall holder */
	.long SYMBOL_NAME(sys_setpgid)
	.long SYMBOL_NAME(sys_ni_syscall)	/* old ulimit syscall holder */
	.long SYMBOL_NAME(sys_ni_syscall)	/* old old uname syscall holder */
	.long SYMBOL_NAME(sys_umask)		/* 60 */
	.long SYMBOL_NAME(sys_chroot)
	.long SYMBOL_NAME(sys_ustat)
	.long SYMBOL_NAME(sys_dup2)
	.long SYMBOL_NAME(sys_getppid)
	.long SYMBOL_NAME(sys_getpgrp)		/* 65 */
	.long SYMBOL_NAME(sys_setsid)
	.long SYMBOL_NAME(sys_sigaction)
	.long SYMBOL_NAME(sys_sgetmask)
	.long SYMBOL_NAME(sys_ssetmask)
	.long SYMBOL_NAME(sys_setreuid16)	/* 70 */
	.long SYMBOL_NAME(sys_setregid16)
	.long SYMBOL_NAME(sys_sigsuspend)
	.long SYMBOL_NAME(sys_sigpending)
	.long SYMBOL_NAME(sys_sethostname)
	.long SYMBOL_NAME(sys_setrlimit)	/* 75 */
	.long SYMBOL_NAME(sys_old_getrlimit)
	.long SYMBOL_NAME(sys_getrusage)
	.long SYMBOL_NAME(sys_gettimeofday)
	.long SYMBOL_NAME(sys_settimeofday)
	.long SYMBOL_NAME(sys_getgroups16)	/* 80 */
	.long SYMBOL_NAME(sys_setgroups16)
	.long SYMBOL_NAME(old_select)
	.long SYMBOL_NAME(sys_symlink)
	.long SYMBOL_NAME(sys_lstat)
	.long SYMBOL_NAME(sys_readlink)		/* 85 */
	.long SYMBOL_NAME(sys_uselib)
	.long SYMBOL_NAME(sys_swapon)		/* Just dummy function */
	.long SYMBOL_NAME(sys_reboot)
	.long SYMBOL_NAME(old_readdir)
	.long SYMBOL_NAME(old_mmap)		/* 90 */
	.long SYMBOL_NAME(sys_munmap)
	.long SYMBOL_NAME(sys_truncate)
	.long SYMBOL_NAME(sys_ftruncate)
	.long SYMBOL_NAME(sys_fchmod)
	.long SYMBOL_NAME(sys_fchown16)		/* 95 */
	.long SYMBOL_NAME(sys_getpriority)
	.long SYMBOL_NAME(sys_setpriority)
	.long SYMBOL_NAME(sys_ni_syscall)	/* old profil syscall holder */
	.long SYMBOL_NAME(sys_statfs)
	.long SYMBOL_NAME(sys_fstatfs)		/* 100 */
	.long SYMBOL_NAME(sys_ioperm)		/* Just a dummy function */
	.long SYMBOL_NAME(sys_socketcall)
	.long SYMBOL_NAME(sys_syslog)
	.long SYMBOL_NAME(sys_setitimer)
	.long SYMBOL_NAME(sys_getitimer)	/* 105 */
	.long SYMBOL_NAME(sys_newstat)
	.long SYMBOL_NAME(sys_newlstat)
	.long SYMBOL_NAME(sys_newfstat)
	.long SYMBOL_NAME(sys_ni_syscall)	/* old uname syscall holder */
	.long SYMBOL_NAME(sys_ni_syscall)	/* 110 - iopl for i386 */
	.long SYMBOL_NAME(sys_vhangup)
	.long SYMBOL_NAME(sys_ni_syscall)	/* obsolete idle syscall */
	.long SYMBOL_NAME(sys_ni_syscall)	/* vm86old for i386 */
	.long SYMBOL_NAME(sys_wait4)
	.long SYMBOL_NAME(sys_swapoff)		/* 115 - Just dummy function */
	.long SYMBOL_NAME(sys_sysinfo)
	.long SYMBOL_NAME(sys_ipc)
	.long SYMBOL_NAME(sys_fsync)
	.long SYMBOL_NAME(sys_sigreturn)
	.long SYMBOL_NAME(sys_clone)		/* 120 */
	.long SYMBOL_NAME(sys_setdomainname)
	.long SYMBOL_NAME(sys_newuname)
	.long SYMBOL_NAME(sys_cacheflush)
	.long SYMBOL_NAME(sys_adjtimex)
	.long SYMBOL_NAME(sys_mprotect)		/* 125 - Just dummy function */
	.long SYMBOL_NAME(sys_sigprocmask)
	.long SYMBOL_NAME(sys_create_module)
	.long SYMBOL_NAME(sys_init_module)
	.long SYMBOL_NAME(sys_delete_module)
	.long SYMBOL_NAME(sys_get_kernel_syms)	/* 130 */
	.long SYMBOL_NAME(sys_quotactl)
	.long SYMBOL_NAME(sys_getpgid)
	.long SYMBOL_NAME(sys_fchdir)
	.long SYMBOL_NAME(sys_bdflush)
	.long SYMBOL_NAME(sys_sysfs)		/* 135 */
	.long SYMBOL_NAME(sys_personality)
	.long SYMBOL_NAME(sys_ni_syscall)	/* afs syscall holder */
	.long SYMBOL_NAME(sys_setfsuid16)
	.long SYMBOL_NAME(sys_setfsgid16)
	.long SYMBOL_NAME(sys_llseek)		/* 140 */
	.long SYMBOL_NAME(sys_getdents)
	.long SYMBOL_NAME(sys_select)
	.long SYMBOL_NAME(sys_flock)
	.long SYMBOL_NAME(sys_msync)		/* Just dummy function */
	.long SYMBOL_NAME(sys_readv)		/* 145 */
	.long SYMBOL_NAME(sys_writev)
	.long SYMBOL_NAME(sys_getsid)
	.long SYMBOL_NAME(sys_fdatasync)
	.long SYMBOL_NAME(sys_sysctl)
	.long SYMBOL_NAME(sys_mlock)		/* 150 - Just dummy function */
	.long SYMBOL_NAME(sys_munlock)		/* Just dummy function */
	.long SYMBOL_NAME(sys_mlockall)		/* Just dummy function */
	.long SYMBOL_NAME(sys_munlockall)	/* Just dummy function */
	.long SYMBOL_NAME(sys_sched_setparam)
	.long SYMBOL_NAME(sys_sched_getparam)   /* 155 */
	.long SYMBOL_NAME(sys_sched_setscheduler)
	.long SYMBOL_NAME(sys_sched_getscheduler)
	.long SYMBOL_NAME(sys_sched_yield)
	.long SYMBOL_NAME(sys_sched_get_priority_max)
	.long SYMBOL_NAME(sys_sched_get_priority_min)  /* 160 */
	.long SYMBOL_NAME(sys_sched_rr_get_interval)
	.long SYMBOL_NAME(sys_nanosleep)
	.long SYMBOL_NAME(sys_mremap)		/* Just dummy function */
	.long SYMBOL_NAME(sys_setresuid16)
	.long SYMBOL_NAME(sys_getresuid16)	/* 165 */
	.long SYMBOL_NAME(sys_ni_syscall)	/* vm86 syscall holder */
	.long SYMBOL_NAME(sys_query_module)
	.long SYMBOL_NAME(sys_poll)
	.long SYMBOL_NAME(sys_nfsservctl)
	.long SYMBOL_NAME(sys_setresgid16)	/* 170 */
	.long SYMBOL_NAME(sys_getresgid16)
	.long SYMBOL_NAME(sys_prctl)
	.long SYMBOL_NAME(sys_rt_sigreturn)
	.long SYMBOL_NAME(sys_rt_sigaction)
	.long SYMBOL_NAME(sys_rt_sigprocmask)	/* 175 */
	.long SYMBOL_NAME(sys_rt_sigpending)
	.long SYMBOL_NAME(sys_rt_sigtimedwait)
	.long SYMBOL_NAME(sys_rt_sigqueueinfo)
	.long SYMBOL_NAME(sys_rt_sigsuspend)
	.long SYMBOL_NAME(sys_pread)		/* 180 */
	.long SYMBOL_NAME(sys_pwrite)
	.long SYMBOL_NAME(sys_lchown16);
	.long SYMBOL_NAME(sys_getcwd)
	.long SYMBOL_NAME(sys_capget)
	.long SYMBOL_NAME(sys_capset)           /* 185 */
	.long SYMBOL_NAME(sys_sigaltstack)
	.long SYMBOL_NAME(sys_sendfile)
	.long SYMBOL_NAME(sys_ni_syscall)	/* streams1 syscall holder */
	.long SYMBOL_NAME(sys_ni_syscall)	/* streams2 syscall holder */
	.long SYMBOL_NAME(sys_vfork)            /* 190 */
	.long SYMBOL_NAME(sys_getrlimit)
	.long SYMBOL_NAME(sys_mmap2)
	.long SYMBOL_NAME(sys_truncate64)
	.long SYMBOL_NAME(sys_ftruncate64)
	.long SYMBOL_NAME(sys_stat64)		/* 195 */
	.long SYMBOL_NAME(sys_lstat64)
	.long SYMBOL_NAME(sys_fstat64)
	.long SYMBOL_NAME(sys_chown)
	.long SYMBOL_NAME(sys_getuid)
	.long SYMBOL_NAME(sys_getgid)		/* 200 */
	.long SYMBOL_NAME(sys_geteuid)
	.long SYMBOL_NAME(sys_getegid)
	.long SYMBOL_NAME(sys_setreuid)
	.long SYMBOL_NAME(sys_setregid)
	.long SYMBOL_NAME(sys_getgroups)	/* 205 */
	.long SYMBOL_NAME(sys_setgroups)
	.long SYMBOL_NAME(sys_fchown)
	.long SYMBOL_NAME(sys_setresuid)
	.long SYMBOL_NAME(sys_getresuid)
	.long SYMBOL_NAME(sys_setresgid)	/* 210 */
	.long SYMBOL_NAME(sys_getresgid)
	.long SYMBOL_NAME(sys_lchown)
	.long SYMBOL_NAME(sys_setuid)
	.long SYMBOL_NAME(sys_setgid)
	.long SYMBOL_NAME(sys_setfsuid)		/* 215 */
	.long SYMBOL_NAME(sys_setfsgid)
	.long SYMBOL_NAME(sys_pivot_root)
	.long SYMBOL_NAME(sys_ni_syscall)	/* mincore syscall holder */
	.long SYMBOL_NAME(sys_ni_syscall)	/* madvise syscall holder */
	.long SYMBOL_NAME(sys_getdents64)	/* 220 */
	.long SYMBOL_NAME(sys_gettid)
	.long SYMBOL_NAME(sys_tkill)
	.long SYMBOL_NAME(sys_setxattr)
	.long SYMBOL_NAME(sys_lsetxattr)
	.long SYMBOL_NAME(sys_fsetxattr)	/* 225 */
	.long SYMBOL_NAME(sys_getxattr)
	.long SYMBOL_NAME(sys_lgetxattr)
	.long SYMBOL_NAME(sys_fgetxattr)
	.long SYMBOL_NAME(sys_listxattr)
	.long SYMBOL_NAME(sys_llistxattr)	/* 230 */
	.long SYMBOL_NAME(sys_flistxattr)
	.long SYMBOL_NAME(sys_removexattr)
	.long SYMBOL_NAME(sys_lremovexattr)
	.long SYMBOL_NAME(sys_fremovexattr)
	.long SYMBOL_NAME(sys_dmacpy)
	.long SYMBOL_NAME(sys_sysfun)

	.rept NR_syscalls-(.-SYMBOL_NAME(sys_call_table))/4
		.long SYMBOL_NAME(sys_ni_syscall)
	.endr
