/*
 * linux/arch/ckcorenommu/platform/DH2004/ints.c -- General interrupt handling code
 *
 * Copyright (C) 1999  Greg Ungerer (gerg@snapgear.com)
 * Copyright (C) 1998  D. Jeff Dionne <jeff@ArcturusNetworks.com>
 *                     Kenneth Albanowski <kjahds@kjahds.com>,
 * Copyright (C) 2000  Lineo Inc. (www.lineo.com) 
 *
 * Copyright (C) 2004  Kang Sun <sunk@vlsi.zju.edu.cn>
 *
 * Based on:
 *
 * linux/arch/m68k/kernel/ints.c -- Linux/m68k general interrupt handling code
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file COPYING in the main directory of this archive
 * for more details.
 */

#include <linux/types.h>
#include <linux/sched.h>
#include <linux/kernel_stat.h>
#include <linux/errno.h>
#include <linux/config.h>
#include <linux/mm.h>
#include <linux/interrupt.h>

#include <asm/system.h>
#include <asm/irq.h>
#include <asm/traps.h>
#include <asm/page.h>
#include <asm/machdep.h>
#include <asm/pci_hardware.h>

/*
 *	This table stores the address info for each vector handler.
 */
irq_handler_t irq_list[SYS_IRQS];

unsigned int *mach_kstat_irqs;

unsigned int *irq_kstat_interrupt; // added by Kang Sun 2004.10.07

/* The number of spurious interrupts */
volatile unsigned int num_spurious;

unsigned int local_bh_count[NR_CPUS];
unsigned int local_irq_count[NR_CPUS];

static void default_irq_handler(int irq, void *ptr, struct pt_regs *regs)
{
//    (*PLD_CPU_ISTATUS) |= cpu_to_le32(PLD_INTA_ENABLE);//clear the status;
    if (irq == 35)
    {
        printk("Too fast interrupt found, cancel it %x and %x \n", irq_list[35], default_irq_handler);
    }
#if 1
	printk("%s(%d): default irq handler vec=%d [0x%x]\n",
		__FILE__, __LINE__, irq, irq);
#endif
}

/*zhc add for irq share start*/
#define ACTION_NUMBER 0x10//here I only add 0x10 irq server for shareirq.
#define ACTION_START     32//I set start pci inter pin on 35, so I found list with it as index
static struct irqaction *action_list[ACTION_NUMBER];
/*zhc add for irq share end*/
/*
 * void init_IRQ(void)
 *
 * Parameters:	None
 *
 * Returns:	Nothing
 *
 * This function should be called during kernel startup to initialize
 * the IRQ handling routines.
 */

void init_IRQ(void)
{
	int i;
	

	for (i = 0; i < SYS_IRQS; i++) {
		if (mach_default_handler)
			irq_list[i].handler = (*mach_default_handler)[i];
		else
			irq_list[i].handler = default_irq_handler;
		irq_list[i].flags   = IRQ_FLG_STD;
		irq_list[i].dev_id  = NULL;
		irq_list[i].devname = NULL;
	}
  /*zhc add for irq share start*/
    for (i = 0; i < ACTION_NUMBER; i++)
      {
          action_list[i] = NULL;
      }
  /*zhc add for irq share end*/

    //printk("IRQ initial with handler\n");

	if (mach_init_IRQ)
		mach_init_IRQ ();
	mach_kstat_irqs = &kstat.irqs[0][0];
}

  /*zhc add for irq share start*/
//here dev_id is useless, for i share irq only according irq
//This function run as a interrupt server, and so I need't modify the process int in entry.S
static void shirq_server(unsigned int irq, void *dev_id, struct pt_regs * pt)
{
    struct irqaction * action;
    
#ifdef __BIG_ENDIAN
    (*PLD_CPU_IMASK) &= ~(cpu_to_le32(PLD_INTA_ENABLE));//disable the next interrupt
    (*PLD_CPU_ISTATUS) |= (cpu_to_le32(PLD_INTA_ENABLE));//clear the status;
    (*PLD_CPU_ISTATUS) |= (cpu_to_le32(PLD_WRITE_DMA_END));//clear the status;
#else
    (*PLD_CPU_IMASK) &= ~((PLD_INTA_ENABLE));//disable the next interrupt
    (*PLD_CPU_ISTATUS) |= ((PLD_INTA_ENABLE));//clear the status;
    (*PLD_CPU_ISTATUS) |= ((PLD_WRITE_DMA_END));//clear the status;
#endif

    action = action_list[irq - ACTION_START];

    if (!action)
    {
          printk("irq not alloced\n");
          return ;
    }
    do
    {
        if (action->handler)
        {
          action->handler(irq, action->dev_id, pt);
        }
	    action = action->next;
	    
    }while(action);

#ifdef __BIG_ENDIAN
    (*PLD_CPU_ISTATUS) |= (cpu_to_le32(PLD_WRITE_DMA_END));//clear the status;
    (*PLD_CPU_ISTATUS) |= cpu_to_le32(PLD_INTA_ENABLE);//enable the next interrupt
    (*PLD_CPU_IMASK) |= (cpu_to_le32(PLD_INTA_ENABLE));//disable the next interrupt
#else
    (*PLD_CPU_ISTATUS) |= ((PLD_WRITE_DMA_END));//clear the status;
    (*PLD_CPU_ISTATUS) |= (PLD_INTA_ENABLE);//enable the next interrupt
    (*PLD_CPU_IMASK) |= ((PLD_INTA_ENABLE));//disable the next interrupt
#endif

}
  
void shirq_append(unsigned int irq, void (*handler)(int, void *, struct pt_regs *), \
  unsigned long flags, const char *devname, void *dev_id)
{
    struct irqaction *action;
    
    action = (struct irqaction *)kmalloc(sizeof(struct irqaction), GFP_KERNEL);
	    if (!action)
		    return;

        printk("action found %x and actionlist %x\n", action, dev_id);
	    action->handler = handler;
	    action->flags = flags;
	    action->mask = 0;
	    action->name = devname;
	    action->next = NULL;
      	action->dev_id = dev_id;

    if (!action_list[irq - ACTION_START])//create a null irqaction
    {
        action_list[irq - ACTION_START] = action;
    }else//share the irq
    {
        struct irqaction *action_tmp;
        
        action_tmp = action_list[irq - ACTION_START];
//        printk("action_tmp value %x and next %x\n", action_tmp, action_tmp->next);
        local_irq_disable();
        do
        {
              if (!action_tmp->next)//I found the list end, so I append my new share irq.
                break;
              action_tmp = action_tmp->next;
        }while(1);
        action_tmp->next = action;//I append it;
        local_irq_enable();
//        printk("action_tmp value %x and next %x\n", action_tmp->next->handler , action_tmp->handler);
    }
    return;
}
  /*zhc add for irq share end*/

int request_irq(unsigned int irq, void (*handler)(int, void *, struct pt_regs *),
                unsigned long flags, const char *devname, void *dev_id)
{

	if ((irq & IRQ_MACHSPEC) && mach_request_irq) {
        printk("I am start a unknow mach request irq\n");
		return mach_request_irq(IRQ_IDX(irq), handler, flags,
			devname, dev_id);
	}

	if (irq < 0 || irq >= NR_IRQS) {
		printk("%s: Incorrect IRQ %d from %s\n", __FUNCTION__,
			irq, devname);
		return -ENXIO;
	}

	if (!(irq_list[irq].flags & IRQ_FLG_STD)) {
		if (irq_list[irq].flags & IRQ_FLG_LOCK) {
			printk("%s: IRQ %d from %s is not replaceable\n",
			       __FUNCTION__, irq, irq_list[irq].devname);
			return -EBUSY;
		}
		if (flags & IRQ_FLG_REPLACE) {
			printk("%s: %s can't replace IRQ %d from %s\n",
			       __FUNCTION__, devname, irq, irq_list[irq].devname);
			return -EBUSY;
		}
	}
#if 0
	if (flags & IRQ_FLG_FAST) {
		extern asmlinkage void fasthandler(void);
		extern void set_evector(int vecnum, void (*handler)(void));
		set_evector(irq, fasthandler);
	}
#endif
/*zhc add begin for SA_SHIRQ added*/
	if (flags & SA_SHIRQ) {
//      if ((irq_list[irq].handler) == default_irq_handler)
      {
      	  irq_list[irq].handler = shirq_server;
          irq_list[irq].flags   = flags;
   	  irq_list[irq].dev_id  = (void *)irq;//here I should know the index of action_list
	  irq_list[irq].devname = NULL;
          printk("irq %x ship sever found %x and default hadnler %x\n", shirq_server, default_irq_handler);
      }
      shirq_append(irq, handler, flags, devname, dev_id);//actural interrupt params is here
      printk("dev %s with id %x add irq %ld\n", devname, dev_id, irq);
      return 0;
  }
/*zhc add end for SA_SHIRQ added*/
	irq_list[irq].handler = handler;
	irq_list[irq].flags   = flags;
	irq_list[irq].dev_id  = dev_id;
	irq_list[irq].devname = devname;
	return 0;
}


//here zhc has not free the action list handler
void free_irq(unsigned int irq, void *dev_id)
{

	if (irq & IRQ_MACHSPEC) {
		mach_free_irq(IRQ_IDX(irq), dev_id);
		return;
	}

	if (irq < 0 || irq >= NR_IRQS) {
		printk("%s: Incorrect IRQ %d\n", __FUNCTION__, irq);
		return;
	}

    //I judge that it is a shared irq, so I will free it;
    /*zhc add for share irq start*/
    if (irq_list[irq].flags &SA_SHIRQ)
    {
        if ((irq > ACTION_START)&&(action_list[irq - ACTION_START]))
        {//free action_list
            struct irqaction *action, *action_old;

            action = action_list[irq - ACTION_START];
            if (!action)
            {
                printk("no shared server for irq %ld", irq);
                return;
            }
            action_old = action;
            do
            {
                if (action->dev_id == dev_id)//here I found a irq to be free
                  {
                      if((action_old == action)&&(!action->next))//found the last action, I will free the list
                        {
                            action_list[irq - ACTION_START] = NULL;
                            kfree(action);
                            break;//continue to release irq server
                        }else//here I only releas a node of this action
                          {
                              if (action_old == action)
                                {
                                    action_list[irq - ACTION_START] = action->next;
                                }else
                                {
                                    action_old->next = action->next;//remove action from this action;
                                 }
                              kfree(action);
                              return;//here this share irq still useful
                          }
                  }
                action_old = action;
                action = action->next;
            }while(action);
            
            printk("I am free action_list\n");
        
        /*zhc add for share irq start*/
        }//else
    }else if (irq_list[irq].dev_id != dev_id)//share irq's dev_id is irq, may dev_id be a number such as 35?
    {
      	printk("%s: Removing probably wrong IRQ %d from %s\n",
		       __FUNCTION__, irq, irq_list[irq].devname);
    }
	if (irq_list[irq].dev_id != dev_id)
		printk("%s: Removing probably wrong IRQ %d from %s\n",
		       __FUNCTION__, irq, irq_list[irq].devname);
	if (irq_list[irq].flags & IRQ_FLG_FAST) {
		extern asmlinkage void inthandler(void);
		extern void set_evector(int vecnum, void (*handler)(void));
		set_evector(irq, inthandler);
	}

	if (mach_default_handler)
		irq_list[irq].handler = (*mach_default_handler)[irq];
	else
		irq_list[irq].handler = default_irq_handler;
	irq_list[irq].flags   = IRQ_FLG_STD;
	irq_list[irq].dev_id  = NULL;
	irq_list[irq].devname = NULL;
}


int sys_request_irq(unsigned int irq, 
                    void (*handler)(int, void *, struct pt_regs *), 
                    unsigned long flags, const char *devname, void *dev_id)
{
#if 0
	if (!(irq_list[irq].flags & IRQ_FLG_STD)) {
		if (irq_list[irq].flags & IRQ_FLG_LOCK) {
			printk("%s: IRQ %d from %s is not replaceable\n",
			       __FUNCTION__, irq, irq_list[irq].devname);
			return -EBUSY;
		}
		if (!(flags & IRQ_FLG_REPLACE)) {
			printk("%s: %s can't replace IRQ %d from %s\n",
			       __FUNCTION__, devname, irq, irq_list[irq].devname);
			return -EBUSY;
		}
	}
#endif

	irq_list[irq].handler = handler;
	irq_list[irq].flags   = flags;
	irq_list[irq].dev_id  = dev_id;
	irq_list[irq].devname = devname;
	return 0;
}

void sys_free_irq(unsigned int irq, void *dev_id)
{

	if (irq_list[irq].dev_id != dev_id)
		printk("%s: Removing probably wrong IRQ %d from %s\n",
		       __FUNCTION__, irq, irq_list[irq].devname);

	irq_list[irq].handler = (*mach_default_handler)[irq];
	irq_list[irq].flags   = 0;
	irq_list[irq].dev_id  = NULL;
	// irq_list[irq].devname = default_names[irq];
}

/*
 * Do we need these probe functions on the m68k?
 *
 *  ... may be usefull with ISA devices
 */
unsigned long probe_irq_on (void)
{
	return 0;
}

int probe_irq_off (unsigned long irqs)
{
	return 0;
}

asmlinkage void process_int(unsigned long vec, struct pt_regs *fp)
{
	if (vec >= VEC_INT1 && vec <= VEC_INT8) {
		vec -= VEC_XXX;       // FIXME: Define the #32 intr is XXX interrupt.
		kstat.irqs[0][vec]++;
		irq_list[vec].handler(vec, irq_list[vec].dev_id, fp);
	} else {
		if (mach_process_int)
			mach_process_int(vec, fp);
		else
			panic("Can't process interrupt vector %ld\n", vec);
		return;
	}
}


int get_irq_list(char *buf)
{
	int i, len = 0;

	for (i = 0; i < NR_IRQS; i++) {
		if (irq_list[i].flags & IRQ_FLG_STD)
			continue;

		len += sprintf(buf+len, "%3d: %10u ", i,
		               i ? kstat.irqs[0][i] : num_spurious);
		if (irq_list[i].flags & IRQ_FLG_LOCK)
			len += sprintf(buf+len, "L ");
		else
			len += sprintf(buf+len, "  ");
		len += sprintf(buf+len, "%s\n", irq_list[i].devname);
	}

	if (mach_get_irq_list)
		len += mach_get_irq_list(buf+len);
	return len;
}

void init_irq_proc(void);
void init_irq_proc(void)
{
	/* Insert /proc/irq driver here */
}

