/*
   -------------------------------------------------------------------------
   i2c-adap-ite.c i2c-hw access for the IIC peripheral on the ITE MIPS system
   -------------------------------------------------------------------------
   Hai-Pao Fan, MontaVista Software, Inc.
   hpfan@mvista.com or source@mvista.com

   Copyright 2001 MontaVista Software Inc.

   ----------------------------------------------------------------------------
   This file was highly leveraged from i2c-elektor.c, which was created
   by Simon G. Vogl and Hans Berglund:

 
     Copyright (C) 1995-97 Simon G. Vogl
                   1998-99 Hans Berglund

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		     */
/* ------------------------------------------------------------------------- */

/* With some changes from Kysti Mlkki <kmalkki@cc.hut.fi> and even
   Frodo Looijaard <frodol@dds.nl> */

#include <linux/kernel.h>
#include <linux/ioport.h>
#include <linux/module.h>
#include <linux/delay.h>
#include <linux/slab.h>
#include <linux/version.h>
#include <linux/init.h>

#include <asm/ckcore.h>
#include <asm/irq.h>
#include <asm/io.h>

#include <linux/i2c.h>
#include <linux/i2c-algo-dahua.h>
//#include <linux/i2c-adap-ck.h>
#include "i2c-dahua.h"

#define CKCORE_ZXJ_IIC
//#undef CKCORE_ZXJ_IIC

#define DEFAULT_BASE 0x43000000

#define PIC_IRQ_I2C 42

static int base   = 0;
static int irq    = PIC_IRQ_I2C;
static int clock  = 30;//100khz //0x1c;
static int own    = 0x55;
//static int mmapped = 0;
static int i2c_debug = 0;

/* vdovikin: removed static struct i2c_dahua_isa gpi; code - 
  this module in real supports only one device, due to missing arguments
  in some functions, called from the algo-dahua module. Sometimes it's
  need to be rewriten - but for now just remove this for simpler reading */

#if (LINUX_VERSION_CODE < 0x020301)
static struct wait_queue *dahua_wait = NULL;
#else
static wait_queue_head_t dahua_wait;
#endif
static int dahua_pending = 0;

/* ----- global defines -----------------------------------------------	*/
#define DEB(x)	if (i2c_debug>=1) x
#define DEB2(x) if (i2c_debug>=2) x
#define DEB3(x) if (i2c_debug>=3) x
#define DEBE(x)	x	/* error messages 				*/

/* add by zxj 2009-05-12 */
#ifdef CKCORE_ZXJ_IIC
/* IIC Register descriptors */
#define CKCORE_IIC_PRERH	0x4300001A
#define CKCORE_IIC_PRERL	0x4300001E
#define CKCORE_IIC_TXR		0x4300000A
#define CKCORE_IIC_RXR		0x4300000E
#define CKCORE_IIC_CTR		0x43000012
#define CKCORE_IIC_CR		0x43000016
#define CKCORE_IIC_SR		0x43000006

// ctr register
#define CKCORE_IIC_EN			7
#define CKCORE_IIC_IEN			6

// command register(cr)
#define CKCORE_IIC_STA			7
#define CKCORE_IIC_STP			6
#define CKCORE_IIC_WR			5
#define CKCORE_IIC_RD			4
#define CKCORE_IIC_IACK			3
#define CKCORE_IIC_ACK			2

// Status register(sr)
#define CKCORE_IIC_RXACK		7
#define CKCORE_IIC_BUSY			6
#define CKCORE_IIC_AL			5
#define CKCORE_IIC_TIP			4
#define CKCORE_IIC_IFLAG		3
#define CKCORE_IIC_IFLAGQUERY	2

// command register default value
#define CKCORE_IIC_CRDEF		0x04

#define IIC_CMD_EN				( 1 << CKCORE_IIC_EN )
#define IIC_CMD_START			( 1 << CKCORE_IIC_STA )
#define IIC_CMD_STOP			( 1 << CKCORE_IIC_STP )
#define IIC_CMD_SEND_END		( ( 1 << CKCORE_IIC_WR ) + ( 1 << CKCORE_IIC_ACK) )
#define IIC_CMD_SEND_CONTINUE	IIC_CMD_SEND_END
#define IIC_CMD_REV_END			( ( 1 << CKCORE_IIC_RD ) + ( 1 << CKCORE_IIC_ACK) )
#define IIC_CMD_REV_CONTINUE	( 1 << CKCORE_IIC_RD )


#define IIC_CMD_START_REV_END	IIC_CMD_START | IIC_CMD_REV_END

//send a start single and write the device address for write at once
#define IIC_CMD_STA_DEVADDR_W	IIC_CMD_START | IIC_CMD_SEND_CONTINUE

// send a start singke and write the device address for read at once
#define IIC_CMD_STA_DEVADDR_R	IIC_CMD_START | IIC_CMD_SEND_CONTINUE

#endif

/* ----- local functions ----------------------------------------------	*/

static void dahua_ck_setbyte(void *data, int regno, int val)
{
	int address =  base + regno;
	
	*((volatile unsigned char *)address) = val;
	
#ifdef CKCORE_ZXJ_IIC


  	unsigned char tmp;
	unsigned int tout;
	
	if ( ( CKCORE_IIC_CR == address ) && ( I2C_CMD_NULL != val ) )
    {
    	tout = 0;
    	while(1)
    	{
    		tmp = *(volatile unsigned char *)CKCORE_IIC_CR;
    		
    		if( CKCORE_IIC_CRDEF == tmp )
    		{
    			break;
    		}
    		tout++;
    		
    		if( tout > 0x1fffff )
    		{
    		    printk("i2c time out\n");
    			break;
    		}
    	}          
    }
 
#endif

}

static int dahua_ck_getbyte(void *data, int regno)
{
	int address = base + regno;
	int val = *((volatile unsigned char *)address);
	return (val);
}

static int dahua_ck_getown(void *data)
{
	return (own);
}

static int dahua_ck_getclock(void *data)
{
	return (I2C_PRER(clock));
}

static void dahua_ck_waitforpin(void) {

	int timeout = 2;

	if (irq > 0) {
		DEB2(printk("\n\n sleep wait for %x interrupt \n", irq);)
//		cli();
//		if (dahua_pending == 0) {
			interruptible_sleep_on_timeout(&dahua_wait, timeout*HZ );
//		} else
	//		dahua_pending = 0;
//		sti();
		DEB2(printk("\n\n wake up from %x interrupt \n", irq);)
	} else {
		udelay(100);
	}
//	udelay(500);
}


static void dahua_ck_handler(int this_irq, void *dev_id, struct pt_regs *regs) 
{
	//unsigned char tmp;
	
	dahua_pending = 1;
	
	//tmp = *(unsigned char *)(0x43000012);
	
	//printk("I2C_CTR = %#x\n", tmp);
	
	DEB2(printk("interrupt found\n");)
	
	//tmp = *(volatile unsigned char *)CKCORE_IIC_SR;
	
	//printk( "I2C_SR = %#x,  ww = %#x\n", tmp, &dahua_wait );
	
	//if ( CKCORE_IIC_CRDEF == tmp )
	//{
		wake_up_interruptible(&dahua_wait);		
	//}
	
}


static int dahua_ck_init(void)
{
/*	if (!mmapped) {
		if (check_region(base, 2) < 0 ) {
			printk("i2c-elektor.o: requested I/O region (0x%X:2) is in use.\n", base);
			return -ENODEV;
		} else {
			request_region(base, 2, "i2c (ck bus adapter)");
		}
	}*/
	if (irq > 0) {
		if (request_irq(irq, dahua_ck_handler, 0, "DHCK", 0) < 0) {
			printk("i2c-ckcore.o: Request irq%d failed\n", irq);
			irq = 0;
		} else
		{
			enable_irq(irq);
		}
	}
	return 0;
}


static void __exit dahua_ck_exit(void)
{
	if (irq > 0) {
		disable_irq(irq);
		free_irq(irq, 0);
	}
//	if (!mmapped) {
//		release_region(base , 2);
//	}
}


static int dahua_ck_reg(struct i2c_client *client)
{
	return 0;
}


static int dahua_ck_unreg(struct i2c_client *client)
{
	return 0;
}

static void dahua_ck_inc_use(struct i2c_adapter *adap)
{
#ifdef MODULE
	MOD_INC_USE_COUNT;
#endif
}

static void dahua_ck_dec_use(struct i2c_adapter *adap)
{
#ifdef MODULE
	MOD_DEC_USE_COUNT;
#endif
}



/* ------------------------------------------------------------------------
 * Encapsulate the above functions in the correct operations structure.
 * This is only done when more than one hardware adapter is supported.
 */
static struct i2c_algo_dahua_data algo_ck_data = {
	NULL,
	dahua_ck_setbyte,
	dahua_ck_getbyte,
	dahua_ck_getown,
	dahua_ck_getclock,
	dahua_ck_waitforpin,
	10, 10, 100,		/*	waits, timeout */
};

static struct i2c_adapter dahua_ck_ops = {
	"DH CK adapter",
	I2C_HW_P_CK,
	NULL,
	&algo_ck_data,
	dahua_ck_inc_use,
	dahua_ck_dec_use,
	dahua_ck_reg,
	dahua_ck_unreg,
};


int __init i2c_dahuack_init(void) 
{

	printk("i2c-ckcore.o: i2c dahua-ck adapter module\n");

//	if (base == 0) {
		base = DEFAULT_BASE;
//	}

#if (LINUX_VERSION_CODE >= 0x020301)
	init_waitqueue_head(&dahua_wait);
#endif
	if (dahua_ck_init() == 0) {
		if (i2c_dahua_add_bus(&dahua_ck_ops) < 0)
			return -ENODEV;
	} else {
		return -ENODEV;
	}
	
	printk("i2c-ckcore.o: found device at %0x.\n", base);

	return 0;
}



EXPORT_NO_SYMBOLS;

#ifdef MODULE
MODULE_AUTHOR("Hans Berglund <hb@spacetec.no>");
MODULE_DESCRIPTION("I2C-Bus adapter routines for DH ISA bus adapter");
MODULE_LICENSE("GPL");

MODULE_PARM(base, "i");
MODULE_PARM(irq, "i");
MODULE_PARM(clock, "i");
MODULE_PARM(own, "i");
//MODULE_PARM(mmapped, "i");
MODULE_PARM(i2c_debug, "i");

int init_module(void) 
{
	return i2c_dahuack_init();
}

void cleanup_module(void) 
{
	i2c_dahua_del_bus(&dahua_ck_ops);
	dahua_ck_exit();
}

#endif
