/* ------------------------------------------------------------------------- */
/* i2c-algo-dahua.c i2c driver algorithms for dahua adapters		     */
/* ------------------------------------------------------------------------- */
/*   Copyright (C) 1995-1997 Simon G. Vogl
                   1998-2000 Hans Berglund

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		     */
/* ------------------------------------------------------------------------- */

/* With some changes from Kysti Mlkki <kmalkki@cc.hut.fi> and 
   Frodo Looijaard <frodol@dds.nl> ,and also from Martin Bailey
   <mbailey@littlefeet-inc.com> */

/* Partially rewriten by Oleg I. Vdovikin <vdovikin@jscc.ru> to handle multiple
   messages, proper stop/repstart signaling during receive,
   added detect code */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/delay.h>
#include <linux/slab.h>
#include <linux/version.h>
#include <linux/init.h>
#include <asm/uaccess.h>
#include <linux/ioport.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <asm/ckcore.h>

#include <linux/i2c.h>
#include <linux/i2c-algo-dahua.h>
#include "i2c-dahua.h"

/* ----- global defines ----------------------------------------------- */
#define DEB(x) if (i2c_debug>=1) x
#define DEB2(x) if (i2c_debug>=2) x
#define DEB3(x) if (i2c_debug>=3) x /* print several statistical values*/
#define DEBPROTO(x) if (i2c_debug>=9) x;
 	/* debug the protocol by showing transferred bits */
#define DEF_TIMEOUT 16

/* module parameters:
 */
static int i2c_debug=0;
static int dahua_scan=0;	/* have a look at what's hanging 'round		*/

/* --- setting states on the bus with the right timing: ---------------	*/

#define set_dahua(adap, regno, val) adap->setdahua(adap->data, regno, val)
#define get_dahua(adap, regno) adap->getdahua(adap->data, regno)
#define get_own(adap) adap->getown(adap->data)
#define get_clock(adap) adap->getclock(adap->data)
#define i2c_outb(adap, addr, val) adap->setdahua(adap->data, addr, val)
#define i2c_inb(adap, addr) adap->getdahua(adap->data, addr)

/* --- other auxiliary functions --------------------------------------	*/

static void i2c_start(struct i2c_algo_dahua_data *adap) 
{
	DEBPROTO(printk("S "));
	set_dahua(adap, I2C_REG_CR, I2C_CMD_STA | I2C_CMD_WR | I2C_CMD_NACK);//I2C_CR_STA);
}

static void i2c_repstart(struct i2c_algo_dahua_data *adap) 
{
	DEBPROTO(printk(" Sr "));
	set_dahua(adap, I2C_REG_CR, I2C_CMD_STA | I2C_CMD_WR | I2C_CMD_NACK);//I2C_CR_STA);
}


static void i2c_stop(struct i2c_algo_dahua_data *adap) 
{
	DEBPROTO(printk("P\n"));
//	udelay(200);
	set_dahua(adap, I2C_REG_CR, I2C_CR_STP);
}


static int wait_for_bb(struct i2c_algo_dahua_data *adap) {

	int timeout = DEF_TIMEOUT;
	int status;


	status = get_dahua(adap, I2C_REG_SR);
#ifndef STUB_I2C
	while (timeout-- && (status & I2C_SR_BUSY)) {
		udelay(100); // wait for 100 us 
		status = get_dahua(adap, I2C_REG_SR);
		set_dahua(adap, I2C_REG_CR, I2C_CMD_STP);
	//	printk("status read %x and cmd %x\n", status, get_dahua(adap, I2C_REG_CR));
	}
#endif

	
	/*
	//check cr register to be set default(0x04) ---modify by zxj 2008
	while(1)
	{
		timeout--;
		if( 0 == timeout )
			break;
			
		status = get_dahua(adap, I2C_REG_CR);
		printk( "status = 0x%02lx\n",status );
		if( 0x04 == status )
			break;
	}
	*/
	
	
	if (timeout <= 0) {
		printk("Timeout waiting for Bus Busy\n");
	}
	
	return (timeout<=0);
}


static inline void dahua_sleep(unsigned long timeout)
{
	schedule_timeout( timeout * HZ);
}


static int wait_for_pin(struct i2c_algo_dahua_data *adap, int *status) {

	int timeout = DEF_TIMEOUT;
	int rc;

//	*status = get_dahua(adap, I2C_REG_SR);
#ifndef STUB_I2C
//	while (timeout-- && (!(*status & I2C_SR_IFLAG_QUERY))) {
//	while (timeout-- ) {
//		printk("wait status %x\n", *status);
		adap->waitforpin();
//		*status = get_dahua(adap, I2C_REG_SR);
//	}
//	set_dahI2C_CR_IACK
#endif

/*
	while(1)
	{
		rc = get_dahua(adap, I2C_REG_CR);
		if( 0x04 ==  rc)
		{
			printk( "i2c ok\n" );
			break;
		}
			
		timeout--;
		if( 0 == timeout )
			break;
	}
*/
	if (timeout <= 0)
		return(-1);
	else
		return(0);
}

/* 
 * This should perform the 'dahua initialization sequence' as described
 * in the Philips IC12 data book (1995, Aug 29).
 * There should be a 30 clock cycle wait after reset, I assume this
 * has been fulfilled.
 * There should be a delay at the end equal to the longest I2C message
 * to synchronize the BB-bit (in multimaster systems). How long is
 * this? I assume 1 second is always long enough.
 *
 * vdovikin: added detect code for dahua
 */

/************************************************************************
 * Flush I2c Driver Data Structure
 ************************************************************************/
void dahua_i2c_flush(struct i2c_algo_dahua_data *adap)
{
	/* enable i2c to check					*/
	set_dahua(adap, I2C_REG_CTR, I2C_CTR_EN);
	set_dahua(adap, I2C_REG_TXR, 0xff);
	set_dahua(adap, I2C_REG_CR, I2C_CMD_RD|I2C_CMD_NACK );
	{
		int i = 0, j = 1000;

		for (i = 0; i < j; i++) if (get_dahua(adap, I2C_REG_CR) == 0) break;
		set_dahua(adap, I2C_REG_CR, I2C_CMD_STP);
		for (i = 0; i < j; i++) if (get_dahua(adap, I2C_REG_CR) == 0) break;
	}
	set_dahua(adap, I2C_REG_CR, I2C_CMD_NULL);
	set_dahua(adap, I2C_REG_SR, I2C_CMD_NULL);
	set_dahua(adap, I2C_REG_CTR, I2C_CTR_EN | I2C_CTR_IEN);
} /* end I2cFlush	*/

static int dahua_init (struct i2c_algo_dahua_data *adap)
{
	unsigned char temp;
	int tmpval = 0;

//	DEB3(printk("i2c-algo-dahua.o: dahua state 0x%02x\n", get_dahua(adap, I2C_REG_SR)));

	tmpval = get_clock(adap);
	/* set clock addr with calculated number */
	(printk("i2c-algo-dahua.o: dahua state 0x%02x clock %x\n", get_dahua(adap, I2C_REG_SR), tmpval));
	set_dahua(adap, I2C_REG_PRER_H, ((tmpval>>8)&0xff));
	set_dahua(adap, I2C_REG_PRER_L, ((tmpval)&0xff));

/*
	i2c_outb(adap, get_own(adap));

	if ((temp = i2c_inb(adap)) != get_own(adap)) {
		DEB2(printk("i2c-algo-dahua.o: dahua detection failed -- can't set S0 (0x%02x).\n", temp));
		return -ENXIO;
	}
*/
	dahua_i2c_flush(adap);
	DEB2(printk("i2c-algo-dahua.o: dahua after flush state 0x%02x clock %x\n", get_dahua(adap, I2C_REG_SR), tmpval));

	printk("i2c-algo-dahua.o: deteted and initialized DH.\n");

	return 0;
}


/* ----- Utility functions
 */

static inline int try_address(struct i2c_algo_dahua_data *adap,
		       unsigned char addr, int retries)
{
	int i, status, ret = -1;
	for (i=0;i<retries;i++) {
		i2c_outb(adap, I2C_REG_TXR, addr);
		i2c_start(adap);
//		i2c_outb(adap, I2C_REG_CR, I2C_CR_STA);

		status = get_dahua(adap, I2C_REG_SR);
		if (wait_for_pin(adap, &status) >= 0) {
			if ((status & I2C_SR_IFLAG_QUERY)) { 
				i2c_stop(adap);
				break;	/* success! */
			}
		}
		i2c_stop(adap);
		udelay(adap->udelay);
	}
	DEB2(if (i) printk("i2c-algo-dahua.o: needed %d retries for %d\n",i,
	                   addr));
	return ret;
}


static int dahua_sendbytes(struct i2c_adapter *i2c_adap, const char *buf,
                         int count, int last)
{
	struct i2c_algo_dahua_data *adap = i2c_adap->algo_data;
	int wrcount, status, timeout;
    
	for (wrcount=0; wrcount<count; ++wrcount) {
		DEB2(printk("i2c-algo-dahua.o: %s i2c_write: writing %2.2X\n",
		      i2c_adap->name, buf[wrcount]&0xff));
		//i2c_outb(adap, I2C_REG_TXR, buf[wrcount]);
		//i2c_outb(adap, I2C_REG_CR, I2C_CMD_WR  | I2C_CMD_NACK);
		set_dahua(adap, I2C_REG_TXR, buf[wrcount]);
		set_dahua(adap, I2C_REG_CR, I2C_CMD_WR  | I2C_CMD_NACK);
		timeout = wait_for_pin(adap, &status);
		if (timeout) {
			i2c_stop(adap);
			printk("i2c-algo-dahua.o: %s i2c_write: "
			       "error - timeout.\n", i2c_adap->name);
			return -EREMOTEIO; /* got a better one ?? */
		}
#ifndef STUB_I2C
/*		if (status & I2C_DH_LRB) {
			i2c_stop(adap);
			printk("i2c-algo-dahua.o: %s i2c_write: "
			       "error - no ack.\n", i2c_adap->name);
			return -EREMOTEIO; 
		}*/
#endif
	}
	/*
	if (last) {
		i2c_stop(adap);
	}
	else {
		i2c_repstart(adap);
	}
	*/
	return (wrcount);
}


static int dahua_readbytes(struct i2c_adapter *i2c_adap, char *buf,
                         int count, int last)
{
	int i, status;
	struct i2c_algo_dahua_data *adap = i2c_adap->algo_data;

	/* increment number of bytes to read by one -- read dummy byte */
	
	/*
	for (i = 0; i <= count; i++) {
		DEB2(printk("Read last value %x and i %x and count %x\n", last, i, count);)
		if (i <= count - 1) 
		{
			if( (count - 1) == i )
				set_dahua(adap, I2C_REG_CR, I2C_CR_RD | I2C_CMD_NACK);
			else
				set_dahua(adap, I2C_REG_CR, I2C_CR_RD | I2C_CMD_ACK);
//			set_dahua(adap, 1, I2C_DH_ESO);

			if (wait_for_pin(adap, &status)) {
				i2c_stop(adap);
				printk("i2c-algo-dahua.o: dahua_readbytes timed out.\n");
				return (-1);
			}
			#ifndef STUB_I2C
			if (status & I2C_STATUS_AL){
				i2c_stop(adap);
				printk("i2c-algo-dahua.o: i2c_read: i2c_inb, arbitor wrong.\n");
				return (-1);
			}
			#endif
		} */
		
		/*
		else if (i == count) 
		{
//			printk("Read last value %x\n", last);
			if (last) 
			{
				i2c_stop(adap);
			} else 
			{
				i2c_repstart(adap);
			}
		};
		
*/
		/*
		if (i) {
			buf[i - 1] = i2c_inb(adap, I2C_REG_RXR);
		} else {
			i2c_inb(adap, I2C_REG_RXR); // dummy read
		}
	}*/
	
	//modify by zxj 2008-07-12
	for (i = 0; i < count; i++) 
	{
		DEB2(printk("Read last value %x and i %x and count %x\n", last, i, count);)
		if( (count - 1) == i )
			set_dahua(adap, I2C_REG_CR, I2C_CR_RD | I2C_CMD_NACK);
		else
			set_dahua(adap, I2C_REG_CR, I2C_CR_RD | I2C_CMD_ACK);
			
		if (wait_for_pin(adap, &status)) 
		{
			i2c_stop(adap);
			printk("i2c-algo-dahua.o: dahua_readbytes timed out.\n");
			return (-1);
		}
		
		#ifndef STUB_I2C
			if (status & I2C_STATUS_AL)
			{
				i2c_stop(adap);
				printk("i2c-algo-dahua.o: i2c_read: i2c_inb, arbitor wrong.\n");
				return (-1);
			}
		#endif
		
		buf[i] = i2c_inb(adap, I2C_REG_RXR);
	}

	/*
	return (i - 1);	old
	*/
	
	return i;
}


static inline int dahua_doAddress(struct i2c_algo_dahua_data *adap,
                                struct i2c_msg *msg, int retries) 
{
	unsigned short flags = msg->flags;
	unsigned char addr;
	int ret;
	if ( (flags & I2C_M_TEN)  ) { 
/*		// a ten bit address 
		addr = 0xf0 | (( msg->addr >> 7) & 0x03);
		DEB2(printk("addr0: %d\n",addr));
		// try extended address code...
		ret = try_address(adap, addr, retries);
		if (ret!=1) {
			printk("died at extended address code.\n");
			return -EREMOTEIO;
		}
		// the remaining 8 bit address 
		i2c_outb(adap,msg->addr & 0x7f);
// Status check comes here 
		if (ret != 1) {
			printk("died at 2nd address code.\n");
			return -EREMOTEIO;
		}
		if ( flags & I2C_M_RD ) {
			i2c_repstart(adap);
			// okay, now switch into reading mode 
			addr |= 0x01;
			ret = try_address(adap, addr, retries);
			if (ret!=1) {
				printk("died at extended address code.\n");
				return -EREMOTEIO;
			}
		}*/
		printk("Ten bit address is not used here\n");
	} else {		/* normal 7bit address	*/
		addr = ( msg->addr << 1 );
		if (flags & I2C_M_RD )
			addr |= 1;
		if (flags & I2C_M_REV_DIR_ADDR )
			addr ^= 1;
		i2c_outb(adap, I2C_REG_TXR, addr);
	}
	return 0;
}

#define VS2801_IIC_FIX
//#undef VS2801_IIC_FIX

#ifdef VS2801_IIC_FIX
static spinlock_t logbuf_lock = SPIN_LOCK_UNLOCKED;
#endif


static int dahua_xfer(struct i2c_adapter *i2c_adap,
		    struct i2c_msg msgs[], 
		    int num)
{
	struct i2c_algo_dahua_data *adap = i2c_adap->algo_data;
	struct i2c_msg *pmsg;
	int i;
	int ret=0, timeout, status;

#ifdef VS2801_IIC_FIX
	unsigned long flags;
#endif
    

	
		DEB2(printk("i2c-algo-dahua.o: "
		            "begin dahua_xfer\n");)
	/* Check for bus busy */
	timeout = wait_for_bb(adap);
	if (timeout) {
		DEB2(printk("i2c-algo-dahua.o: "
		            "Timeout waiting for BB in dahua_xfer\n");)
		return -EIO;
	}
	
#ifdef VS2801_IIC_FIX
	spin_lock_irqsave(&logbuf_lock, flags);
#endif
	
	for (i = 0;ret >= 0 && i < num; i++) {
		pmsg = &msgs[i];

		DEB2(printk("i2c-algo-dahua.o: Doing %s %d bytes to 0x%02x - %d of %d messages\n",
		     pmsg->flags & I2C_M_RD ? "read" : "write",
                     pmsg->len, pmsg->addr, i + 1, num);)
    
		ret = dahua_doAddress(adap, pmsg, i2c_adap->retries);
		DEB2(printk("dahua end doAddress\n"));
		/* Send START */
		//if(i == 0)
		//{
			/*
			if( 0x51 == pmsg->addr )
			{
				//printk( "i2c start\n" );
				udelay(1000);
			}
			*/
			i2c_start(adap); 
			/* Wait for PIN (pending interrupt NOT) */
			
			timeout = wait_for_pin(adap, &status);
			if (timeout) {
				i2c_stop(adap);
				DEB2(printk("i2c-algo-dahua.o: Timeout waiting "
					    "for PIN(1) in dahua_xfer\n");)
				
				#ifdef VS2801_IIC_FIX
					spin_unlock_irqrestore(&logbuf_lock, flags);
				#endif
				
				return (-EREMOTEIO);
			}
		//}
    
    
		DEB2(printk("dahua start after doAddress\n"));
#ifndef STUB_I2C
		/* Check LRB (last rcvd bit - slave ack) */
//		if (status & I2C_DH_LRB) {
//			i2c_stop(adap);
//			DEB2(printk("i2c-algo-dahua.o: No LRB(1) in dahua_xfer\n");)
//			return (-EREMOTEIO);
//		}
#endif
    
/*		printk("i2c-algo-dahua.o: Msg %d, addr=0x%x, flags=0x%x, len=%d\n",\
			    i, msgs[i].addr, msgs[i].flags, msgs[i].len);*/
    
		/* Read */
		if (pmsg->flags & I2C_M_RD) {
			/* read bytes into buffer*/
			ret = dahua_readbytes(i2c_adap, pmsg->buf, pmsg->len,
                                            (i + 1 == num));
        
			if (ret != pmsg->len) {
				DEB2(printk("i2c-algo-dahua.o: fail: "
					    "only read %d bytes.\n",ret));
			} else {
				DEB2(printk("i2c-algo-dahua.o: read %d bytes.\n",ret));
			}
		} else { /* Write */
			ret = dahua_sendbytes(i2c_adap, pmsg->buf, pmsg->len,
                                            (i + 1 == num));
        
			if (ret != pmsg->len) {
				DEB2(printk("i2c-algo-dahua.o: fail: "
					    "only wrote %d bytes.\n",ret));
			} else {
				DEB2(printk("i2c-algo-dahua.o: wrote %d bytes.\n",ret));
			}
		}
		
		//zxj
		if( ( (i+1) == num) )
		{
			i2c_stop(adap);
			timeout = wait_for_pin(adap, &status);
			if (timeout) {
				i2c_stop(adap);
				DEB2(printk("i2c-algo-dahua.o: Timeout waiting "
					    "for PIN(1) in dahua_xfer\n");)
				
				#ifdef VS2801_IIC_FIX
					spin_unlock_irqrestore(&logbuf_lock, flags);
				#endif
				
				return (-EREMOTEIO);
			}
			udelay(9000);
		}
		//else 
			//i2c_repstart(adap);
		
		DEB2(printk("dahua end read and write\n"));
		
	}
#ifdef VS2801_IIC_FIX
	spin_unlock_irqrestore(&logbuf_lock, flags);
#endif

	return (i);
}

static int algo_control(struct i2c_adapter *adapter, 
	unsigned int cmd, unsigned long arg)
{
	return 0;
}

static u32 dh_func(struct i2c_adapter *adap)
{
	return I2C_FUNC_PROTOCOL_MANGLING | I2C_FUNC_SMBUS_QUICK; 
}


static struct i2c_algorithm dahua_algo = {
	"DH algorithm",
	I2C_ALGO_DH,
	dahua_xfer,
	NULL,
	NULL,				/* slave_xmit		*/
	NULL,				/* slave_recv		*/
	algo_control,			/* ioctl		*/
	dh_func,			/* functionality	*/
};

/* 
 * registering functions to load algorithms at runtime 
 */
int i2c_dahua_add_bus(struct i2c_adapter *adap)
{
	int i, status;
	struct i2c_algo_dahua_data *dahua_adap = adap->algo_data;

	DEB2(printk("i2c-algo-dahua.o: hw routines for %s registered.\n",
	            adap->name));

	/* register new adapter to i2c module... */

	adap->id |= dahua_algo.id;
	adap->algo = &dahua_algo;

	adap->timeout = 100;		/* default values, should	*/
	adap->retries = 3;		/* be replaced by defines	*/

	if ((i = dahua_init(dahua_adap))) {
		return i;
	}

#ifdef MODULE
	MOD_INC_USE_COUNT;
#endif

	i2c_add_adapter(adap);

	/* scan bus */
	if (dahua_scan) {
/*		printk(KERN_INFO " i2c-algo-dahua.o: scanning bus %s.\n",
		       adap->name);
		for (i = 0x00; i < 0xff; i+=2) {
			if (wait_for_bb(dahua_adap)) {
    			printk(KERN_INFO " i2c-algo-dahua.o: scanning bus %s - TIMEOUTed.\n",
		           adap->name);
			    break;
			}
			i2c_outb(dahua_adap, i);
			i2c_start(dahua_adap);
			if ((wait_for_pin(dahua_adap, &status) >= 0) && 
			    ((status & I2C_DH_LRB) == 0)) { 
				printk("(%02x)",i>>1); 
			} else {
				printk("."); 
			}
			i2c_stop(dahua_adap);
			udelay(dahua_adap->udelay);
		}
		printk("\n");*/
	}
	return 0;
}


int i2c_dahua_del_bus(struct i2c_adapter *adap)
{
	int res;
	if ((res = i2c_del_adapter(adap)) < 0)
		return res;
	DEB2(printk("i2c-algo-dahua.o: adapter unregistered: %s\n",adap->name));

#ifdef MODULE
	MOD_DEC_USE_COUNT;
#endif
	return 0;
}

int __init i2c_algo_dahua_init (void)
{
	printk("i2c-algo-dahua.o: i2c dahua algorithm module\n");
	return 0;
}

/*
EXPORT_SYMBOL(i2c_dahua_add_bus);
EXPORT_SYMBOL(i2c_dahua_del_bus);

#ifdef MODULE
MODULE_AUTHOR("Hongchun Zhou <zhou_goal@163.com>");
MODULE_DESCRIPTION("I2C-Bus CKCORE algorithm");
MODULE_LICENSE("GPL");

MODULE_PARM(dahua_scan, "i");
MODULE_PARM(i2c_debug,"i");

MODULE_PARM_DESC(dahua_scan, "Scan for active chips on the bus");
MODULE_PARM_DESC(i2c_debug,
        "debug level - 0 off; 1 normal; 2,3 more verbose; 9 dahua-protocol");


int init_module(void) 
{
	return i2c_algo_dahua_init();
}

void cleanup_module(void) 
{
}
#endif
*/
