#include "w25Q64cv.h"
#include <linux/slab.h>
#include <linux/module.h>
#include <linux/mtd/mtd.h>
#include <linux/mtd/spi_nand.h>
#include <linux/mtd/partitions.h>
#include <asm/io.h>
//#include <asm/arch/
#define PER_READ_COUNT          128
#define PER_WRITE_COUNT         124
#define FLASH_PAGE_SIZE 256
#define FLASH_TOTAL_SIZE 4*1024*1024

#define FLASH_WRITE_BUFMAX  24
static u8 g_u8FlashBuf[ 16 * 1024 ];


/*
 * MTD structure for w25q64cv 
 */
static struct mtd_info *w25q64cv_mtd = NULL;


#ifdef CONFIG_MTD_PARTITIONS
/*
 * Define static partitions for flash device
 */
static struct mtd_partition partition_info[] = {
#if 0	  
	{ name: "w25q64cv spi nand for userfs",
		  offset: 2*1024*1024,
		  size: 6*1024*1024 }
#endif
    { name: "user",
		  offset: 2*1024*1024,
		  size: 1*1024*1024 },/*1M*/
	{ name: "config",
		  offset: 3*1024*1024,
		  size: 512*1024 },	/*512K*/  
    { name: "backup",
		  offset: 3584*1024,
		  size: 512*1024 }	/*512K*/ 
};
#define NUM_PARTITIONS 3




extern int parse_cmdline_partitions(struct mtd_info *master, 
				    struct mtd_partition **pparts,
				    const char *mtd_id);
int w25q64cv_page_read(u8 *buf,u32 addr,u32 count);
int w25q64cv_page_program(u32 addr,u8 *data,u32 length,u8 endian);

#endif

int w25q64cv_read(u8 *buf,u32 addr,u32 count)
{  
    u32 baseaddr;
    u32 precnt, cnt;
    u8 *p;
    

    if(buf == NULL || addr > FLASH_TOTAL_SIZE || 0 == count)
    {
        return -1;
    }

    baseaddr = addr;
    precnt = 0;
    cnt = count;
    p = buf;
    
    while( 1 )
    {
        
        if ( 0 == cnt )
        {
            break;
        }
    
        if ( cnt > PER_READ_COUNT )
        {
            precnt = PER_READ_COUNT;
        }
        else
        {
            precnt = cnt;
        }
        
        w25q64cv_page_read( p, baseaddr, precnt);

        /* inc env */
        p += precnt;
        baseaddr += precnt;
        cnt -= precnt;
        
    }
    
    return 0;
}

static int w25q64cv_chk_busy( u32 u32TimeOut )
{
    u32 timeout, cmd, buf;
    int ret;
    
    /* check status */
    timeout = 0;
    ret = 0;
    
    while( 1 )
    {
        timeout ++;
        
        cmd = CMD_STATUS_READ << 24;
        spi_flash_mode_send_for_recv( SPI1TH, cmd, 1, &buf, 1 );
        
        if ( 0 == ( buf & 0x1 ) )
        {
            break;
        }
		
		if( timeout > 0xFFFFF )
		{
		    ret = -1;
			printk("time out %s function! status = %#x \n",__FUNCTION__, buf );
			
			break;
		}
    }
    
    return ret;
     
}

int w25q64cv_write(u8 *buf,u32 addr,u32 count,u8 endian)
{
    u32 baseaddr;
    u32 precnt, pagecnt, cnt;
    u8 *p;//, *pu8;
    
    //u32 readaddr, i;

    
    if(buf == NULL || addr > FLASH_TOTAL_SIZE || 0 == count)
    {
        //printk("please check argument in %s function! buf = 0x%08lx, addr = 0x%08lx,count = 0x%08lx\n",__FUNCTION__,buf,addr,count);
        return -1;
    }
    
    
#if 0
    printk("bw%#x->%#x\n", addr, count );
    
    
    readaddr = ( addr & 0xFFF ) + count;
    if ( readaddr > SECTOR_SIZE )
    {
        printk("-=====>ERRor\n");
    }
    */
    
    /* first to read */
    readaddr = ( addr & 0xFFFFF000 );
    
    
    w25q64cv_read( g_u8FlashBuf, readaddr, SECTOR_SIZE );
    
    /* check */
    pu8 = g_u8FlashBuf;
    pu8 += ( addr & 0xFFF );
    
    cnt = count;
    p = buf;
    baseaddr = addr;
    
    
    for ( i = 0; i < count; i ++ )
    {
        if ( 0xFF != *pu8 ++ )
        {
            /* earse the addr */
            w25q64cv_erase( readaddr, 1, flash_erase_4k_mode );
            
            
            /* copy back */
            pu8 = g_u8FlashBuf;
            pu8 += ( addr & 0xFFF );
            
            for ( i = 0; i < count; i ++ )
            {
                *pu8 ++ = buf[ i ];
            }
            
            cnt = SECTOR_SIZE;
            p = g_u8FlashBuf;
            baseaddr = readaddr;

            break;
        }
    }
#endif

    
    cnt = count;
    p = buf;
    baseaddr = addr;    
    precnt = 0;
    pagecnt = 0;
    
    
   // printk("aw%#x->%#x\n", baseaddr, cnt );

    while( 1 )
    {
        if ( 0 == cnt )
        {
            break;
        }

        /* дַҳ룬ֹҳдflash */
        pagecnt = ( FLASH_PAGE_SIZE - ( baseaddr & ( FLASH_PAGE_SIZE - 1 ) ) );
        
        if ( pagecnt > PER_WRITE_COUNT )
        {
            precnt = PER_WRITE_COUNT;
        }
        else
        {
            precnt = pagecnt;
        }

        /* жʣֹд */
        if ( precnt > cnt )
        {
            precnt = cnt;
        }


        w25q64cv_page_program( baseaddr, p, precnt, endian);

        /* inc env */
        baseaddr += precnt;
        p += precnt;
        cnt -= precnt;
        
    }
   
    return 0;

    
}

int w25q64cv_page_program(u32 addr,u8 *data,u32 length,u8 endian)
{
    u32 cmd = 0;
    int ret;

    
    if( addr > FLASH_TOTAL_SIZE)
    {
        printk("program addr out of flash range!\n");
        return -1;
    }
    
    if(NULL == data || 0 == length || length > PER_WRITE_COUNT)
    {
        printk("input parameter err!\n");
        return -1;
    }
    
    set_spi_dev_cs(SPI1TH, W25Q64CV_ADDR);
    
    
    ret = w25q64cv_chk_busy( 0xFFFFF );
    
    if ( 0 != ret )
    {
        printk("flash is busy status!\n");
        clear_spi_dev_cs( SPI1TH, W25Q64CV_ADDR );
        
        return -1;
    }
    
    cmd = CMD_WRITE_EN << 24;
    spi_normal_mode_send( SPI1TH, &cmd, 1 );

    spi_flash_mode_send_cmd_data( SPI1TH, CMD_PAGE_PROG, addr, data, length );
    
    ret = w25q64cv_chk_busy( 0xFFFFF );
    
    clear_spi_dev_cs( SPI1TH, W25Q64CV_ADDR );
    
    

    return 0;
}

int w25q64cv_page_read(u8 *buf,u32 addr,u32 count)
{  
    u32 senddata = 0;
    u32 wordcont;
    u32 temp = 0;
    u8 mod, i; 
    
    if(addr > FLASH_TOTAL_SIZE)
    {
        printk("program addr out of flash range!\n");
        return -1;
    }

    if(NULL == buf || 0 == count || count > PER_READ_COUNT)
    {
        printk("input parameter err!\n");
        return -1;
    }

    senddata = CMD_READ << 24;
    senddata |= addr;

  
    set_spi_dev_cs(SPI1TH, W25Q64CV_ADDR);

    spi_flash_mode_send_for_recv( SPI1TH, senddata, 4, (u32 *)buf, count );

    clear_spi_dev_cs(SPI1TH, W25Q64CV_ADDR);

    return 0;
}

int w25q64cv_erase(u32 startAddr,u32 sectorCont,u8 eraseMode)
{
    u32 i, cmd, baseaddr;
    u32 erase_block_size;
   
    if( startAddr % SECTOR_SIZE != 0 || 0 == sectorCont )
    {
        printk("erase sector addr invalud should be alignment sector,startAddr = 0x%08lx,sectorCont = 0x%x\n",startAddr,sectorCont);
        return -1;
    } 
    
    if( flash_erase_4k_mode == eraseMode )
    {
        erase_block_size = SECTOR_SIZE;
    }
    else if( flash_erase_32k_mode == eraseMode )
    {
        erase_block_size = BLOCK32_SIZE;      
    }
    else if( flash_erase_64k_mode == eraseMode )
    {
        erase_block_size = BLOCK64_SIZE;
    }else
    {
        printk(" erase block size err!\n");
        return -1;
    }
    
	set_spi_dev_cs(SPI1TH, W25Q64CV_ADDR);   
  
    /* loop to erase the blocks */
    baseaddr = startAddr;
    for ( i = 0 ; i < sectorCont; i ++ )
    {
        cmd = CMD_WRITE_EN << 24;
        spi_normal_mode_send(SPI1TH, &cmd, 1); 
        
        
        
        spi_flash_mode_send_cmd_addr( SPI1TH, eraseMode, baseaddr );
        baseaddr += erase_block_size;

        w25q64cv_chk_busy( 0xFFFFF );
        //
        
    } 
    clear_spi_dev_cs(0, 1);
    return 0;
}


int w25q64cv_chip_erase(void)
{
    u32 cmd,timeout,buf,*p;
    set_spi_dev_cs(SPI1TH, W25Q64CV_ADDR);
    cmd = CMD_WRITE_EN << 24;
    spi_normal_mode_send(SPI1TH, &cmd, 1);       
    cmd = CMD_CHIP_ERASE << 24;
    spi_normal_mode_send(SPI1TH, &cmd, 1);
    printk("chip erase...\n");

    
    /* check status */
    w25q64cv_chk_busy( 0xFFFFF );
    
    clear_spi_dev_cs(SPI1TH, W25Q64CV_ADDR);
    printk("Erase Done !\n"); 
    return 0;
}

int w25q64cv_read_device_id(u32 *mf_id, u32 *dev_id)
{ 
	u32 buf = 0,cmd = 0,readdata = 0;
    u16 devid;
    set_spi_dev_cs(SPI1TH, W25Q64CV_ADDR);
    
	cmd = CMD_READ_ID << 24;
	spi_flash_mode_send_for_recv(SPI1TH, cmd,1,&buf, 3);
    
	*mf_id = buf & 0xFF;
	devid = (buf >> 8) & 0xFFFF;
    *dev_id = SWAP16(devid);
    //*dev_id = devid;
    
    clear_spi_dev_cs(SPI1TH, W25Q64CV_ADDR);
	return 0;
}

void spi_nand_flash_read_id(struct mtd_info *mtd,int *mf_id, int *dev_id)
{
    w25q64cv_read_device_id(mf_id,dev_id);
    return;
}
//c->mtd->read(c->mtd, ofs, readlen, &retlen, ebuf);
int spi_nand_flash_read(struct mtd_info *mtd,loff_t from, size_t len, size_t * retlen, u_char * buf)
{
    int *p = &from,ret;
    ret = w25q64cv_read(buf,(u32)*p,len);
    *retlen = len;
    return 0;
    
}
void spi_flash_write_delay(int delay)
{
    while(delay--);
}
int spi_nand_flash_write(struct mtd_info *mtd,loff_t to, size_t len, size_t * retlen, const u_char * buf)
{
    int ret = 0,i;
    int *p = &to;
    u8 *printbuf;
    printbuf = buf;
    
    //printk("from %x write to %x len %x \n",buf,*p,len);
    //for(i = 0; i < len;i++)
    //{
        //if(i != 0 && i % 16 == 0)
        //{
            //printk("\n");
        //}
        //printk("%02x \n",*printbuf++);
    //}
    
    ret = w25q64cv_write(buf,(u32)*p,len,big_endian);
    spi_flash_write_delay(0xffff);
    //if(ret == 0)
    *retlen = len;
    return ret;
}
int spi_nand_flash_erase(struct mtd_info *mtd,int begin_addr,int end_addr)
{
    u32 sector_cnt,beg_sector,end_sector;
    if(begin_addr > end_addr)
        return -1;
   
    
    //beg_sector = begin_addr/SECTOR_SIZE;
    beg_sector = begin_addr & 0xFFFFF000;

    sector_cnt = ( end_addr - beg_sector ) / SECTOR_SIZE ;

    if ( end_addr & 0xFFF )
    {
        sector_cnt ++;
    }
    
    //end_sector = end_addr/SECTOR_SIZE;

    
    //sector_cnt = end_sector - beg_sector + 1;
    //printk("------sector_cnt=%d\n",sector_cnt);
    w25q64cv_erase(begin_addr,sector_cnt,flash_erase_4k_mode);
}

/*
 * Main initialization routine
 */
static int __init w25q64cv_init (void)
{
	struct spi_nand_chip *this;
	const char *part_type = 0;
	int mtd_parts_nb = 0;
	struct mtd_partition *mtd_parts = 0;
	
	/* Allocate memory for MTD device structure and private data */
	w25q64cv_mtd = kmalloc(sizeof(struct mtd_info) + sizeof(struct spi_nand_chip),GFP_KERNEL);
	if (!w25q64cv_mtd) 
	{
		printk("Unable to allocate EDB7312 NAND MTD device structure.\n");
		return -ENOMEM;
	}
	
	
	/* Get pointer to private data */
	this = (struct spi_nand_chip *)(&w25q64cv_mtd[1]);
	
	/* Initialize structures */
	memset((char *) w25q64cv_mtd, 0, sizeof(struct mtd_info));
	memset((char *) this, 0, sizeof(struct spi_nand_chip));

	w25q64cv_mtd->priv = this;
	

	spi_init();
	/* insert callbacks */
	this->read_device_id = spi_nand_flash_read_id;
	this->read = spi_nand_flash_read;
	this->write = spi_nand_flash_write;
	this->erase = spi_nand_flash_erase;

	/* Scan to find existence of the device */
	if (spi_nand_scan (w25q64cv_mtd)) 
	{
		kfree (w25q64cv_mtd);
		return -ENXIO;
	}
	printk("w25q64cv_mtd->size=%x \n",w25q64cv_mtd->size);
#ifdef CONFIG_MTD_CMDLINE_PARTS
	mtd_parts_nb = parse_cmdline_partitions(w25q64cv_mtd, &mtd_parts, 
						"w25q64cv-nand");
	if (mtd_parts_nb > 0)
	  part_type = "command line";
	else
	  mtd_parts_nb = 0;
#endif

	if (mtd_parts_nb == 0)
	{
		mtd_parts = partition_info;
		mtd_parts_nb = NUM_PARTITIONS;
		part_type = "static";
	}
	
	/* Register the partitions */
	printk(KERN_NOTICE "Using %s partition definition\n", part_type);
	add_mtd_partitions(w25q64cv_mtd, mtd_parts, mtd_parts_nb);
	/* Return happy */
	return 0;
}
module_init(w25q64cv_init);

/*
 * Clean up routine
 */
static void __exit w25q64cv_cleanup (void)
{
	
	/* Unregister the device */
	del_mtd_device (w25q64cv_mtd);
	
	/* Free the MTD device structure */
	kfree (w25q64cv_mtd);
}
module_exit(w25q64cv_cleanup);

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Marius Groeger <mag@sysgo.de>");
MODULE_DESCRIPTION("MTD map driver for Cogent EDB7312 board");


