/*FILE -- ck1000fb.h -- header file for ck1000fb framebuffer driver*/
/*by Li Xin*/

#define CK_DISPLAY_WIDTH               320
#define CK_DISPLAY_HEIGHT              240
#define CK_DISPLAY_BPP                 16
#define CK_DISPLAY_SCANLINE_BYTES      640
#define CK_DISPLAY_PCLK                8750000L
#define CK_PHYSICAL_REG_ADDR           0x10003000L
#define CK_PHYSICAL_VMEM_ADDR          0x28f60000L
#define CK_PHYSICAL_REG_SIZE           0x1000
#define CK_PHYSICAL_VMEM_SIZE          0x96000
#define CK_PALETTE_SIZE                256
#define CK_LCD_IRQ                     (32+17)


#define CK_WRITE_PALETTE(p,i,r,g,b)  \
  {  \
    ((volatile CK_VALUE*)(p))[(0x800)+((i)*sizeof(CK_VALUE))] = (CK_VALUE)(r)<<10 | (CK_VALUE)(g)<<5 | (b); \
  }

#define CK_READ_PALETTE(p,i,r,g,b)  \
  {  \
    CK_VALUE reg;  \
    reg = ((volatile CK_VALUE*)(p))[(0x800)+((i)*sizeof(CK_VALUE))];  \
    (b) = reg&0x1F;  \
    (g) = (reg&0x3E0)>>5;  \
    (r) = (reg&0x7C00)>>10;  \
  }

typedef unsigned CK_INDEX;
typedef unsigned CK_VALUE;
typedef struct
{
    CK_INDEX Index;
    CK_VALUE Value;
} CK_REGS;

#define CK_INSTANTIATE_REGISTERS(scope_prefix,variable_name)  \
  scope_prefix CK_REGS variable_name[] =  \
  {  \
    {0x0004,0x3b0a2130},\
    {0x0008,0x060a0cef},\
    {0x000c,0x00000101},\
    {0x0010,CK_PHYSICAL_VMEM_ADDR},\
    {0x0020,0x00000000},\
    {0x0024,0x00000002},\
    {0x0000,0x00000e49}\
  }
