/*
**  Ƶģļ
*/

#include "vs28xx.h"
#include "log.h"
#include "pci.h"
#include "audio.h"
#include "enc.h"
#include "yuv.h"
#include "reg/audio_reg.h"


/*
**  Ƶ1dwordʾparaڶdwordʾֵval
**  para16λʾƵͣ16λʾ
**  Ƶȡֵ0-2ֱʾƵ룬Խ룬Խ
**  ͺ:
**  0ݸʽburstval16λʾݸʽ16λʾburst
**  1ò
**  2ʱ
**  3ģʽ
**  4
**
**  ݸʽȡֵΧΪ0-3ֱʾbypass,g711a,g711u,g721
**  burstȡֵΧΪ1-128
**  ȡֵΧΪ0-3ֱʾ4kbps,8kbps,16kbps,32kbps
**  ʱȡֵΧΪ0-1ֱʾ256fs,512fs
**  ģʽȡֵΧΪ0-1ֱʾģʽģʽ
**  ȡֵΧΪ0-1ֱʾ
**  0x46
*/
void cmd_aud_set_para(unsigned char *pucData, int nLength)
{
    int para;
    int val;
    int audType;
    int parType;
    unsigned long *pul;

    FUNC_TRACK(0x46);

    pul = (unsigned long *)pucData;
    para = byte_swap4(pul[0]);
    val = byte_swap4(pul[1]);

    PRINT(INFO, "cmd_aud_set_para %#lx %#lx\n", para, val);

    parType = para & 0xFFFF;
    audType = (para >> 16) & 0xFFFF;

    if (0 == parType)           /* ݸʽburst */
    {
        hw_aud_set_mode(audType, val & 0xFFFF);
        hw_aud_set_burst(audType, (val >> 16) & 0xFFFF);
    }
    else if (1 == parType)      /* ò */
    {
        hw_aud_set_smprate(audType, val);
    }
    else if (2 == parType)      /* ʱ */
    {
        hw_aud_set_clk(audType, val);
    }
    else if (3 == parType)      /* ģʽ */
    {
        hw_aud_set_mst(audType, val);
    }
    else if (4 == parType)      /*  */
    {
        hw_aud_set_snd(audType, val);
    }
    else
    {
        FUNC_COUNTER(0x46, 0x00);
    }

    return;
}


/*
**  Ƶأ1dwordʾͨڶdwordʾ
**  0x45
*/
void cmd_aud_set_switch(unsigned char *pucData, int nLength)
{
    int ch;
    int enable;
    unsigned long *pul;

    FUNC_TRACK(0x45);

    pul = (unsigned long *)pucData;
    ch = byte_swap4(pul[0]);
    enable = byte_swap4(pul[1]);

    if (17 == ch && enable != 0)                    /* Խ */
    {
        g_ulSphDecDataAddr = byte_swap4(pul[2]);
        g_ulSphDecDataLeng = byte_swap4(pul[3]);

        PRINT(INFO, "cmd_aud_set_switch %#lx %#lx %#lx %#lx\n",
            ch, enable, g_ulSphDecDataAddr, g_ulSphDecDataLeng);

        if (g_ulSphDecDataLeng < g_nSphDecLen)      /* ȷʼ㹻 */
        {
            FUNC_COUNTER(0x45, 0x00);
            PRINT(ERR, "audio dec start fail %#lx %#lx\n",
                g_ulSphDecDataLeng, g_nSphDecLen);
            return;
        }

        /* Ԥ */
        g_ulSphDecDataLeng -= g_nSphDecLen;

        /* дʼַ */
        write_reg(SPH_DEC_MEM_BASE, g_ulSphDecDataAddr);
    }
    else
    {
        PRINT(INFO, "cmd_aud_set_switch %#lx %#lx\n", ch, enable);
    }

    hw_aud_set_switch(ch, enable);

    return;
}


/*
**  Ƶж
**  ĿǰʹñģdmaҪע
**  0x44
*/
static void audio_handler(int irq, void *dummy, struct pt_regs *regs)
{
    int i;
    int state;
    unsigned long addr;

    FUNC_TRACK(0x44);

    state = hw_aud_get_channel();                   /* ȡжϵͨ */

    for (i = 0; i < 16; i++)
    {
        if ((state >> i) & 0x1)                     /* λʾͨ */
        {
            addr = hw_aud_get_addr(i);              /* ȡַ */
            if (0 == addr || (addr & 0x3) != 0)
            {
                FUNC_COUNTER(0x44, 0x00);
                PRINT(ERR, "audio%d addr 0x%lx\n", i, addr);
                continue;
            }

            /*
            **  һ֡ݣ2ʾƵ֡
            **  ͳΪƵݳȼ32ֽڵ֡β32ֽרԤģ֡β
            */
            send_frame(i, addr, g_nAudioFLen + 32, 2, 0);
        }
    }

    return;
}


/*
**  Խж
**  ĿǰʹñģdmaҪע
**  0x43
*/
static void sphenc_handler(int irq, void *dummy, struct pt_regs *regs)
{
    unsigned long addr;

    FUNC_TRACK(0x43);

    addr = read_reg(SPH_ENC_DATA_BASE);             /* ȡַ */
    if (0 == addr || (addr & 0x3) != 0)
    {
        FUNC_COUNTER(0x43, 0x00);
        PRINT(ERR, "sphenc addr 0x%lx\n", addr);
        return;
    }

    /*
    **  һ֡ݣ2ʾƵ֡ͨ16ʾԽ
    **  ͳΪƵݳȼ32ֽڵ֡β32ֽרԤģ֡β
    */
    send_frame(16, addr, g_nSphEncLen + 32, 2, 0);

    if (id_aud_data_desire)                         /* IDģʽ */
    {
        id_aud_data_send += g_nSphEncLen;
        if (id_aud_data_send >= id_aud_data_desire) /* 㹻ݺֹͣƵ */
        {
            write_reg(SPH_CTRL, read_reg(SPH_CTRL) | 0x20002);
            PRINT(INFO, "sphenc_handler stop\n");
        }

        id_frame_jiffies = jiffies;                     /* ʾƵԴԻ */
    }

    return;
}


/*
**  Խж
**  0x42
*/
static void sphdec_handler(int irq, void *dummy, struct pt_regs *regs)
{
    FUNC_TRACK(0x42);

    /* ֮ǰһΣʣǷһ֡(g_nSphDecLenΪ0) */
    if (g_ulSphDecDataLeng >= g_nSphDecLen)
    {
        /* Ԥ */
        g_ulSphDecDataLeng -= g_nSphDecLen;
        g_ulSphDecDataAddr += g_nSphDecLen;

        /* дַ */
        write_reg(SPH_DEC_MEM_BASE, g_ulSphDecDataAddr);

        /* ϢЧ */
        write_reg(SPH_CTRL, read_reg(SPH_CTRL) | 0x2000000);
    }
    else
    {
        if (id_aud_data_desire)                     /* IDģʽ꣬ҲرƵ */
        {
            write_reg(SPH_CTRL, read_reg(SPH_CTRL) | 0x20002);
            id_frame_jiffies = jiffies;             /* ʾƵԴԻ */
        }

        FUNC_COUNTER(0x42, 0x00);
        PRINT(INFO, "sphdec_handler end\n");
        return;
    }

    return;
}


/*
**  Ƶģע
**  0x41
*/
void audio_exit(void)
{
    FUNC_TRACK(0x41);

    disable_irq(AUDIO_IRQ);                         /* ͷƵж */
    free_irq(AUDIO_IRQ, 0);

    disable_irq(SPHENC_IRQ);                        /* ͷԽж */
    free_irq(SPHENC_IRQ, 0);

    disable_irq(SPHDEC_IRQ);                        /* ͷԽж */
    free_irq(SPHDEC_IRQ, 0);

    return;
}


/*
**  Ƶģʼ
**  ӹϿԷֳ3֣Ƶ룬Խ룬Խ
**
**  һburst256ֽڣ޶һж128burst32Kݣϴõ32ֽ֡βҪ32K+32ֽ
**  ڲƹһƣҪƬһСڴ棬ԵͨҪ64K+64ֽ
**
**  Ƶ16ͨҪ0x100400ֽ
**  һ·Խ룬ƵͬҪ64K+64ֽ
**  һ·Խ룬󳤶Ϊ65535ֽڣ64K(Ҫݣ֡β)
**  ܹҪ0x120440ֽڵĿռ䣬0x140000СĿռ
**
**  ʱҪݣѽռ64Kֳ8ݣÿ8K
**  0x40
*/
int audio_init(void)
{
    int ret;
    unsigned long ulBase;

    FUNC_TRACK(0x40);

    ulBase = get_memory(AUDIO_MEM_SIZE);            /* ռ */
    if (0 == ulBase)
    {
        FUNC_COUNTER(0x40, 0x00);
        PRINT(ERR, "audio_init memory fail\n");
        return -1;
    }

    hw_aud_config_memory(ulBase);                   /* øͨƵڴ */

    hw_aud_set_burst(0, 32);                        /* һжϲ8K */
    hw_aud_set_burst(1, 32);                        /* һжϲ8K */
    hw_aud_set_burst(2, 32);                        /* Խݳ8K */

    write_reg(AUDIO_CTRL, 0x50000);                 /* ƵģʽΪg711aܿأرոͨķ */

    write_reg(SPH_CTRL, 0x4E024E);                  /* Խ256fs8kbpsg711aģʽ */

    ret = request_irq(AUDIO_IRQ, audio_handler, SA_INTERRUPT, "audio_handler", 0);
    if(ret != 0)
    {
        FUNC_COUNTER(0x40, 0x01);
        PRINT(ERR, "audio_init request_irq fail\n");
        return -1;
    }
    enable_irq(AUDIO_IRQ);

    ret = request_irq(SPHENC_IRQ, sphenc_handler, SA_INTERRUPT, "sphenc_handler", 0);
    if(ret != 0)
    {
        FUNC_COUNTER(0x40, 0x02);
        PRINT(ERR, "audio_init request_irq fail\n");
        return -1;
    }
    enable_irq(SPHENC_IRQ);

    ret = request_irq(SPHDEC_IRQ, sphdec_handler, SA_INTERRUPT, "sphdec_handler", 0);
    if(ret != 0)
    {
        FUNC_COUNTER(0x40, 0x03);
        PRINT(ERR, "audio_init request_irq fail\n");
        return -1;
    }
    enable_irq(SPHDEC_IRQ);

    PRINT(INFO, "audio_init\n");

    return 0;
}
