/*
**  ģļ
*/

#include "vs28xx.h"
#include "pci.h"
#include "yuv.h"
#include "dec.h"
#include "preview.h"
#include "reg/enc_reg.h"

#define DEC_IRQ 60

static unsigned long s_ulDecList;                   /* listַ */
static unsigned long s_ulOutAddr0;                  /* 0 */
static unsigned long s_ulOutAddr1;                  /* 1 */


/*
**  
**  bankȡֵΪ0,1ʾôԤ0ͨNVԤ0ͨ(17)
*/
static void send_dec_data(int bank, unsigned long addr, unsigned long size)
{
    int ret;
    yuv_type_t *p0;
    dma_info_t dmaInfo;
    unsigned long *pul;

    id_frame_jiffies = jiffies;                     /* ʾƴӲԻڽ */

    PRINT(INFO, "dec size %d %#lx %#lx\n", bank, addr, size);

    pul = (unsigned long *)(dmaInfo.msgBuffer);
    pul[0] = byte_swap4(bank * 17);                 /* Ԥͨ */
    pul[1] = byte_swap4(size);                      /* ʵ */

	p0 = (yuv_type_t *)(pul + 2);                   /* pul[2], 3ֽͣôСת */
	p0->yuv = 1;                                    /* yuvΪ422ʵ422Ϊ0x56  */
	p0->pack = 0;                                   /*  */
    p0->qua = 0x56;                                 /* ֱʣ־ʾ֤ߺͳȵĹϵ */

    dmaInfo.pciAddr = g_ulPreAddr[bank][0];         /* Ԥͨ */
    dmaInfo.ahbAddr = addr;                         /* ʼַ */
    dmaInfo.dmaLength = size;                       /* ͳ */
    dmaInfo.module = 0;                             /* Ҫص */
    dmaInfo.command = 0xB1;
    dmaInfo.msgLength = 16;

    ret = pci_dma_write(&dmaInfo, 0, 0);            /* Ҫж */
    if (ret != 0)
    {
        PRINT(ERR, "dec write fail\n");
    }

    return;
}


/*
**  ȡݵַͳ
**  ģʽ̶listȡ
*/
static int get_info(unsigned long *addr, unsigned long *size)
{
    int i;
    unsigned long info;
    unsigned long w, h;
    static int bit_map[2] = {26, 30};

    for (i = 0; i < 2; i++)
    {
        /* ַ */
        addr[i] = read_reg(0x55000190 + i * 8);
        if ((addr[i] & 0x3) || ((addr[i] & 0xF0000000) != 0xC0000000))
            return -1;

        /*  */
        info = read_reg(0x55000194 + i * 8);
        w = (info >> 16) & 0x7FF;
        h = info & 0x7FF;

        /* ģʽ */
        if ((read_reg(s_ulDecList) >> bit_map[i]) & 0x1)
            size[i] = w * h * 2;
        else
            size[i] = w * h * 3 / 2;

        if (0 == size[i] || (size[i] & 0x3) || size[i] > 0x400000)
            return -1;
    }

    return 0;
}


/*
**  жϷ
*/
static void dec_handler(int irq, void *dummy, struct pt_regs *regs)
{
    unsigned long state;
    unsigned long ulAddr[2];
    unsigned long ulSize[2];

    /* ֻж0ͨframe num, bit31-29 */
    state = read_reg(0x55000030);
    if (0 == (state & 0xE0000000))
    {
        PRINT(ERR, "dec nul irq %#lx\n", state);
        return;
    }

    if (get_info(ulAddr, ulSize) != 0)
    {
        PRINT(ERR, "dec info fail %#lx %#lx %#lx %#lx\n",
            ulAddr[0], ulSize[0], ulAddr[1], ulSize[1]);
        return;
    }

    /* ȷnvͨ */
    send_dec_data(1, ulAddr[1], ulSize[1]);
    send_dec_data(0, ulAddr[0], ulSize[0]);

    return;
}


/*
**  ģע
*/
void dec_exit(void)
{
    disable_irq(DEC_IRQ);                           /* ͷж */
    free_irq(DEC_IRQ, 0);

    return;
}


/*
**  ģʼ
**  ֮ǰƴ77Mռ䣬2Dģûֶڴ
**  listEڴ16KַΪ0xE0000000
**  Ƭ16MֱַΪ0xC6D00000,0xC7D00000
**  ԴEڴ棬C
*/
int dec_init(void)
{
    /* listڴ棬EΣ16K */
    s_ulDecList = get_e_memory(0x4000);
    if (0 == s_ulDecList)
    {
        PRINT(ERR, "dec_init not enough memory\n");
        return -1;
    }

    /* Ƭ16MPCӦַ֪ */
    s_ulOutAddr0 = get_memory(0x1000000);
    s_ulOutAddr1 = get_memory(0x1000000);
    if (0 == s_ulOutAddr0 || 0 == s_ulOutAddr1)
    {
        PRINT(ERR, "dec_init not enough memory2\n");
        return -1;
    }

    write_reg(0x55000008, 0x1);                     /* ģλ */
    write_reg(0x55000004, s_ulDecList);             /* дlistַ */
    write_reg(0x55000020, 0x1);                     /* ʹж */

    if(request_irq(DEC_IRQ, dec_handler, SA_INTERRUPT, "dec_handler", 0) != 0)
    {
        PRINT(ERR, "dec_init request_irq fail\n");
        return -1;
    }
    enable_irq(DEC_IRQ);

    PRINT(INFO, "dec_init %#lx %#lx %#lx\n", s_ulDecList, s_ulOutAddr0, s_ulOutAddr1);

    return 0;
}
