/*
**  ģļ
*/

#include "vs28xx.h"
#include "log.h"
#include "list.h"
#include "pci.h"
#include "enc.h"
#include "yuv.h"
#include "effect.h"
#include "reg/enc_reg.h"
#include "reg/jpeg_reg.h"

//#define USE_TIMER

#ifdef USE_TIMER
#define DMA_IRQ                     1               /* ʱʹdmaҪж */
#define ENC_TIMER_INTERVAL          10              /* ʱΪ10 */
struct timer_list enc_timer;
#else
#define DMA_IRQ                     0               /* жʹdmaҪж */
#endif

static unsigned long s_ulEncDmaAddr;                /* dmaַ */
static unsigned long s_ulEncDmaOffset;              /* dmaַƫ */
static unsigned long s_ulEncDmaLength;              /* dmaַ */

static unsigned long s_ulEncStartAddr[51];          /* ڴʼַ2K */
static unsigned long s_ulEncEndAddr[51];            /* ڴĽַ(ӹ1) */
static unsigned long s_ulEncDataAddr[51];           /* ʼַ */

static int s_nDesireIndex[ENC_STREAM_NUM];          /* ÿͨ()ֵ */

static unsigned long s_ulEncWidth[51];              /* ͨ */
static unsigned long s_ulEncHeight[51];             /* ͨ߶ */


/*
**  ѡ
**  0x7C
*/
void cmd_enc_set_strsel(unsigned char *pucData, int nLength)
{
    unsigned long ulChannel;
    unsigned long ulFormat;
    unsigned long ulWidth;
    unsigned long ulHeight;
    unsigned long ulStream;
    unsigned long ulOffset;
    unsigned long ulValue;
    unsigned long ulAddr;
    int i;
    msg_str_sel_t *pMsg;

    FUNC_TRACK(0x7C);

    if (nLength != sizeof(msg_str_sel_t))           /* ֤ݳ */
    {
        FUNC_COUNTER(0x7C, 0x00);
        PRINT(ERR, "set_enc_strsel len %d\n", nLength);
        return;
    }

    pMsg = (msg_str_sel_t *)pucData;
    ulChannel = byte_swap4(pMsg->channel);
    ulFormat = byte_swap4(pMsg->format);
    ulWidth = byte_swap4(pMsg->width);
    ulHeight = byte_swap4(pMsg->height);

    ulStream = (ulFormat >> 16) & 0x3;
    if (0 == ulStream)                              /* ENC0 */
    {
        ulAddr = 0x61260080;

        set_scale(ulChannel, ulWidth, ulHeight, 3, 0, 1);
    }
    else if (1 == ulStream)                         /* ENC1 */
    {
        ulAddr = 0x612600A0;

        set_scale(ulChannel, ulWidth, ulHeight, 4, 0, 1);
    }
    else if (2 == ulStream)                         /* MUX */
    {
        ulAddr = 0x61260064;

        /*
        **  MUXyuvʽĳɷϱҪ420yuvֿ
        */
        write_reg(g_ulList_s + (ulChannel << 10) + 0x148, 0);

        write_reg(0x61260060, 0);                   /* ʹMUX */

        set_scale(ulChannel, ulWidth, ulHeight, 2, 0, 1);
    }
    else
    {
        FUNC_COUNTER(0x7C, 0x01);
        return;
    }

    update_list(ulChannel);

    if (ulChannel < 8)
    {
        ulOffset = ulChannel << 2;
    }
    else
    {
        ulAddr += 4;
        ulOffset = (ulChannel - 8) << 2;
    }

    /*
    **  ҲرԲõֻ򿪲ر
    **  ֻǹرʱҲһ飬е˷
    */
    ulValue = read_reg(ulAddr);
    ulValue &= ~(0xF << ulOffset);                  /* ͨӦ4λ0 */
    ulValue |= ((ulFormat & 0xF) << ulOffset);
    write_reg(ulAddr, ulValue);

    /*
    **  Ŀǰ51ͨҪ֪ԼǴĸ(ENC0,ENC1,MUX)?
    **  ֻ51ͨߣñʲʱҪõ
    */
    for (i = 0; i < 3; i++)
    {
        if ((ulFormat >> i) & 0x1)
        {
            s_ulEncWidth[i * 17 + ulChannel] = ulWidth;
            s_ulEncHeight[i * 17 + ulChannel] = ulHeight;
        }
    }

    return;
}


/*
**  ñ
**  0x7B
*/
void cmd_enc_set_para(unsigned char *pucData, int nLength)
{
    int i;
    unsigned long *pul;
    msg_enc_para_t *pMsg;

    FUNC_TRACK(0x7B);

    if (nLength != sizeof(msg_enc_para_t))           /* ֤ݳ */
    {
        FUNC_COUNTER(0x7B, 0x00);
        PRINT(ERR, "set_enc_para len %d\n", nLength);
        return;
    }

    pul = (unsigned long *)pucData;                 /* Сת */
    for (i = 0; i < (sizeof(msg_enc_para_t) / 4); i++)
    {
        pul[i] = byte_swap4(pul[i]);
    }

    pMsg = (msg_enc_para_t *)pucData;
    if(pMsg->channel > 50)
    {
        FUNC_COUNTER(0x7B, 0x01);
        return;
    }

    /*
    **  Ҫע⣬Ԥ
    */
    pMsg->width = s_ulEncWidth[pMsg->channel];
    pMsg->height = s_ulEncWidth[pMsg->channel];

    hw_enc_set_rcpara(pMsg);                        /* ñʲ */

    return;
}


/*
**  ñ뿪
**  0x7A
*/
void cmd_enc_set_switch(unsigned char *pucData, int nLength)
{
    msg_switch_t *pMsg;
    unsigned long ulChannel;
    unsigned long ulSwitch;

    FUNC_TRACK(0x7A);

    if (nLength != sizeof(msg_switch_t))            /* ֤ݳ */
    {
        FUNC_COUNTER(0x7A, 0x00);
        PRINT(ERR, "set_enc_switch len %d\n", nLength);
        return;
    }

    pMsg = (msg_switch_t *)pucData;
    ulChannel = byte_swap4(pMsg->channel);
    ulSwitch = byte_swap4(pMsg->enable);

    if (ulSwitch)
    {
        /*
        **  ʹ
        **  ͬʱҲݸλǿI֡Ȳ
        */
        write_reg(0x52020000 + (ulChannel << 8), 0x3FFFF);

        s_nDesireIndex[ulChannel] = 0;              /* Ҳ0ʼ */
    }
    else
    {
        write_reg(0x52020000 + (ulChannel << 8), 0x20000);  /* رʹ */
    }

    return;
}


/*
**  ñdmaַ
**  0x79
*/
void cmd_enc_set_dma_addr(unsigned char *pucData, int nLength)
{
    unsigned long *pul;

    FUNC_TRACK(0x79);

    pul = (unsigned long *)pucData;
    s_ulEncDmaAddr = byte_swap4(pul[0]);                /* pc˽ձݵĻַ */
    s_ulEncDmaLength = byte_swap4(pul[1]);              /* pc˽ձݵĻ */
    s_ulEncDmaOffset = 0;                               /* ƫ0ʼ */

    FUNC_INFO2(0x79, 0, s_ulEncDmaAddr, s_ulEncDmaLength); /* ¼dmaϢ */

    return;
}


/*
**  һ֡(Ƶ֡Ƶ֡)
**  chΪͨ
**  ulFrameAddrΪ֡ʼַ
**  ulRealLengthΪ֡ʵʳȣѾ֡ͷ֡βҿܲ4ֽڶ
**  typeʾ֡ͣҪ⴦
**      ֽ0Ϊ1ʾ֡Ϊ2ʾƵ֡Ϊ3ʾ֡Ϊ4ʾä֡Ϊ7ʾܽ֡Ϊ8ʾв
**      ʾ֡ʱֽ1Ϊ0ʾ֡ƬΪ1ʾ֡βƬΪ2ʾһƬ
**          ֽ2Ϊ0ʾIDR֡Ϊ1ʾI֡Ϊ2ʾP֡Ϊ3ʾB֡
**  irqΪ1ʾҪжϣΪ0ʾҪж
**
**  ô˺ʱʹöĩβ32ֽڴmagicϢ
**  0x78
*/
void send_frame(int ch, unsigned long ulFrameAddr, unsigned long ulRealLength, int type, int irq)
{
	int ret;
    unsigned long *pul;
   	unsigned long ulSendLength;
    dma_info_t dmaInfo;

    FUNC_TRACK(0x78);

    /*
    **  dmaʱҪ󳤶4ֽڶ
    **  ʵʳ4ֽڶģ䳤ȵʵʳ,
    **  䳤ȱʵʳԴ
    */
    ret = ulRealLength & 0x3;
    if (0 == ret)
    {
        ulSendLength = ulRealLength;
    }
    else
    {
        ulSendLength = ulRealLength + 4 - ret;
    }

    /*
    **  pc˻ػҪõ4ֽڶĴ䳤
    **  !!!!!ע⣬ηĻpul[0]ֵܸs_ulEncDmaOffsetͬ߶???߸byte_swap4йϵ??
    */
    if (s_ulEncDmaOffset + ulSendLength > s_ulEncDmaLength)
    {
        s_ulEncDmaOffset = 0;
    }

    /*
    **  ֡ͷ֤ʱʹ˼ݳΪ1Ҳûϵ
    **  ʱ´3ֽڵݣûʱ´3ֽڵļ϶(ȷ3ֽΪ0)
    **  ֮ǰУ飬ݳȲӦС4
    */
    pul = (unsigned long *)(ulFrameAddr + ulSendLength - 32);
    write_reg(pul, 0x56565656); 					/* magic */
    write_reg(pul + 1, read_reg(ulFrameAddr));      /* ֡ͷ֤ */
    write_reg(pul + 2, byte_swap4(ch));     		/* ͨ */
    write_reg(pul + 3, byte_swap4(ulRealLength));   /* ʵ֡ */
    write_reg(pul + 4, byte_swap4(type));     	    /* ֡ */

#if 0
    /* pc˻ػҪõ4ֽڶĴ䳤 */
    if (s_ulEncDmaOffset + ulSendLength > s_ulEncDmaLength)
    {
        s_ulEncDmaOffset = 0;
    }
#endif

    pul = (unsigned long *)(dmaInfo.msgBuffer);
    pul[0] = byte_swap4(s_ulEncDmaOffset);
    pul[1] = byte_swap4(ulRealLength);              /* ʵʳ */

    dmaInfo.pciAddr = s_ulEncDmaAddr + s_ulEncDmaOffset;
    dmaInfo.ahbAddr = ulFrameAddr;
    dmaInfo.dmaLength = ulSendLength;               /* 䳤 */
    dmaInfo.module = 0;                             /* Ҫص */
    dmaInfo.command = 0xB0;
    dmaInfo.msgLength = 8;

    /*
    **  pc˵ַƫƣܵȵdmaʱ
    **  ΪһжϿж֡ͨ
    **  Ҫƫ4ĳȣ䳤
    */
    s_ulEncDmaOffset += ulSendLength;

    ret = pci_dma_write(&dmaInfo, 0, irq);
    if (ret != 0)
    {
        FUNC_COUNTER(0x78, 0x00);
        PRINT(ERR, "enc write fail %d 0x%lx 0x%lx\n", ch, ulFrameAddr, ulSendLength);
    }

    return;
}


/*
**  ÿ֡
**  chΪͨ(0-50)
**  ulEncStartAddrΪͨʼַڻػʱ
**  ulEncEndAddrΪַͨжϻػ
**  pIndexָ֡
**  0x77
*/
static void frame_process(int ch, unsigned long ulEncStartAddr, unsigned long ulEncEndAddr, unsigned long *pIndex)
{
    int a;
    int b;
    unsigned long ulAddr1;
    unsigned long ulAddr2;
    unsigned long ulLeng1;
    unsigned long ulLeng2;
    unsigned long ulSliceType;
    unsigned long ulFrameType1;
    unsigned long ulFrameType2;
    unsigned long ulFrameAddr;
    unsigned long ulFrameLength;
    unsigned long ulIndexCopyPos;

    FUNC_TRACK(0x77);

    if (id_par_frame_desire != 0)                   /* ڱ */
    {
        id_par_frame_send++;
        if (id_par_frame_send >= id_par_frame_desire)
        {
            id_par_frame_desire = 0;                /* Ҫ֡0 */
            id_par_frame_send = 0;                  /* ѷ֡0 */

            for (a = 0; a < 51; a++)                /* ֡㹻֮󣬹رͨ */
            {
                write_reg(0x52020000 + (a << 8), 0x2FFFF);
            }
            PRINT(INFO, "enc stop\n");
        }
    }

    /*
    **  ȡ֡ʼַͳ
    **  ʼַ֡ͷռ䣬Ȳ֡ͷ֡β
    */
    ulFrameAddr = pIndex[1];
    ulFrameLength = pIndex[2] & 0x1FFFFFF;          /* Чλbit0-24 */

    /*
    **  ϸ֤ÿ֡ݣûЧΪֵ֮ǰʹùģ
    **  д˾Ϳжϳ
    */
    if ((ulFrameAddr < ulEncStartAddr) ||
        (ulFrameAddr >= ulEncEndAddr) ||
        ((ulFrameAddr & 0x7) != 0) ||               /* ֡ʼַҪ8ֽڶ */
        (ulFrameLength < 4) ||                      /* ֡Ҫ */
        (ulFrameLength >= ENC_DATA_SPACE))
    {
        FUNC_COUNTER(0x77, 0x00);
        PRINT(ERR, "frame error %d 0x%lx 0x%lx\n", ch, ulFrameAddr, ulFrameLength);
        return;
    }

    ulSliceType = (pIndex[2] >> 28) & 0x3;          /* ȡ֡ */

    /*
    **  ַΪֽ߰ab
    **  ûлػʱaȴڵulFrameLengthbС0
    **  ػʱa+b=ulFrameLength
    **  ûлػaǴ08ֽڶ
    */
    a = ulEncEndAddr - ulFrameAddr;                 /* һaλڻĩβ */

    b = ulFrameAddr + ulFrameLength - ulEncEndAddr; /* ڶbλڻʼ */

    ulAddr1 = ulFrameAddr;
    ulLeng1 = ulFrameLength + FRAME_TAIL_SPACE;
    ulFrameType1 = (ulSliceType << 16) | 0x201;     /* ֡һƬ */

    ulAddr2 = 0;
    ulLeng2 = 0;                                    /* ֻΪȥľ */
    ulFrameType2 = 0;

    ulIndexCopyPos = ulFrameAddr + ulFrameLength;   /* ű */

    /*
    **  ͷûԤռ䣬Էػʱ
    **  ҪôƬͣҪôͷβϳһƬ
    */
    if (b > 64)                                     /* Ƭ */
    {
        ulLeng1 = a + SEGMENT_TSPASE;               /* һƬβֻ32ֽڣΪ */
        ulFrameType1 = (ulSliceType << 16) | 0x001; /* ֡Ƭ */

        ulAddr2 = ulEncStartAddr + INDEX_REGION_SIZE;
        ulLeng2 = b + FRAME_TAIL_SPACE;
        ulFrameType2 = (ulSliceType << 16) | 0x101; /* ֡βƬ */

        ulIndexCopyPos = ulAddr2 + b;               /* ŵڶƬĩβ */
    }
    else if (b > 0)                                 /* ͷβϳһƬ */
    {
        memcpy((void *)ulEncEndAddr, (void *)(ulEncStartAddr + INDEX_REGION_SIZE), b);
    }

    memcpy((void *)ulIndexCopyPos, pIndex, 32);     /*  */

    send_frame(ch, ulAddr1, ulLeng1, ulFrameType1, DMA_IRQ);    /* ͵һƬ */

    /*
    **  ͵ڶƬ()1ʾƵ֡ڶƬ
    **  жdmaƬҲӦǽŵģ
    **  Ƶ֡ʱм䲻ᱻƵ֡
    */
    if (ulAddr2)
    {
        send_frame(ch, ulAddr2, ulLeng2, ulFrameType2, DMA_IRQ);
    }

    return;
}


/*
**  ͨ()
**  ͨ()жʱô˺עһжϿж֡
**  chΪͨ()ţЧֵΪ0-50
**  0x76
*/
static void enc_process(int ch)
{
    int nHead1;
    int nHead2;
    int nTail1;
    int nTail2;
    int nIndex;
    int nIndexMax;
    unsigned long *pul;
    unsigned long ulEncStartAddr;
    unsigned long ulEncEndAddr;

    FUNC_PARA1(0x76, ch);                           /* ¼һεñϢ */

    IRQ_COUNTER(ch, LOG_ENC);                       /* ͨ()жϼ */

    /*
    **  ĳͨ˵ʼַַǹ̶
    **  0-0ʾ0ʼ2kַ0-2047
    **  0-1ʾ0ʼ4kַ0-4095
    **  ȡʼַΪ˵õǰ֡
    **  ȡַΪжϱػ
    **  ȡʱҪע⴦֡ΪһжϳѾ֡
    */

    /* ȡʼַ */
    ulEncStartAddr = read_reg(BSTR_BUFF_START_ADDR + (ch << BSTR_BIT));
    ulEncStartAddr <<= BIT_2K;                      /* 2kΪλ */
    ulEncStartAddr += C_BANK;                       /* ַĬC */

    /* ȡַ(Ϊ֮ʹ÷㣬ʵǽַ1) */
    ulEncEndAddr = read_reg(BSTR_BUFF_FINAL_ADDR + (ch << BSTR_BIT));
    ulEncEndAddr += 1;
    ulEncEndAddr <<= BIT_2K;
    ulEncEndAddr += C_BANK;

    /* ȡֵֵ1 */
    nIndexMax = read_reg(BSTR_INDEX_INFO + (ch << BSTR_BIT));
    nIndexMax >>= 16;                               /* üĴbit16-26ʾֵ */
    nIndexMax &= 0x7ff;

    /* жֵĺϷ */
    if (ulEncStartAddr != s_ulEncStartAddr[ch] || ulEncEndAddr != s_ulEncEndAddr[ch] || (nIndexMax + 1) != INDEX_NUM)
    {
        FUNC_COUNTER(0x76, 0x01);                   /* ۼ쳣Ϣǰ¼1ƫ1 */
        PRINT(ERR, "enc addr err\n");
        return;
    }

    /* ȡǰ */
    pul = (unsigned long *)ulEncStartAddr;          /* ͷ4ֽڣbit16-26ʾǰ */
    nIndex = (pul[0] >> 16) & 0x7ff;

    if (nIndex >= s_nDesireIndex[ch])               /* ǰС˵ûлػ */
    {
        nHead1 = s_nDesireIndex[ch];                /* ֻ账һ */
        nTail1 = nIndex;
        nHead2 = 1;                                 /* ڶЧ */
        nTail2 = 0;
    }
    else                                            /* ػҪִ */
    {
        /*
        **  ĿǰݶԱȽϼʱĴpcˣ˲ۻܶݣ
        **  뵱ǰֵȽСʱ˵ۻ˺ܶݣΪ
        */
        if ((s_nDesireIndex[ch] - nIndex) < 100)
        {
            FUNC_COUNTER(0x76, 0x02);
            PRINT(ERR, "error loop %d %d %d\n", ch, nIndex, s_nDesireIndex[ch]);
            return;
        }

        nHead1 = s_nDesireIndex[ch];                /* һ֣ĩβ */
        nTail1 = nIndexMax;
        nHead2 = 0;                                 /* ڶ֣ͷǰ */
        nTail2 = nIndex;
    }

    /*
    **  һ
    **  λһ1ΪͷڵĹϵ(ͷ32ֽ)
    */
    pul = (unsigned long *)(ulEncStartAddr + ((nHead1 + 1) << BIT_32));
    for (; nHead1 <= nTail1; nHead1++)
    {
        frame_process(ch, ulEncStartAddr, ulEncEndAddr, pul);   /* һ֡ */
        pul += 8;                                   /* ģûлػ */
    }

    /* ڶ */
    pul = (unsigned long *)(ulEncStartAddr + ((nHead2 + 1) << BIT_32));
    for (; nHead2 <= nTail2; nHead2++)
    {
        frame_process(ch, ulEncStartAddr, ulEncEndAddr, pul);
        pul += 8;
    }

    /* ´ֵֵʱص0 */
    if (nIndex < nIndexMax)
    {
        s_nDesireIndex[ch] = nIndex + 1;
    }
    else
    {
        s_nDesireIndex[ch] = 0;
    }

    return;
}


/*
**  ж
**  öʱʱҲ
**  0x75
*/
#ifdef USE_TIMER
static void enc_handler(unsigned long v)
#else
static void enc_handler(int irq, void *dummy, struct pt_regs *regs)
#endif
{
    int i;
    unsigned long ulIrqState0;
    unsigned long ulIrqState1;

    /* ȡжϵͨ() */
    ulIrqState0 = read_reg(ENC_STATE_LOW);          /* 0-31 */
    ulIrqState1 = read_reg(ENC_STATE_HIGH);         /* 32-50 */

#ifndef USE_TIMER
    FUNC_PARA2(0x75, ulIrqState0, ulIrqState1);     /* ¼һжϢ */
#endif

    if ((0 == ulIrqState0) && (0 == ulIrqState1))
    {
#ifndef USE_TIMER
        FUNC_COUNTER(0x75, 0x02);                   /* ʹжʱ̻ȡ״̬Ϊ0쳣 */
        PRINT(ERR, "enc_handler null!\n");
#endif
        goto next_timer;
    }

	id_frame_jiffies = jiffies;                     /* ʾڱ */

    if (ulIrqState0)                                /* λ */
    {
        for (i = 0; i < STREAM_LOW_NUM; i++)
        {
            if ((ulIrqState0 >> i) & 0x1)
            {
                enc_process(i);                     /* һͨ() */
            }
        }
    }

    if (ulIrqState1)                                /* λ */
    {
        for (i = 0; i < STREAM_HIGH_NUM; i++)
        {
            if ((ulIrqState1 >> i) & 0x1)
            {
                enc_process(i + STREAM_LOW_NUM);
            }
        }
    }

next_timer:
#ifdef USE_TIMER
    enc_timer.data = 0;                             /* һʱ */
    enc_timer.function = enc_handler;
    enc_timer.expires = jiffies + ENC_TIMER_INTERVAL;
    add_timer(&enc_timer);
#endif

    return;
}


/*
**  ñַ
**  0x74
*/
static void config_memory(void)
{
    int i;
    unsigned long ulAddr;
    unsigned long ulData;

    FUNC_TRACK(0x74);

    for (i = 0; i < ENC_STREAM_NUM; i++)            /* 51 */
    {
        /*
        **  0-0ʾ0ʼ2kַ0-1ʾ0ʼ4kַ
        **  1-2ʾ0x800ʼ4kַĩβһֽ0x17FF
        **
        **  indexʾĴֵaddrʾʵַ(ȲC)תʽ£
        **  ʼַindex = addr / 2048;  addr = index * 2048
        **  ڽַindex = ((addr + 1) / 2048) - 1;  addr = ((index + 1) * 2048) - 1
        */

        ulAddr = BSTR_BUFF_START_ADDR + (i << BSTR_BIT);
        ulData = (s_ulEncStartAddr[i] & 0xFFFFFFF) >> BIT_2K;   /* 2kΪλĬʹCڴ */
        write_reg(ulAddr, ulData);                  /* ʼַ */

        ulAddr = BSTR_BUFF_FINAL_ADDR + (i << BSTR_BIT);
        ulData = (((s_ulEncEndAddr[i]) & 0xFFFFFFF) >> BIT_2K) - 1;
        write_reg(ulAddr, ulData);                  /* ַ */

        ulAddr = BSTR_DATA_START_ADDR + (i << BSTR_BIT);
        ulData = s_ulEncDataAddr[i];
        write_reg(ulAddr, ulData);                  /* ʼַֽΪλ2k */
    }

    return;
}


/*
**  ڴ
**  ĿǰΪԤԤ˴0xC2000000ʼ224Mڴ棬mallocֶָ
**  ֶָڴ棬ڴʼַENC_MEM_SIZE2Kģ
**  ԷֵڴҲ2K
**
**  ڴдĴĵطǷֿģΪIDʱЩڴҪдһ
**  0x73
*/
static int prepare_memory(void)
{
    int i;
    unsigned long ulBase;

    FUNC_TRACK(0x73);

    for (i = 0; i < ENC_STREAM_NUM; i++)
    {
        ulBase = get_memory(ENC_MEM_SIZE);
        if (0 == ulBase)
        {
            return i;
        }

        s_ulEncStartAddr[i] = ulBase;                       /* ʼַ */
        s_ulEncEndAddr[i] = ulBase + ENC_RESERVE_OFFSET;    /* ַ(ʵǽַ1) */
        s_ulEncDataAddr[i] = ulBase + INDEX_REGION_SIZE;    /* ݵַ */
    }

    return i;
}


/*
**  λڴһ
**  0x72
*/
void enc_reset(void)
{
    FUNC_TRACK(0x72);

    write_reg(0x54000020, 0xFFFFFFFF);                      /* h264 jpeg */
    write_reg(0x54000024, 0xFFFFFFFF);
    write_reg(0x54000028, 0xFFFFFFFF);
    write_reg(0x5400002C, 0xFFFFFFFF);

    write_reg(ENC_CTRL, 0x1);                               /* λ */

    write_reg(JPEG_ENC_RST, 0x1);                           /* λjpegģԱͷ֡ */

    udelay(100);                                            /* λҪ1000ʱ(54Mϵͳ£1us54ʱ) */

    config_memory();                                        /* ַ */

	write_reg(RC_CTRL0, (RC0_BADDR >> BIT_2K) & 0xFFFF);    /* ʿƻַ2kΪλĬEڴ */
	write_reg(RC_CTRL1, (RC1_BADDR >> BIT_2K) & 0xFFFF);
    write_reg(WM_CTRL, (WMI_BADDR >> BIT_2K) & 0xFFFF);     /* ˮӡϢַ2kΪλĬEڴ */
    write_reg(DESK_CTRL, (DES_BADDR >> BIT_2K) & 0xFFFF);   /* DES/AESԿ壬2kΪλĬEڴ */

    write_reg(0x52070018, 0x1000);                          /* Ӵ쳣ȴʱ */

	enc_raw_buffer_init();                                  /* ñ֡ */

    write_reg(0x54000000, ENC_NORMAL_MODE);                 /* ñģʽΪͨģʽҪ */

    memset(s_nDesireIndex, 0, sizeof(s_nDesireIndex));      /* 0ʼ */

    return;
}


/*
**  ģע
**  0x71
*/
void enc_exit(void)
{
    FUNC_TRACK(0x71);

#ifndef USE_TIMER
    disable_irq(ENC_IRQ);                           /* ͷűж */
    free_irq(ENC_IRQ, 0);
#endif

    return;
}


/*
**  ģʼ
**  0x70
*/
int enc_init(void)
{
    int ret;

    FUNC_TRACK(0x70);

    config_ddr();                                   /* EddrCddrwdm */

    ret = prepare_memory();                         /* ׼ڴ */
    if (0 == ret)
    {
        FUNC_COUNTER(0x70, 0x00);
        PRINT(ERR, "enc memory fail\n");
        return -1;
    }
    else
    {
        PRINT(INFO, "enc mem %d\n", ret);
    }

    enc_reset();                                    /* λ */

    enc_para_init();                                /* ʼ */

#ifdef USE_TIMER
    enc_timer.data = 0;
    enc_timer.function = enc_handler;
    enc_timer.expires = jiffies + ENC_TIMER_INTERVAL;
    add_timer(&enc_timer);
#else
    ret = request_irq(ENC_IRQ, enc_handler, SA_INTERRUPT, "enc_handler", 0);
    if(ret != 0)
    {
        FUNC_COUNTER(0x70, 0x01);
        PRINT(ERR, "enc_init request_irq fail!\n");
        return -1;
    }
    enable_irq(ENC_IRQ);
#endif

    PRINT(INFO, "enc_init\n");

    return 0;
}
