/*
**  osdģļ
*/

#include "vs28xx.h"
#include "log.h"
#include "list.h"
#include "yuv.h"
#include "osd.h"

static unsigned long s_ulOsdHead;                   /* osdͷ */


/*
**  ʱСת
*/
static unsigned long real_swap4(unsigned long v)
{
    unsigned int reg;

    __asm__ __volatile__
    (
        "mov %0, r2\n"

        "lsli r2, 8\n"
        "xtrb1 r1, r2\n"
        "or    r2, r1\n"
        "lsli r2, 16\n"

        "xtrb0 r1, %0\n"
        "or    r2, r1\n"
        "xtrb1 r1, %0\n"
        "lsli r1,8\n"

        "or    r2, r1\n"
        : "=r" (reg)
        : "0"(reg)
    );
}


/*
**  mask
**  ֵ︽maskɫyuv
**  ע⣬maskĿǷڼĴǷlistlistֻmaskɫ
**  0x27
*/
void cmd_mask_set_switch(unsigned char *pucData, int nLength)
{
    unsigned long v;
    unsigned long ch;
    unsigned long bit;
    msg_switch_t *pMsg;

    FUNC_TRACK(0x27);

    if (nLength != sizeof(msg_switch_t))
    {
        FUNC_COUNTER(0x27, 0x00);
        PRINT(ERR, "set_mask_switch len %d\n", nLength);
        return;
    }

    pMsg = (msg_switch_t *)pucData;
    ch = byte_swap4(pMsg->channel);
    v = byte_swap4(pMsg->enable);

    /*
    **  طڼĴlist
    **  ֻڴmaskʱˢɫصʱǲˢɫ
    */
    if (v & 0x1)
    {
        bit = g_ulList_s + (ch << 10);
        write_reg(bit + 0x7C, v);                   /* PV */
        write_reg(bit + 0xF4, v);                   /* NV */
        write_reg(bit + 0x174, v);                  /* MUX */
        write_reg(bit + 0x1F4, v);                  /* ENC0 */
        write_reg(bit + 0x274, v);                  /* ENC1 */

        update_list(ch);

        bit = 0x1 << ch;
        write_reg(0x61260024, read_reg(0x61260024) | bit);  /* PV */
        write_reg(0x61260044, read_reg(0x61260044) | bit);  /* NV */
        write_reg(0x61260070, read_reg(0x61260070) | bit);  /* MUX */
        write_reg(0x6126008C, read_reg(0x6126008C) | bit);  /* ENC0 */
        write_reg(0x612600AC, read_reg(0x612600AC) | bit);  /* ENC1 */
    }
    else
    {
        bit = ~(0x1 << ch);
        write_reg(0x61260024, read_reg(0x61260024) & bit);  /* PV */
        write_reg(0x61260044, read_reg(0x61260044) & bit);  /* NV */
        write_reg(0x61260070, read_reg(0x61260070) & bit);  /* MUX */
        write_reg(0x6126008C, read_reg(0x6126008C) & bit);  /* ENC0 */
        write_reg(0x612600AC, read_reg(0x612600AC) & bit);  /* ENC1 */
    }

    return;
}


/*
**  mask
**  0x26
*/
void cmd_mask_set_data(unsigned char *pucData, int nLength)
{
    msg_mask_data_t *pMsg;
    unsigned long ch;
    unsigned long idx;
    unsigned long left;
    unsigned long top;
    unsigned long right;
    unsigned long bottom;
    unsigned long ulBase0;
    unsigned long ulBase1;
    unsigned long ulOffset[5] = {0x80, 0xF8, 0x178, 0x1F8, 0x278};
    int i;

    FUNC_TRACK(0x26);

    if (nLength != sizeof(msg_mask_data_t))
    {
        FUNC_COUNTER(0x26, 0x00);
        PRINT(ERR, "set_mask_data len %d\n", nLength);
        return;
    }

    pMsg = (msg_mask_data_t *)pucData;
    ch = byte_swap4(pMsg->channel);
    idx = byte_swap4(pMsg->index);
    left = byte_swap4(pMsg->left);
    top = byte_swap4(pMsg->top);
    right = byte_swap4(pMsg->right);
    bottom = byte_swap4(pMsg->bottom);

    top |= (left << 16);
    bottom |= (right << 16);
    ulBase0 = g_ulList_s + (ch << 10) + (idx * 8);

    for (i = 0; i < 5; i++)                         /* 5 */
    {
        ulBase1 = ulBase0 + ulOffset[i];
        write_reg(ulBase1, top);
        write_reg(ulBase1 + 4, bottom);
    }

    update_list(ch);

    return;
}


/*
**  osd
**  ÿͨÿosdǶأ˴˺Ȳ
**  0x25
*/
void cmd_osd_set_switch(unsigned char *pucData, int nLength)
{
    FUNC_TRACK(0x25);

    return;
}


/*
**  
**  дĴķʽosd
**  pMsgx y w hֵѾ꣬ߵϢһЩԶֵ
**  0x24
*/
static void osd_write_regs(msg_osd_data_t *pMsg)
{
    int i;
    unsigned long ch;
    unsigned long idx;
    unsigned long x, y;
    unsigned long ulHeadArea;
    unsigned long ulCommandArea;
    unsigned long ulBase[5];
    unsigned long bit;
    unsigned long *psrc, *pdst;

    FUNC_TRACK(0x24);

    ch = byte_swap4(pMsg->channel);
    if (0x50505050 == pMsg->key)                    /* ܿؼĴؼɫYUVֵ */
    {
        bit = g_ulList_s + (ch << 10);
        ulBase[0] = bit + 0xC0;                     /* PV */
        ulBase[1] = bit + 0x138;                    /* NV */
        ulBase[2] = bit + 0x1B8;                    /* MUX */
        ulBase[3] = bit + 0x238;                    /* ENC0 */
        ulBase[4] = bit + 0x2B8;                    /* ENC1 */

        x = byte_swap4(pMsg->x);                    /* x yʵǿֵyuvֵֵ */
        y = byte_swap4(pMsg->y);

        for (i = 0; i < 5; i++)                     /* 5 */
        {
            write_reg(ulBase[i], x);
            write_reg(ulBase[i] + 4, y);
        }

        update_list(ch);                            /* ڼĴܿһֱŵģ账 */
        return;
    }

    ulHeadArea = s_ulOsdHead + ch * 256;            /* λͷÿͨ256ֽ */

    if (0x51515151 == pMsg->key)                    /* øølist? */
    {
        idx = byte_swap4(pMsg->index);              /* osd */
        ulCommandArea = ulHeadArea + (idx * 16);

        //write_reg(ulCommandArea, byte_swap4(pMsg->x));
        //write_reg(ulCommandArea + 4, byte_swap4(pMsg->y));
        //write_reg(ulCommandArea + 8, byte_swap4(pMsg->w));
        write_reg(ulCommandArea, real_swap4(pMsg->x));
        write_reg(ulCommandArea + 4, real_swap4(pMsg->y));
        write_reg(ulCommandArea + 8, real_swap4(pMsg->w));
        return;
    }

    if (0x52525252 == pMsg->key)                    /* õɫ壬ølist? */
    {
        //memcpy((void *)(ulHeadArea + 144), pMsg->data, 64);
        psrc = (unsigned long *)pMsg->data;
        pdst = (unsigned long *)(ulHeadArea + 144);
        for (i = 0; i < 16; i++)
        {
            pdst[i] = real_swap4(psrc[i]);
        }
        return;
    }

    FUNC_COUNTER(0x24, 0x00);

    return;
}


/*
**  osd
**  0ʾlogo1-8ʾosd
**  0x23
*/
void cmd_osd_set_data(unsigned char *pucData, int nLength)
{
    msg_osd_data_t *pMsg;
    int i;
    unsigned long ch;
    unsigned long idx;
    unsigned long x;
    unsigned long y;
    unsigned long w;
    unsigned long h;
    unsigned long alpha;
    unsigned long flip;
    unsigned long key;
    unsigned long swh;
    unsigned long ulDataArea;
    unsigned long ulDataLeng;
    unsigned long ulHeadArea;
    unsigned long ulCommandArea;
    unsigned long ulPaletteArea;
    unsigned long ulBase[5];
    unsigned long ulControl;
    unsigned long bit;

    FUNC_TRACK(0x23);

    /*
    **  ֤Ϣ
    **  Ϣͷ(ݾ48ֽ)32ַ
    **  ַΪ8أ߶Ϊ16أÿ2bitһַռ256bit32ֽ
    **  ˣ32ַռ1024ֽڣͷ48ֽڣܳ1072ֽ
    */
    if (nLength < 48 || nLength > 1072)
    {
        FUNC_COUNTER(0x23, 0x00);
        PRINT(ERR, "osd_data len %d\n", nLength);
        return;
    }

    pMsg = (msg_osd_data_t *)pucData;
    if (0xABABABAB == pMsg->swh)                    /* ãosdأ */
    {
        osd_write_regs(pMsg);
        return;
    }

    ch = byte_swap4(pMsg->channel);
    idx = byte_swap4(pMsg->index);
    x = byte_swap4(pMsg->x);
    y = byte_swap4(pMsg->y);
    w = byte_swap4(pMsg->w);
    h = byte_swap4(pMsg->h);
    alpha = byte_swap4(pMsg->alpha);
    flip = byte_swap4(pMsg->flip);
    key = byte_swap4(pMsg->key);
    swh = byte_swap4(pMsg->swh);

    ulDataLeng = (w * h) / 4;                       /* w*hΪܵأÿ2bit1ֽ4 */

    /* ֤Ϸ */
    if (ch > 15 || idx > 8 || x > 1920 || y > 1088 || w > 256 || h > 16 || ulDataLeng > nLength)
    {
        FUNC_COUNTER(0x23, 0x01);
        PRINT(ERR, "osd_data err\n");
        return;
    }

    ulHeadArea = s_ulOsdHead + ch * 256;            /* λͷÿͨ256ֽ */
    ulCommandArea = ulHeadArea + idx * 16;
    ulPaletteArea = ulHeadArea + 144;

    bit = g_ulList_s + (ch << 10);                  /* osdܿ */
    ulBase[0] = bit + 0xC0;                         /* PV */
    ulBase[1] = bit + 0x138;                        /* NV */
    ulBase[2] = bit + 0x1B8;                        /* MUX */
    ulBase[3] = bit + 0x238;                        /* ENC0 */
    ulBase[4] = bit + 0x2B8;                        /* ENC1 */

    if (swh)                                        /* osd */
    {
        ulDataArea = read_reg(ulCommandArea + 12);  /* λ(5)osd */
        ulDataArea = real_swap4(ulDataArea);
        memcpy((void *)ulDataArea, pMsg->data, ulDataLeng);

        /* ɫ壬4ɫģʽ(ʵֻ3ɫ00ʾ͸01ʾɫ(ɫ)10ʾɫ(ɫ)11ʾɫ(ɫ))*/
        write_reg(ulPaletteArea, 0x0);              /* ͸ */
        //write_reg(ulPaletteArea + 0x04, 0x1F108080);/* ͸ɫ */
        //write_reg(ulPaletteArea + 0x08, 0x1FEF8080);/* ͸ɫ */
        //write_reg(ulPaletteArea + 0x0C, 0x1F108080);/* ͸ɫ */
        write_reg(ulPaletteArea + 0x04, real_swap4(0x1F108080));/* ͸ɫ */
        write_reg(ulPaletteArea + 0x08, real_swap4(0x1FEF8080));/* ͸ɫ */
        write_reg(ulPaletteArea + 0x0C, real_swap4(0x1F108080));/* ͸ɫ */

        /* osd */
        //write_reg(ulCommandArea, 0x60005300 | ((flip & 0x1) << 28));/* 4ɫģʽѡɫ͸ */
        //write_reg(ulCommandArea + 0x04, (x << 16) | (x + w - 1));   /*  */
        //write_reg(ulCommandArea + 0x08, (y << 16) | (y + h - 1));   /*  */
        write_reg(ulCommandArea, real_swap4(0x60005300 | ((flip & 0x1) << 28)));/* 4ɫģʽѡɫ͸ */
        write_reg(ulCommandArea + 0x04, real_swap4((x << 16) | (x + w - 1)));   /*  */
        write_reg(ulCommandArea + 0x08, real_swap4((y << 16) | (y + h - 1)));   /*  */

        for (i = 0; i < 5; i++)                     /* 5 */
        {
            ulControl = read_reg(ulBase[i]);        /* osdܿ */

            ulControl &= ~0x1F0000;                 /* osd͸0(logo) */

            ulControl |= (0x1 << (idx - 1));        /* 򿪶Ӧosdʹ(0ʾlogo,1-8ʾosd) */

            ulControl |= (alpha << 16);             /* ͸ */

            write_reg(ulBase[i], ulControl);
        }
    }
    else
    {
        for (i = 0; i < 5; i++)                     /* 5 */
        {
            ulControl = read_reg(ulBase[i]);        /* osdܿ */

            ulControl &= ~(0x1 << (idx - 1));       /* رնӦosd */

            write_reg(ulBase[i], ulControl);
        }
    }

    update_list(ch);

    return;
}


/*
**  
**  osdͷ1logo8osd
**  ÿͷʵʴСΪ208ֽڣ256ֽ
**
**  0x22
*/
static void fill_data_area(unsigned long ulHead, int size, unsigned long ulDataArea)
{
    int i;

    FUNC_TRACK(0x22);

    ulHead += 12;                                   /* ַָƫ */

    for (i = 0; i < 9; i++)
    {
        //write_reg(ulHead, ulDataArea);              /* дosdݵַ */
        write_reg(ulHead, real_swap4(ulDataArea));
        ulHead += 16;
        ulDataArea += size;
    }

    return;
}


/*
**  osdģע
**  0x21
*/
void osd_exit(void)
{
    FUNC_TRACK(0x21);

    return;
}


#ifdef VS28XX_MODE_ID

/*
**  osdģʼ
**  Ҫ1Mռ
**
**  0x20
*/
int osd_init(void)
{
    int i;
    unsigned long bit;
    unsigned long ulBase;

    FUNC_TRACK(0x20);

    ulBase = get_memory(0x100000);
    if (0 == ulBase)
    {
        FUNC_COUNTER(0x20, 0x00);
        PRINT(ERR, "osd memory fail!\n");
        return -1;
    }

    /* ͨOSD */
    for (i = 0; i < 16; i++)
    {
        bit = g_ulList_s + (i << 10);               /* ͷַ */

        write_reg(bit + 0xC8, ulBase);              /* PV */
        write_reg(bit + 0x140, ulBase);             /* NV */
        write_reg(bit + 0x1C0, ulBase);             /* MUX */
        write_reg(bit + 0x240, ulBase);             /* ENC0 */
        write_reg(bit + 0x2C0, ulBase);             /* ENC1 */
    }

    id_pre_osd_base = ulBase;                       /* ַڵosdԴ */

    PRINT(INFO, "osd_init 0x%lx.\n", ulBase);

    return 0;
}

#else

/*
**  osdģʼ
**
**  Ŀǰֻһ(˵һosd16ͨиԵosd)
**  ܹ1logo8osdͷռ208ֽ
**  һ16ͨͷҪ3.25kʵʷ4Kÿͷ256ֽ
**
**  0ͨÿosdlog1Mͨÿ16K12M
**  Ϊosd12MĿռ
**
**  0x20
*/
int osd_init(void)
{
    int i;
    unsigned long ulHead;
    unsigned long ulSize;
    unsigned long ulDataArea;
    unsigned long bit;

    FUNC_TRACK(0x20);

    s_ulOsdHead = get_memory(0xC00000);
    if (0 == s_ulOsdHead)                           /* Ϊosd12Mռ */
    {
        FUNC_COUNTER(0x20, 0x00);
        PRINT(ERR, "osd memory fail\n");
        return -1;
    }

    ulHead = s_ulOsdHead;                           /* osdͷַݵַ */
    ulDataArea = s_ulOsdHead + 0x1000;              /* osdͷҪ4K */

    memset((void *)ulHead, 0, 0x1000);              /* ͷ0 */

    for (i = 0; i < 16; i++)
    {
        bit = g_ulList_s + (i << 10);               /* ͷַÿͨͷΪ256ֽ */

        write_reg(bit + 0xC8, ulHead);              /* PV */
        write_reg(bit + 0x140, ulHead);             /* NV */
        write_reg(bit + 0x1C0, ulHead);             /* MUX */
        write_reg(bit + 0x240, ulHead);             /* ENC0 */
        write_reg(bit + 0x2C0, ulHead);             /* ENC1 */

        if (0 == i)                                 /* ݵַ0ͨ1Mͨ16K */
        {
            ulSize = 0x100000;
        }
        else
        {
            ulSize = 0x4000;
        }

        fill_data_area(ulHead, ulSize, ulDataArea);

        ulDataArea += (ulSize * 9);                 /* 1logo8osd */
        ulHead += 256;
    }

    PRINT(INFO, "osd_init 0x%lx\n", s_ulOsdHead);

    return 0;
}

#endif
