/*
**  pciģļģ¿Էֳ֣䣬pci dmaԼpci
**  շϢpcͨš
**  pci dmaڴݣԤjpeg
**  pciʵۺpci dmaʵpcص˫ݴ䣬ַڴ(Ĵ)Ķд
*/

#include "vs28xx.h"
#include "log.h"
#include "list.h"
#include "reg/pci_reg.h"
#include "pci.h"
#include "iic.h"
#include "yuv.h"
#include "preview.h"
#include "jpeg.h"
#include "audio.h"
#include "enc.h"
#include "osd.h"
#include "md.h"
#include "effect.h"


static unsigned long    s_ulRawDmaAddr;             /* ԭʼƵdmaַ */

static unsigned long    s_ulTransReadAhb;           /* õck˻(dmaдʼַ) */
static unsigned long    s_ulTransReadPhy;           /* õpcַ(dmaдĿַ) */
static unsigned long    s_ulTransReadPhySize;       /* õpcַС */

static unsigned long    s_ulTransWriteAhb;          /* дõck˻(dmapcֱдݵ˵ַ) */
static unsigned long    s_ulTransWriteAhbSize;      /* дõck˻С */

static unsigned long    s_ulFirstDmaFlag = 1;       /* һdmaı־ʵȥ? */

static DMA_FINISH_CALLBACK s_sDmaCallback[DMA_MAX]; /* dmaдʱĻص */

static unsigned long    s_ulDmaClocks[6];           /* dmaʱ */


/*
**  dmaɱ־(Ӳ״̬λ
**  ʱӲѾɣûжϷ)
*/
static unsigned long    s_ulDmaIrqFlag;

/*
**  10dmaӲ״̬Ѿɣ
**  s_ulDmaIrqFlagΪ1Ϊж
*/
static unsigned long    s_ulDmaBadCount;


#define DMA_QUE_COUNT 100                           /*  */
static dma_info_t s_dmaInfo[DMA_QUE_COUNT];         /* dmaϢ */
static int s_nDmaQueHead;                           /* ָĵһ */
static int s_nDmaQueTail;                           /* ָһ */
static int s_nDmaCount;                             /* dmaЧ */

static unsigned char s_ucMsgBuffer[4096];           /* Ϣ */
static unsigned long s_ulMsgBufLen;                 /* Ϣ */

#define SNDI_TIMER_INTERVAL          300            /* ϢʱΪ300 */
struct timer_list sndi_timer;                       /* Ϣʱ */


/*
**  dmaʱ䣬Ҫs_ulDmaClocks
**  0ʾʼʱӵλ
**  1ʾʼʱӸλ
**  2ʾʱӵλ
**  3ʾʱӸλ
**  4ʾdmaʱĵλ
**  5ʾdmaʱĸλ(ʱ)
**  ûֶȡs_ulDmaClocksֵdmaʱ
*/
static void calc_dma_clock(void)
{
    unsigned long l, h;

    s_ulDmaClocks[2] = read_reg(SYSTEM_CLOCK_L);    /* dmaʱ */
    s_ulDmaClocks[3] = read_reg(SYSTEM_CLOCK_H);

    if (s_ulDmaClocks[3] > s_ulDmaClocks[1])
    {
        if (s_ulDmaClocks[2] >= s_ulDmaClocks[0])
        {
            h = s_ulDmaClocks[3] - s_ulDmaClocks[1];
            l = s_ulDmaClocks[2] - s_ulDmaClocks[0];
        }
        else
        {
            h = s_ulDmaClocks[3] - s_ulDmaClocks[1] - 1;
            l = 0xFFFFFFFF - s_ulDmaClocks[0] + s_ulDmaClocks[2];   /* ʵӦü1ӱŻͲ */
        }
    }
    else if (s_ulDmaClocks[3] == s_ulDmaClocks[1])
    {
        if (s_ulDmaClocks[2] <= s_ulDmaClocks[0])
        {
            PRINT(ERR, "calc dma err0\n");
            return;
        }

        h = 0;
        l = s_ulDmaClocks[2] - s_ulDmaClocks[0];
    }
    else
    {
        PRINT(ERR, "calc dma err1\n");
        return;
    }

    if (h > s_ulDmaClocks[5])
    {
        s_ulDmaClocks[4] = l;
        s_ulDmaClocks[5] = h;
    }
    else if (h == s_ulDmaClocks[5])
    {
        if (l > s_ulDmaClocks[4])
        {
            s_ulDmaClocks[4] = l;
            s_ulDmaClocks[5] = h;
        }
    }

    return;
}


/*
**  עdmaɵĻص
*/
void register_dma_callback(unsigned long ulModule, DMA_FINISH_CALLBACK pCallback)
{
    if (ulModule >= DMA_MAX)
    {
        return;
    }

    s_sDmaCallback[ulModule] = pCallback;

    return;
}


/*
**  ϢȷʵϢӳ̫
**  0xB1
*/
static void send_intime(unsigned long v)
{
    mbx_head_t *pMbxHead;

    pMbxHead = (mbx_head_t *)CK2PC_MSG_BASE;
    if (s_ulMsgBufLen != 0 || pMbxHead->len != 0)   /* лϢ䲻Ϊ */
    {
        send_message(0, 0, 0, 1);
    }

    sndi_timer.data = 0;                            /* Ϣʱ */
    sndi_timer.function = send_intime;
    sndi_timer.expires = jiffies + SNDI_TIMER_INTERVAL;
    add_timer(&sndi_timer);

    return;
}


/*
**  pcλдд֮󲢲Ҫ
**  ϢȲ̶£
**  ţ֣01...n
**  ÿΪʼַĵַnϵֵϵֵ
**  ĿǰʱӦãַõͬһֵͻֵ
**  0xB0
*/
static void cmd_trans_write_bit(unsigned char *pucData, int nLength)
{
    unsigned long *pulData;
    unsigned long ulAddr;
    unsigned long ulItemCount;
    unsigned long ulAddrCount;
    unsigned long ulRead;
    unsigned long ulValAnd;
    unsigned long ulValOr;
    unsigned long u0, u1;

    pulData = (unsigned long *)(pucData + 8);
    ulItemCount = byte_swap4(pulData[0]);           /* ȡ */
    pulData++;                                      /* ָһ */

    for (u0 = 0; u0 < ulItemCount; u0++)
    {
        ulAddr = byte_swap4(pulData[0]);            /* ȡַ */
        ulAddrCount = byte_swap4(pulData[1]);       /* ȡĵַ */
        ulValAnd = byte_swap4(pulData[2]);          /* ȡ */
        ulValOr = byte_swap4(pulData[3]);           /* ȡλֵ */
        pulData += 4;

        for (u1 = 0; u1 < ulAddrCount; u1++)
        {
            ulRead = read_reg(ulAddr);
            ulRead &= ulValAnd;
            ulRead |= ulValOr;
            write_reg(ulAddr, ulRead);

            ulAddr += 4;
        }
    }

    return;
}


/*
**  Ϣpc
**  ˺ֻж̺Ͷʱ
**  ڶʱܻ̿ᱻжռӦڶʱжϽб
**  cmd:        
**  message:    Ϣ
**  length:     Ϣ峤(Ϊ0˵ֻ8ֽڵϢͷ)
**  irq:        Ƿжϵı־
**  0˵ɹ-1˵ʧܣ뻺Ҳǳɹ
**  0xAF
*/
int send_message(unsigned char cmd, unsigned char *message, unsigned short length, int irq)
{
    int ret;
    mbx_head_t *pMbxHead;
    msg_head_t *pMsgHead;

    if (irq)
    {
        local_irq_disable();                        /* ж */
    }

    FUNC_TRACK(0xAF);

    if (length > 1024)                              /* ֤Ϣ(ϢпΪ0) */
    {
        ret = -1;
        FUNC_COUNTER(0xAF, 0x00);
        PRINT(ERR, "Message length %d\n", length);
        goto clear;                                 /* ûϢģʱӦҲûйϵ */
    }

    /* ֻΪʱܷµϢҪϢ */
    pMbxHead = (mbx_head_t *)CK2PC_MSG_BASE;
    if (pMbxHead->len != 0)                         /* 0ôСת */
    {
        if (s_ulMsgBufLen + length <= 4088)         /* ϢСΪ4096ֽڣ8ֽڵϢͷ */
        {
            if (cmd)                                /* Ϣÿ */
            {
                pMsgHead = (msg_head_t *)(s_ucMsgBuffer + s_ulMsgBufLen);   /* Ϣͷ */
                pMsgHead->cmd = cmd;
                pMsgHead->link = 0xA0;              /* pcʵλ */
                pMsgHead->len = byte_swap2(length);
                pMsgHead->ack = 0;                  /* ҪӦ */

                if (length > 0)                     /* Ϣ */
                {
                    memcpy(s_ucMsgBuffer + s_ulMsgBufLen + 8, message, length);
                }

                s_ulMsgBufLen += (length + 8);      /* ӻϢܳ */
            }

            ret = 0;                                /* ϢҲɹ */
            goto clear;
        }
        else
        {
            ret = -1;
            FUNC_COUNTER(0xAF, 0x01);
            PRINT(ERR, "Mailbox buf full\n");
            goto clear;
        }
    }

    if (s_ulMsgBufLen > 0)                          /* ҪȷϢ */
    {
        memcpy((void *)(CK2PC_MSG_BASE + sizeof(mbx_head_t)), s_ucMsgBuffer, s_ulMsgBufLen);
    }

    if (cmd)
    {
        pMsgHead = (msg_head_t *)(CK2PC_MSG_BASE + sizeof(mbx_head_t) + s_ulMsgBufLen);
        pMsgHead->cmd = cmd;
        pMsgHead->link = 0xA0;                      /* pcʵλ */
        pMsgHead->len = byte_swap2(length);
        pMsgHead->ack = 0;                          /* ҪӦ */

        if (length > 0)                             /* ʱҪͷϢͷӳӦûŻ? */
        {
            memcpy((void *)(CK2PC_MSG_BASE + sizeof(mbx_head_t) + sizeof(msg_head_t) + s_ulMsgBufLen), message, length);
        }
    }
    pMbxHead->len = byte_swap2(length + sizeof(msg_head_t) + s_ulMsgBufLen);    /* д䳤 */

    s_ulMsgBufLen = 0;                              /* ջϢ */
    ret = 0;

clear:
    read_reg(SYSTEM_CLOCK_L);                       /* ܶж??? */

    hw_pci_knock_door();                            /* ֪ͨpc */

    if (irq)
    {
        local_irq_enable();                         /* ж */
    }

    return ret;
}


/*
**  յpc˵ԭʼƵdmaַdmaһٵݣȻλdma
**  忨λDMAģδܸλ
**  0xAE
*/
static void pci_dma_write_first(void)
{
    unsigned long ulControl;

    FUNC_TRACK(0xAE);

    if (0 == s_ulRawDmaAddr)
    {
        FUNC_COUNTER(0xAD, 0x00);
        PRINT(ERR, "Dma addr invalid\n");
        return;
    }

    ulControl = (0x400 << 8 ) | 0x71;
    write_ahb(WDMA_PCI_ADDR, s_ulRawDmaAddr);
    write_ahb(WDMA_AHB_ADDR, 0xC0500000);
    write_ahb(WDMA_CONTROL, ulControl);
    write_ahb(WDMA_CONTROL, 0x7A);

    return;
}


/*
**  pci dmaдɵĻص
**  ڴ˺Ҫ£ϢصԼdma
**  newtaskΪ1ʾҪµdma񣬷ʾ
**
**  ڴ˺send_messagepci_dma_writeѾҪжϣΪô˺ֻط
**  һжϷ̣ﵱȻùжϣһpci_dma_writeҪжϣpci_dma_writeӦþ͹ع
**  0xAD
*/
static int pci_dma_write_finish(int newtask)
{
    unsigned long mod;
    dma_info_t *pDmaInfo;

    FUNC_TRACK(0xAD);

    if (s_nDmaCount < 1)                            /* жdma */
    {
        /* пpci_dma_writepci_dma_write_finish(0)˴ */
        FUNC_COUNTER(0xAD, 0x00);
        return -1;
    }

    pDmaInfo = s_dmaInfo + s_nDmaQueHead;           /* ָͷ */
    if (0 == pDmaInfo->out)                         /* жϸûб */
    {
        /* пpci_dma_writepci_dma_write_finish(0)˴dmaҪ */
        FUNC_COUNTER(0xAD, 0x01);
        goto newnew;
    }

    if (pDmaInfo->command)                          /* жǷҪϢ */
    {
        /* ûϢ壬msgLengthӦΪ0 */
        send_message(pDmaInfo->command, pDmaInfo->msgBuffer, pDmaInfo->msgLength, 0);
    }

    mod = pDmaInfo->module;
    if (mod)                                        /* жǷҪص */
    {
        if (DMA_FREE < mod && mod < DMA_MAX)
        {
            if (s_sDmaCallback[mod])
            {
                s_sDmaCallback[mod]();
            }
        }
    }

    /* ɾ */
    pDmaInfo->out = 0;                              /* ȫǰout־0 */
    s_nDmaCount--;                                  /* һ */
    s_nDmaQueHead++;                                /* ͷ */
    if (s_nDmaQueHead >= DMA_QUE_COUNT)             /* ؾʼ */
    {
        s_nDmaQueHead = 0;
    }

newnew:
    if (newtask && (s_nDmaCount > 0))
    {
        pDmaInfo = s_dmaInfo + s_nDmaQueHead;       /* ֮ǰdmaȲжʧ */

        pci_dma_write(pDmaInfo, 1, 0);
    }

    return 0;
}


/*
**  УdmaʱҪʹ(緢Ϣص)
**  ͬʱҲԽʱܷ͵dmaУdmaʱٷ
**  Ƚȳԭ
**  0˵ɹ-1˵ʧ
**  0xAC
*/
static int pci_dma_queue(dma_info_t *pDmaInfo)
{
    dma_info_t *pNew;

    FUNC_TRACK(0xAC);

    /* ַΪ */
    if (0 == pDmaInfo->pciAddr || 0 == pDmaInfo->ahbAddr)
    {
        FUNC_COUNTER(0xAC, 0x00);
        PRINT(ERR, "pci_dma_queue para err\n");
        return -1;
    }

    /* ַӦ4ֽڶ */
    if ((pDmaInfo->ahbAddr & 0x3) != 0)
    {
        FUNC_COUNTER(0xAC, 0x01);
        PRINT(ERR, "pci_dma_queue para err\n");
        return -1;
    }

    /* жϳȣ߷ֱʱԤݱȽϴ */
    if (pDmaInfo->dmaLength < 1 || pDmaInfo->dmaLength > 0x1000000)
    {
        FUNC_COUNTER(0xAC, 0x02);
        PRINT(ERR, "pci_dma_queue para err\n");
        return -1;
    }

    if (s_nDmaCount >= DMA_QUE_COUNT)               /* жdma */
    {
        g_nGlobalQueueFull = 1;                     /* ʱ֮Ԥ */
        FUNC_COUNTER(0xAC, 0x03);
        PRINT(ERR, "dma queue full\n");
        return -1;
    }

    pNew = s_dmaInfo + s_nDmaQueTail;               /* ָβ */
    memcpy(pNew, pDmaInfo, 28);                     /* ǰ7ʣϢҪ */
    pNew->out = 0;                                  /* ˵ûdma */

    if (pNew->command)
    {
        if (pNew->msgLength < 0 || pNew->msgLength > 64)    /* Ϣ峤ȲϷ */
        {
            FUNC_COUNTER(0xAC, 0x04);               /* ¼쳣Ϣ */
            PRINT(ERR, "dma queue msg body error\n");
            return -1;
        }
        else if (pNew->msgLength != 0)              /* Ϊ0ҪΪ0˵ֻϢͷûϢ */
        {
            memcpy(pNew->msgBuffer, pDmaInfo->msgBuffer, pNew->msgLength);
        }
    }
    else
    {
        pNew->msgLength = 0;                        /* commandΪ0˵ҪϢѳҲ0Ϊ˱ */
    }

    s_nDmaCount++;                                  /* һ */
    s_nDmaQueTail++;                                /* β */
    if (s_nDmaQueTail >= DMA_QUE_COUNT)             /* ؾʼ */
    {
        s_nDmaQueTail = 0;
    }

    return 0;
}


/*
**  ȡdmaһ
**  0˵ɹ-1˵ʧ
**  ش
**  0xAB
*/
static int pci_dma_get_head(unsigned long *pdst, unsigned long *psrc, int *plen)
{
    dma_info_t *pDmaInfo;

    FUNC_TRACK(0xAB);

    if (s_nDmaCount < 1 || s_nDmaCount > DMA_QUE_COUNT)
    {
        goto clear;
    }

    pDmaInfo = s_dmaInfo + s_nDmaQueHead;           /* ָһ*/

    if (pDmaInfo->pciAddr)                          /* ֤Ŀַ */
    {
        if (pDmaInfo->ahbAddr)                      /* ֤Դַ */
        {
            /* ֤ݳȣ߷ֱʱԤݱȽϴ */
            if (1 <= pDmaInfo->dmaLength && pDmaInfo->dmaLength <= 0x1000000)
            {
                *pdst = pDmaInfo->pciAddr;
                *psrc = pDmaInfo->ahbAddr;
                *plen = pDmaInfo->dmaLength;
                pDmaInfo->out = 1;                  /* ־Ѿ */

                return 0;
            }
        }
    }

clear:
    FUNC_COUNTER(0xAB, 0x00);

    s_nDmaCount = 0;                                /* ն */
    s_nDmaQueHead = 0;
    s_nDmaQueTail = 0;

    return -1;
}

/*
**  pci dmaд
**
**  pDmaInfo:   dmaĿַԴַȣԼdmaʱҪ͵Ϣص
**  exist:      ʾdmaǷѾڶһⲿʱֵΪ0˵֮ǰڶ
**              pci_dma_write_finishô˺ʱֵӦ1˵Ѿڶظ
**  irq:        ʾǷҪжϣһж̵ô˺ʱҪأʱ̵ô˺Ҫж
**
**  0˵ɹ-1˵ʧܣҲǳɹ
**  0xAA
*/
int pci_dma_write(dma_info_t *pDmaInfo, int exist, int irq)
{
    int ret;
    int nLength;
    unsigned long ulPciAddr;
    unsigned long ulAhbAddr;
    unsigned long ulControl;

    if (irq)                                        /* ʱҪжϣжﲻҪ */
    {
        local_irq_disable();
    }

    FUNC_TRACK(0xAA);

    if (0 == exist)                                 /* ״ν뵽β */
    {
        ret = pci_dma_queue(pDmaInfo);
        if (ret != 0)
        {
            ret = -1;
            FUNC_COUNTER(0xAA, 0x00);
            goto clear;
        }
    }

    ulControl = read_ahb(WDMA_CONTROL);             /* Ӳжdmaû */
    if (1 == (ulControl & 0x1))
    {
        ret = 0;
        FUNC_COUNTER(0xAA, 0x01);
        goto clear;
    }

    if (s_ulDmaIrqFlag != 0)
    {
        /*
        ** ǹжϵĹϵʱdmaɣû뵽pci_handler
        ** Ҫpci_dma_write_finishӦϢȥ
        */
        FUNC_COUNTER(0xAA, 0x02);

        /*
        **  10dmaӲ״̬Ѿɣs_ulDmaIrqFlagΪ1Ϊж
        **  ʱҲΪһεdmaӦѾɣԵpci_dma_write_finish
        **  dmaϢԼصƳȥ
        **  ȫѲΪ0dmaݹ
        **
        **  ԤԴʱ16ͨȫ˻ƣᵼ1ͨϢƳȥ
        **  Ӧ0ͨdmaɺ󣬳ٳûdmạ0ͨϢڴ˱Ƴ
        **  Ƚ0̺ͨ1ͨϢƳȥ1ͨȻڶ
        **  ûdma_info_tṹout־ӦÿԽ
        **
        **  Դʱˣdmaж϶ˣᱨfull
        */

#ifndef VS28XX_MODE_ID
        s_ulDmaBadCount++;
        if (s_ulDmaBadCount >= 10)
        {
            s_ulDmaIrqFlag = 0;
            s_ulDmaBadCount = 0;
            pci_dma_write_finish(0);

            FUNC_COUNTER(0xAA, 0x03);
            PRINT(WARN, "dma irq may lost\n");
        }
#endif
        ret = 0;
        goto clear;
    }

    s_ulDmaBadCount = 0;

    /* ȡdmaеĵһд */
    ret = pci_dma_get_head(&ulPciAddr, &ulAhbAddr, &nLength);
    if (ret != 0)
    {
        ret = -1;
        FUNC_COUNTER(0xAA, 0x04);
        PRINT(ERR, "serious err\n");                /* ش */
        goto clear;
    }

    s_ulDmaClocks[0] = read_reg(SYSTEM_CLOCK_L);    /* dmaʼʱ */
    s_ulDmaClocks[1] = read_reg(SYSTEM_CLOCK_H);
    FUNC_COUNTER(0xAA, 0x05);                       /* ¼dma */

    s_ulDmaIrqFlag = 1;                             /* ־dma */

    ulControl = (nLength << 8 ) | 0x79;
    write_ahb(WDMA_PCI_ADDR, ulPciAddr);
    write_ahb(WDMA_AHB_ADDR, ulAhbAddr);
    write_ahb(WDMA_CONTROL, ulControl);
    ret = 0;

clear:
    if (irq)
    {
        local_irq_enable();                         /* ж */
    }

    return ret;
}


/*
**  pcֱӶͨϢضĽ
**  ϢȲ̶£
**  ţ֣01...n
**  ÿΪʼַ0ĵַ0ʼַ1ĵַ1...
**  0xA9
*/
static void cmd_trans_read_direct(unsigned char *pucData, int nLength)
{
    unsigned long *pulData;
    unsigned long ulAddr;
    unsigned long ulItemCount;
    unsigned long ulAddrCount;
    unsigned long u0, u1;
    unsigned long sulFeedback[256];
    unsigned long *pulFeedback;
    unsigned long ulFeedbackSize;

    FUNC_TRACK(0xA9);

    pulData = (unsigned long *)pucData;

    if (pulData[1] != 0)                            /* ȷ֣0Ϊ1,2Ϊд(0ôСת) */
    {
        FUNC_COUNTER(0xA9, 0x00);
        return;
    }

    sulFeedback[0] = pulData[0];                    /* (ΪհᣬԲתС) */
    sulFeedback[1] = pulData[1];                    /* ֣0Ϊ1Ϊд */
    sulFeedback[2] = pulData[2];                    /*  */

    ulItemCount = byte_swap4(pulData[2]);           /* ȡ */

    pulData += 3;                                   /* ָһ */
    pulFeedback = sulFeedback + 3;
    ulFeedbackSize = 12;                            /* ţֺΪ12ֽ */

    for (u0 = 0; u0 < ulItemCount; u0++)
    {
        if (ulFeedbackSize >= 1016)                 /* ﵽ1016Ϻģ϶1024 */
        {
            FUNC_COUNTER(0xA9, 0x01);
            return;
        }

        ulAddr = byte_swap4(pulData[0]);            /* ȡַ */
        ulAddrCount = byte_swap4(pulData[1]);       /* ȡĵַ */
        pulFeedback[0] = pulData[0];
        pulFeedback[1] = pulData[1];
        pulFeedback += 2;
        ulFeedbackSize += 8;

        pulData += 2;                               /* Ԥָһ */

        for (u1 = 0; u1 < ulAddrCount; u1++)
        {
            if (ulFeedbackSize >= 1024)             /* ﵽ1024Ϻģ϶1024 */
            {
                FUNC_COUNTER(0xA9, 0x02);
                return;
            }

            pulFeedback[u1] = byte_swap4(*(volatile unsigned long *)ulAddr);
            ulAddr += 4;
            ulFeedbackSize += 4;
        }

        pulFeedback += ulAddrCount;
    }

    send_message(0x91, (unsigned char *)sulFeedback, ulFeedbackSize, 0);

    return;
}


/*
**  pcֱдд֮󲢲Ҫ
**  ϢȲ̶£
**  ţ֣01...n
**  ÿΪʼַĵַnnֵ
**  0xA8
*/
static void cmd_trans_write_direct(unsigned char *pucData, int nLength)
{
    unsigned long *pulData;
    unsigned long ulCommand;
    unsigned long ulAddr;
    unsigned long ulItemCount;
    unsigned long ulAddrCount;
    unsigned long u0, u1;

    FUNC_TRACK(0xA8);

    pulData = (unsigned long *)(pucData + 4);       /* ȡ0Ϊ1,2Ϊд() */
    ulCommand = byte_swap4(pulData[0]);

    if (2 == ulCommand)                             /* ʾidʱдĴ */
    {
        enc_id_prepare();                           /* ׼id */
    }
    else if (5 == ulCommand)                        /* i2c */
    {
#ifdef IIC_THREAD
        tell_i2c_thread(pucData + 8, nLength - 8);
#endif
        return;
    }
    else if (6 == ulCommand)                        /* λд */
    {
        cmd_trans_write_bit(pucData, nLength);
        return;
    }
    else if (ulCommand != 1)                        /* 1ʾͨдĴ */
    {
        FUNC_COUNTER(0xA8, 0x00);
        return;
    }

    ulItemCount = byte_swap4(pulData[1]);           /* ȡ */
    pulData += 2;                                   /* ָһ */

    for (u0 = 0; u0 < ulItemCount; u0++)
    {
        ulAddr = byte_swap4(pulData[0]);            /* ȡַ */
        ulAddrCount = byte_swap4(pulData[1]);       /* ȡĵַ */
        pulData += 2;

        for (u1 = 0; u1 < ulAddrCount; u1++)
        {
            *(volatile unsigned long *)ulAddr = byte_swap4(pulData[u1]);
            ulAddr += 4;
        }
        pulData += ulAddrCount;
    }

    return;
}


/*
**  ()ckҪͨdmaдȥ
**  ϢΪ12ֽڣ3ֱʾţԴַ
**  ͷΪ16ֽڣ4ֱʾ״̬ţַ
**  0xA7
*/
static void cmd_trans_read_file(unsigned char *pucData, int nLength)
{
    unsigned long *pulSrc;
    unsigned long *pulDst;
    unsigned long ulLength;
    unsigned long ulCount;
    unsigned long ulBank;
    unsigned long u;
    msg_trans_rf_t *pMsg;
    dma_info_t dmaInfo;

    FUNC_TRACK(0xA7);

    if (nLength != sizeof(msg_trans_rf_t))          /* ֤Ϣ */
    {
        FUNC_COUNTER(0xA7, 0x00);
        PRINT(ERR, "trf len err0 %d\n", nLength);
        return;
    }

    pMsg = (msg_trans_rf_t *)pucData;               /* ȡpcĵַͳ */
    pulSrc = (unsigned long *)(byte_swap4(pMsg->addr));
    ulLength = byte_swap4(pMsg->len);

    /* ȷpc˵ַ㹻 */
    if (0 == s_ulTransReadPhy || s_ulTransReadPhySize < (ulLength + 16))
    {
        FUNC_COUNTER(0xA7, 0x01);
        PRINT(ERR, "trf len err1 0x%lx \n", ulLength);
        return;
    }

    pulDst = (unsigned long *)s_ulTransReadAhb;     /* Ȱݿתͨdmaȥ */

    pulDst[0] = byte_swap4(2);                      /* 0ʾУ1ʾȴCK2ʾȴPC */
    pulDst[1] = pMsg->serial;                       /* (հᣬԲôСת) */
    pulDst[2] = pMsg->addr;                         /* ַ(հᣬԲôСת) */
    pulDst[3] = byte_swap4(ulLength);               /*  */

    ulBank = ((unsigned long)pulSrc >> 28) & 0xF;   /* жڴ */
    if (0xC == ulBank || 0xE == ulBank)             /* c,eڴֱӿ */
    {
        memcpy((void *)(pulDst + 4), (void *)pulSrc, ulLength);       /* ͷ16ֽ */
    }
    else                                            /* ĴҪһ */
    {
        ulCount = ulLength / 4;
        pulDst += 4;                                /* ͷ16ֽ */
        for (u = 0; u < ulCount; u++)
        {
            pulDst[u] = pulSrc[u];                  /* ôСת */
        }
    }

    dmaInfo.pciAddr = s_ulTransReadPhy;
    dmaInfo.ahbAddr = s_ulTransReadAhb;
    dmaInfo.dmaLength = ulLength + 16;              /* ݳȼͷ16ֽ */
    dmaInfo.module = 0;                             /* Ҫص */
    dmaInfo.command = 0x92;
    dmaInfo.msgLength = 0;                          /* Ϣ */

    pci_dma_write(&dmaInfo, 0, 0);                  /* ΪжԲҪж */

    return;
}


/*
**  ԭʼƵdmaַи˵õַ
**  Ŀǰõdmaʽдpcֱдckڴ
**  ֻĵַ
**
**  0xA6
*/
static void cmd_raw_set_dma_addr(unsigned char *pucData, int nLength)
{
    msg_odma_t *pMsg;

    FUNC_TRACK(0xA6);

    if (nLength != sizeof(msg_odma_t))              /* ֤Ϣ */
    {
        FUNC_COUNTER(0xA6, 0x00);
        PRINT(ERR, "raw addr err %d\n", nLength);

        return;
    }

    pMsg = (msg_odma_t *)pucData;

    s_ulRawDmaAddr = byte_swap4(pMsg->oaddr);       /* ԭʼƵdmaַ */

    s_ulTransReadPhy = byte_swap4(pMsg->raddr);     /* ()pcַ */
    s_ulTransReadPhySize = byte_swap4(pMsg->rlen);  /* ַ */

    FUNC_INFO2(0xA6, 1, s_ulTransReadPhy, s_ulTransReadPhySize);    /* д־ */

    PRINT(INFO, "raw 0x%lx 0x%lx\n", s_ulTransReadPhy, s_ulTransReadPhySize);

    return;
}

/*
**  ַpciϢ֮
**  0xA5
*/
static void pci_dispatch(void)
{
    unsigned char *puc;
    unsigned char *pucStop;
    unsigned short usMailLen;
    unsigned short usMsgLen;
    mbx_head_t *pMbxHead;
    msg_head_t *pMsgHead;

    FUNC_TRACK(0xA5);

    pMbxHead = (mbx_head_t *)PC2CK_MSG_BASE;        /* ͷȡ䳤 */
    usMailLen = byte_swap2(pMbxHead->len);

    /* ݳܰһϢͷҲܳ40k-32 */
    if (usMailLen < sizeof(msg_head_t) || usMailLen > PC2CK_MAIL_MAX)
    {
        FUNC_COUNTER(0xA5, 0x00);
        goto clear;
    }

    puc = (unsigned char *)(pMbxHead + 1);          /* ָһϢ */
    pucStop = puc + usMailLen;                      /* λĩβ */

    while ((pucStop - puc) >= sizeof(msg_head_t))   /* ȷʣܰһϢͷ */
    {
        pMsgHead = (msg_head_t *)puc;               /* λϢͷȡϢ峤 */
        usMsgLen = byte_swap2(pMsgHead->len);

        puc += sizeof(msg_head_t);                  /* ָϢ */

        if ((puc + usMsgLen) > pucStop)             /* ȷϢûгΧ */
        {
            FUNC_COUNTER(0xA5, 0x01);
            goto clear;
        }

        switch (pMsgHead->cmd)
        {
        case CMD_SET_FONT:                          /* Զ(֮ǰ) */
            cmd_eff_func(puc, usMsgLen);
            break;

        case CMD_AUD_PARA:                          /* Ƶ(֮ǰƵԤ) */
            cmd_aud_set_para(puc, usMsgLen);
            break;

        case CMD_AUD_SWITCH:                        /* Ƶ뿪(֮ǰƵԤ) */
            cmd_aud_set_switch(puc, usMsgLen);
            break;

        case CMD_PRE_POS:                           /* ƵλãĿǰڿؽ */
            cmd_pre_set_enh(puc, usMsgLen);
            break;

        case CMD_DMA_JPEG:                          /* jpeg dmaַ */
            cmd_jpg_set_dma_addr(puc, usMsgLen);
            break;

        case CMD_DMA_PRE:                           /* ԤƵdmaַ */
            cmd_pre_set_dma_addr(puc, usMsgLen);
            break;

        case CMD_DMA_ENC:                           /* ñdmaַ */
            cmd_enc_set_dma_addr(puc, usMsgLen);
            break;

        case CMD_DMA_RAW:                           /* ԭʼƵdmaַ */
            cmd_raw_set_dma_addr(puc, usMsgLen);

            /*
            ** յpc˵ԭʼƵdmaַdmaһٵݣȻλdma
            ** 忨λDMAģδܸλ
            */
            pci_dma_write_first();

            break;

        case CMD_PRE_SWITCH:                        /* Ԥ */
            cmd_pre_set_switch(puc, usMsgLen);
            break;

        case CMD_JPEG_SWITCH:                       /* jpeg */
            cmd_jpg_set_switch(puc, usMsgLen);
            break;

        case CMD_ENC_SWITCH:                        /* 뿪 */
            cmd_enc_set_switch(puc, usMsgLen);
            break;

        case CMD_STR_SEL:                           /* ѡ */
            cmd_enc_set_strsel(puc, usMsgLen);
            break;

        case CMD_ENC_PARA:                          /*  */
            cmd_enc_set_para(puc, usMsgLen);
            break;

        case CMD_MASK_SWITCH:                       /* mask */
            cmd_mask_set_switch(puc, usMsgLen);
            break;

        case CMD_MASK_DATA:                         /* mask */
            cmd_mask_set_data(puc, usMsgLen);
            break;

        case CMD_MEM_READ:                          /* pcֱӶ */
            cmd_trans_read_direct(puc, usMsgLen);
            break;

        case CMD_MEM_WRITE:                         /* pcֱд */
            cmd_trans_write_direct(puc, usMsgLen);
            break;

        case CMD_FILE_READ:                         /* pcļckҪͨdmaд */
            cmd_trans_read_file(puc, usMsgLen);
            break;

        case CMD_OSD_SWITCH:                        /* osd */
            cmd_osd_set_switch(puc, usMsgLen);
            break;

        case CMD_OSD_DATA:                          /* osd */
            cmd_osd_set_data(puc, usMsgLen);
            break;

        case CMD_MOTION_SWH:                        /* ä쿪 */
            cmd_md_set_switch(puc, usMsgLen);
            break;

        case CMD_MOTION_PARA:                       /*  */
            cmd_md_set_para(puc, usMsgLen);
            break;

        case CMD_MOTION_AREA:                       /*  */
            cmd_md_set_area(puc, usMsgLen);
            break;

        default:
            FUNC_COUNTER(0xA5, 0x02);
            break;

        } /* switch (pMsgHead->cmd) */

        puc += usMsgLen;                            /* ֮ǰָϢ壬ϢָһϢͷ */

    } /* while (puc < pucStop) */

clear:
    write_reg(PC2CK_MSG_BASE, 0);                   /*  */

    return;
}


/*
**  pc˵
**  ڴͷϢΪ:
**  ״ַ̬ͣȣͨţȣ߶ȵȣ64ֽ
**  0xA4
*/
static void trans_write_file_finish(void)
{
    unsigned long u;
    unsigned long ulType;
    unsigned long ulDstAddr;
    unsigned long ulLength;
    unsigned long ulCount;
    unsigned long ulBank;
    volatile unsigned long *pulSrc;
    volatile unsigned long *pulDst;

    FUNC_TRACK(0xA4);

    pulSrc = (unsigned long *)s_ulTransWriteAhb;

    if (0 == pulSrc[0])                             /* 0ʾûݣ1ʾ(0ҪСת) */
    {
        FUNC_COUNTER(0xA4, 0x00);
        return;
    }

    /*
    **  ͣ1ʾͨݣ3ʾ(jpeg)Դ4ʾԤԴ5ʾУ
    **  6ʾƵԴ7ʾԤԴID8ʾԤԴʱosdݣ9ʾmaskݣ10ʾƴԴ
    **  11ʾƴosdݣ12ʾԴݣ13ʾosdݣ14ʾ2DԵԴݣ15ʾԴ
    */
    ulType = byte_swap4(pulSrc[1]);
    if (3 <= ulType && ulType <= 15)
    {
    	yuv_data_ready(s_ulTransWriteAhb);
        return;
    }
    else if (ulType != 1)
    {
        write_reg(s_ulTransWriteAhb, 0);            /* ͷϢ */

        FUNC_COUNTER(0xA4, 0x01);
	    PRINT(ERR, "trans unknow 0x%lx\n", ulType);

	    return;
    }

    ulDstAddr = byte_swap4(pulSrc[2]);              /* ĿַֻΪ1ʱЧ */
    ulLength = byte_swap4(pulSrc[3]);               /* ݳ */

    pulSrc += 16;                                   /* ָԴ(ͷ64ֽ) */
    pulDst = (unsigned long *)ulDstAddr;            /* ָĿ */

    ulBank = (ulDstAddr >> 28) & 0xF;               /* жڴ */
    if (0xC == ulBank || 0xE == ulBank)             /* c,eڴֱӿ */
    {
        memcpy((void *)pulDst, (void *)pulSrc, ulLength);
    }
    else                                            /* ҪĴʽд */
    {
        ulCount = ulLength / 4;
        for (u = 0; u < ulCount; u++)
        {
            pulDst[u] = pulSrc[u];                  /* ôСת */
        }
    }

    write_reg(s_ulTransWriteAhb, 0);                /* ڴͷ */

    return;
}


/*
**  pciж
**  0xA3
*/
static void pci_handler(int irq, void *dummy, struct pt_regs *regs)
{
    unsigned long ulIrqState;

    hw_pci_get_state(&ulIrqState);                  /* ȡpciж״̬Ȼж */

    FUNC_PARA1(0xA3, ulIrqState);                   /* д־ */

    if (ulIrqState & WDMA_MASK)                     /* dmaд */
    {
        if (id_pre_doing_now)                       /* ԤԴʱʾԻڽ */
        {
            id_frame_jiffies = jiffies;
        }

        if (s_ulFirstDmaFlag)                       /* һdmaôpci_dma_write_first */
        {
            s_ulFirstDmaFlag = 0;
        }
        else
        {
            s_ulDmaIrqFlag = 0;                     /* ־dma */
            calc_dma_clock();                       /* dmaʱ */
            pci_dma_write_finish(1);

            FUNC_COUNTER(0xA3, 0x01);               /* DMAдɼ */
        }
    }

    if (ulIrqState & DOOR_MASK3)                    /* pc˵ */
    {
        if (id_pre_doing_now)                       /* ԤԴʱʾԻڽ */
        {
            id_frame_jiffies = jiffies;
        }

        trans_write_file_finish();
    }

    if (ulIrqState & DOOR_MASK1)                    /* pc˷Ϣ */
    {
        pci_dispatch();                             /* ַpciϢ */
    }

    return;
}


/*
**  뵼ڴ
**  дڴҪpcֱдڴ棬Ŀǰbar4ĴСΪ64M
**  ҪڴҲ64MΧ֮
**  ĿǰϵͳΪ32MĿռӦǷҪ
**  0xA2
*/
static void trans_mem_init(void)
{
    FUNC_TRACK(0xA2);

    /*
    **  뵼ڴ
    **  ĶǶPC˵ģ0x100400СPCһοԶļСΪ1M1K־
    */
    s_ulTransReadAhb = (unsigned long)kmalloc(0x100400, GFP_KERNEL | GFP_DMA);
    if (0 == s_ulTransReadAhb)
    {
        FUNC_COUNTER(0xA2, 0x00);
        PRINT(ERR, "trans_mem_initr fail\n");
        return;
    }

    /*
    **  뵼дڴ
    **  дǶPC˵ģ0x400400СPCһοдļСΪ4M1K־
    **  ʵôռ䣬ҪΪ˵ƴԴ(1920*1080*2)
    */
    s_ulTransWriteAhb = (unsigned long)kmalloc(0x400400, GFP_KERNEL | GFP_DMA);
    if (0 == s_ulTransWriteAhb)
    {
        kfree((void *)s_ulTransReadAhb);
        s_ulTransReadAhb = 0;

        FUNC_COUNTER(0xA2, 0x01);
        PRINT(ERR, "trans_mem_initw fail\n");
        return;
    }

    s_ulTransWriteAhbSize = 0x400400;

    return;
}


/*
**  pciģע
**  0xA1
*/
void pci_exit(void)
{
    FUNC_TRACK(0xA1);

    disable_irq(PCI_IRQ);                           /* ͷpciж */
    free_irq(PCI_IRQ, 0);

    if (s_ulTransReadAhb != 0)                      /* ͷŵڴ */
    {
        kfree((void *)s_ulTransReadAhb);
        s_ulTransReadAhb = 0;
    }

    if (s_ulTransWriteAhb != 0)                     /* ͷŵдڴ */
    {
        kfree((void *)s_ulTransWriteAhb);
        s_ulTransWriteAhb = 0;
        s_ulTransWriteAhbSize = 0;
    }

    return;
}


/*
**  pciģʼ
**  0xA0
*/
int vs2811_pci_init(void)
{
    int ret;

    FUNC_TRACK(0xA0);

    trans_mem_init();                               /* 뵼ڴ */
    if (0 == s_ulTransReadAhb || 0 == s_ulTransWriteAhb)
    {
        FUNC_COUNTER(0xA0, 0x00);
        PRINT(ERR, "pci_init memory fail\n");
        return -1;
    }

    /* ѵдڴַͳȷڳʼϢ֮Ҫpc */
    g_ulPciInitBuffer[80] = byte_swap4(s_ulTransWriteAhb);
    g_ulPciInitBuffer[81] = byte_swap4(s_ulTransWriteAhbSize);

    /* յдڴͷ洢ŴϢ */
    memset((void *)s_ulTransWriteAhb, 0, 64);

    /* ͷ */
    memset((void *)(PC2CK_MSG_BASE), 0, sizeof(mbx_head_t));
    memset((void *)(CK2PC_MSG_BASE), 0, sizeof(mbx_head_t));

    /* pci dmaȷdmaȷ */
    write_ahb(WDMA_CONTROL, 0x7A);

    /* pciж״̬ */
    hw_pci_clear_irq();

    /* ʹpciж */
    hw_pci_enable_door1();                          /* Ϣж */
    hw_pci_enable_door3();                          /* ж */
    hw_pci_enable_dma();                            /* dmaж */

    /* pciж */
    ret = request_irq(PCI_IRQ, pci_handler, SA_INTERRUPT, "pci_handler", 0);
    if(ret != 0)
    {
        FUNC_COUNTER(0xA0, 0x01);
        PRINT(ERR, "pci_init request_irq fail\n");
        return -1;
    }
    enable_irq(PCI_IRQ);

    /* pc˷ͳʼϢ */
    memcpy((void *)(CK2PC_MSG_BASE), g_ulPciInitBuffer, sizeof(g_ulPciInitBuffer));
    hw_pci_knock_door();

    sndi_timer.data = 0;                              /* Ϣʱ */
    sndi_timer.function = send_intime;
    sndi_timer.expires = jiffies + SNDI_TIMER_INTERVAL;
    add_timer(&sndi_timer);

    PRINT(INFO, "pci_init 0x%lx 0x%lx 0x%lx\n", s_ulTransReadAhb, s_ulTransWriteAhb, (unsigned long)s_ulDmaClocks);

    return 0;
}
