/*
**  pciģͷļ
*/

#ifndef _VS28XX_PCI_H_
#define _VS28XX_PCI_H_


/*
**  Ҫõdmaģ
*/
#define DMA_FREE                0                   /* pci dma */
#define DMA_FILE_READ           1                   /* ʹdma */
#define DMA_FILE_WRITE          2                   /* ʹdmaд */
#define DMA_PREVIEW             3                   /* Ԥʹdmaд */
#define DMA_JPEG                4                   /* jpegʹdmaд */
#define DMA_ENC                 5                   /* ʹdmaд */
#define DMA_MAX                 6                   /* ʹpci dmaģ */

typedef void (* DMA_FINISH_CALLBACK)(void);         /* dmaдʱص */

/*
**  dmaϢṹ
*/
typedef struct dma_info
{
    unsigned long   pciAddr;                        /* pc˵ַ(dmaдĿַ) */
    unsigned long   ahbAddr;                        /* ahb˵ַ(dmaдԴַ) */
    int             dmaLength;                      /* dmaĳ */
    int             out;                            /* dmaģڲʹãΪ0ʾûdma䣬Ϊ1ʾ */
    int             module;                         /* ʹdmaģ(Ϊ0ʾҪdmaɻص) */
    int             command;                        /* dmaʱҪ͵Ϣ(Ϊ0ʾҪϢ) */
    int             msgLength;                      /* dmaɵϢ峤(Ϊ0ʾûϢ) */
    unsigned char   msgBuffer[64];                  /* Ϣ */
} dma_info_t;

/*
**  עdmaɵĻص
*/
void register_dma_callback(unsigned long ulModule, DMA_FINISH_CALLBACK pCallback);

/*
**  Ϣpc0˵ɹ-1˵ʧ
*/
int send_message(unsigned char cmd, unsigned char *message, unsigned short length, int irq);

/*
**  pci dmaдulPciAddrΪpc˵ַulAhbAddrΪck˵ڴַֻΪcڴ
**  nType־ĸģʹdmaд2ʾ
**  0˵ɹ-1˵ʧ
*/
int pci_dma_write(dma_info_t *pDmaInfo, int exist, int irq);

/*
**  pciģע
*/
void pci_exit(void);

/*
**  pciģʼ
*/
int vs2811_pci_init(void);

#endif
