/*
**  Ԥģļ
*/

#include <linux/autoconf.h>                         /* CONFIG_CLOCKxx */
#include "vs28xx.h"
#include "log.h"
#include "list.h"
#include "pci.h"
#include "preview.h"
#include "md.h"
#include "im.h"
#include "yuv.h"
#include "effect.h"
#include "reg/preview_reg.h"
#include "iic.h"

int g_nGlobalQueueFull = 0;                         /* ʱdma֮󣬲Ԥ */

int g_nPreSwitch[3][16];                            /* ԤأԤԤMUXԤ */
int g_nPreQuality[3][16];                           /* Ԥֱʣ1Ϊqcif2Ϊcif7Ϊd1 */
unsigned long g_ulPreAddr[3][17];                   /* Ԥdmaַ16ͨڴ */

int g_nYuvType[3][16];                              /* yuvͣ0ʾ420(ʱʽֻyuvֿ)1ʾ422 */
int g_nPackType[3][16];                             /* ʽ02ʾyuvֿţ1ʾUYVY3ʾYUYV*/

int g_nPreBlockNum[16];                             /* Ԥֿ */
int g_nPreHalfScale[16];                            /* 1/2ʹ */
int g_nPreSrcWidth[16];                             /* Դ */
int g_nPreSrcHeight[16];                            /* Դ߶ */
int g_nPreCutPixel[16];                             /* ʹ(Ҽеĳߴ) */
int g_nPreStandard[16];                             /* ʽ0ʾPAL1ʾNTSC */
cut_info_t g_cutInfo[16];                           /* Ϣ */

/*
**  ý⽻ǿĿ
**  3dwordֱʾͨţܣ
**  ڹܣ0ʾ⽻1ʾǿ2ʾ
**  3ʾд⽻ĵһĴ4ʾд⽻ĵڶĴ
**  5ʾдPV֡ʺyuvʽĴ
**  6ʾдNV֡ʺyuvʽĴ
**  7ʾдMUX֡ʺyuvʽĴ
**  8ʾ1/2
**  9ʾýڴ(CκE)
**  10ʾʽ0ʾPAL1ʾNTSC
**  11ʾüйܣbit16ʾأ16λȡֵ0-4ֱʾ߼0-16
**  bit31Ϊ1ʾйܣЧֵbit26
**  bit30Ϊ1ʾùؼ֡1Чֵbit28
**  12Ϊ1ʾùؼ֡2
**  13Ϊ1ʾùؼ֡ʹ
**
**  0x97
*/
void cmd_pre_set_enh(unsigned char *pucData, int nLength)
{
    int i;
    int num;
    int cutval;
    unsigned long *pulData;
    unsigned long ulChannel;
    unsigned long ulMode;
    unsigned long ulSwitch;
    unsigned long ulPack;
    unsigned long ulYuv;
    unsigned long ulMuxFormat;
    unsigned long ulAddr;
    unsigned long ulVal;
    cut_info_t cutInfo;

    FUNC_TRACK(0x97);

    pulData = (unsigned long *)pucData;
    ulChannel = byte_swap4(pulData[0]);             /* ͨ */
    ulMode = byte_swap4(pulData[1]);                /* ѡĹ */
    ulSwitch = byte_swap4(pulData[2]);              /*  */

    if (ulChannel > 15)
    {
        FUNC_COUNTER(0x97, 0x00);
        return;
    }

    ulChannel = chMap[ulChannel];                   /* ͨӳ */

    write_reg(0x61240030, (0x1 << ulChannel));      /* дһ֡źţֻԽЧ? */

    if (0 == ulMode)                                /* ⽻ */
    {
        PRE_ENH(ulChannel, 0, ulSwitch);            /* Ϣ¼־ */
        hw_pre_set_deinterlace(ulChannel, ulSwitch);
    }
    else if (1 == ulMode)                           /* ǿ */
    {
        PRE_ENH(ulChannel, 1, ulSwitch);            /* Ϣ¼־ */

        if (0 == (ulSwitch & 0x1))                  /* ulSwitchbit0ʾأbit16ʾģʽ */
        {
            hw_pre_set_enhance(ulChannel, 0);
        }
        else
        {
            /* ǿģʽĿǰѾѱԵǿȥ */
            //write_reg(g_ulList_s + (ulChannel << 10) + 0x2FC, ((ulSwitch >> 16) & 0x1));
            //update_list(ulChannel);

            hw_pre_set_enhance(ulChannel, 1);
        }
    }
    else if (2 == ulMode)                           /*  */
    {
        PRE_ENH(ulChannel, 2, ulSwitch);            /* Ϣ¼־ */
        hw_pre_set_denoise(ulChannel, ulSwitch);
    }
    else if (3 == ulMode)
    {
        hw_pre_set_deinterlace_ex(ulChannel, 0, ulSwitch);
        update_list(ulChannel);
    }
    else if (4 == ulMode)
    {
        hw_pre_set_deinterlace_ex(ulChannel, 1, ulSwitch);
        update_list(ulChannel);
    }
    else if (5 == ulMode)                           /* PV yuvʽ*/
    {
        ulYuv = (ulSwitch >> 3) & 0x1;
        ulPack = (ulSwitch >> 1) & 0x3;

        for (i = 0; i < 16; i++)                    /* Ԥ֡ʺݸʽ */
        {
    	    write_reg(g_ulList_s + (i << 10) + 0x54, ulSwitch);
    	    update_list(i);

	        g_nYuvType[0][i] = ulYuv;
	        g_nPackType[0][i] = ulPack;
    	}
    }
    else if (6 == ulMode)                           /* NV yuvʽ*/
    {
        ulYuv = (ulSwitch >> 3) & 0x1;
        ulPack = (ulSwitch >> 1) & 0x3;

        for (i = 0; i < 16; i++)                    /* Ԥ֡ʺݸʽ */
        {
    	    write_reg(g_ulList_s + (i << 10) + 0xCC, ulSwitch);
    	    update_list(i);

            g_nYuvType[1][i] = ulYuv;
            g_nPackType[1][i] = ulPack;
    	}
    }
    else if (7 == ulMode)                           /* MUX yuvʽ*/
    {
        ulYuv = (ulSwitch >> 3) & 0x1;
        ulPack = (ulSwitch >> 1) & 0x3;
        ulMuxFormat = (ulYuv << 4) | (ulPack << 2) | ((ulSwitch << 5) & 0x3E00);

        for (i = 0; i < 16; i++)                    /* Ԥ֡ʺݸʽ */
        {
    	    write_reg(g_ulList_s + (i << 10) + 0x148, ulMuxFormat);
    	    update_list(i);

    	    g_nYuvType[2][i] = ulYuv;
    	    g_nPackType[2][i] = ulPack;
    	}
    }
    else if (8 == ulMode)                           /* 1/2 */
    {
        /* ֻ1/2״̬ıʱ账 */
        if (0 == ulSwitch && g_nPreHalfScale[ulChannel])
        {
            g_nPreSrcWidth[ulChannel] <<= 1;        /* ȼӱ */

            num = g_nPreSrcWidth[ulChannel] / 360;  /* ¼ */
            if (num * 360 != g_nPreSrcWidth[ulChannel])
            {
                num++;
            }
            g_nPreBlockNum[ulChannel] = num;

            hw_pre_set_blkdiv(ulChannel, g_nPreSrcWidth[ulChannel], g_nPreBlockNum[ulChannel]);

            hw_pre_set_halfscale(ulChannel, 0);
            g_nPreHalfScale[ulChannel] = 0;
        }
        else if (0 == g_nPreHalfScale[ulChannel])
        {
            g_nPreSrcWidth[ulChannel] >>= 1;        /* ȼ */

            num = g_nPreSrcWidth[ulChannel] / 360;  /* ¼ */
            if (num * 360 != g_nPreSrcWidth[ulChannel])
            {
                num++;
            }
            g_nPreBlockNum[ulChannel] = num;

            hw_pre_set_blkdiv(ulChannel, g_nPreSrcWidth[ulChannel], g_nPreBlockNum[ulChannel]);

            hw_pre_set_halfscale(ulChannel, 1);
            g_nPreHalfScale[ulChannel] = 1;
        }

        update_list(ulChannel);                     /* ÷ֿʱҪˢlist */
    }
    else if (9 == ulMode)                           /* ýڴ */
    {
        if (0 == ulSwitch)
        {
            hw_set_den_mem(0, 1);                   /* Cڴ棬Ҫˢlist */
        }
        else
        {
            hw_set_den_mem(1, 1);                   /* Eڴ棬Ҫˢlist */
        }
    }
    else if (10 == ulMode)                          /* ʽ */
    {
        /* ֻ״̬ıʱŴʽı䣬ֻӰ߶ */
        if ((0 == ulSwitch) && g_nPreStandard[ulChannel])
        {
            /* NTSC->PAL */
            g_nPreSrcHeight[ulChannel] += HEIGHT_CHG;
            hw_pre_set_standard(ulChannel, 0);
#ifdef IIC_THREAD
            tw2864_set_standard(ulChannel, 0);
#endif
            g_nPreStandard[ulChannel] = 0;
        }
        else if (0 == g_nPreStandard[ulChannel])
        {
            /* PAL->NTSC */
            g_nPreSrcHeight[ulChannel] -= HEIGHT_CHG;
            hw_pre_set_standard(ulChannel, 1);
#ifdef IIC_THREAD
            tw2864_set_standard(ulChannel, 1);
#endif
            g_nPreStandard[ulChannel] = 1;
        }
    }
    else if (11 == ulMode)                          /* ü */
    {
        /* 1/2Чֵ */
        if (g_nPreHalfScale[ulChannel])
        {
            cutval = CUT_VAL >> 1;
        }
        else
        {
            cutval = CUT_VAL;
        }

        /* ֻ״̬ıʱŴؼУӰ */
        if ((ulSwitch & 0x10000) && (0 == g_nPreCutPixel[ulChannel]))
        {
            g_nPreSrcWidth[ulChannel] -= cutval;
            hw_pre_set_blkdiv(ulChannel, g_nPreSrcWidth[ulChannel], g_nPreBlockNum[ulChannel]);
            hw_pre_set_cut(ulChannel, 1, (ulSwitch & 0xF));
            g_nPreCutPixel[ulChannel] = 1;
        }
        else if (g_nPreCutPixel[ulChannel])
        {
            g_nPreSrcWidth[ulChannel] += cutval;
            hw_pre_set_blkdiv(ulChannel, g_nPreSrcWidth[ulChannel], g_nPreBlockNum[ulChannel]);
            hw_pre_set_cut(ulChannel, 0, (ulSwitch & 0xF));
            g_nPreCutPixel[ulChannel] = 0;
        }

        update_list(ulChannel);                     /* ÷ֿʱҪˢlist */
    }
    else if (ulMode & 0x80000000)                   /*  */
    {
        cutInfo.xPos = (ulMode >> 16) & 0x7FF;
        cutInfo.yPos = ulMode & 0x7FF;
        cutInfo.width = (ulSwitch >> 16) & 0x7FF;
        cutInfo.height = ulSwitch & 0x7FF;

        /* Խ */
        if ((cutInfo.width + cutInfo.xPos) > g_nPreSrcWidth[ulChannel]
            || (cutInfo.height + cutInfo.yPos) > g_nPreSrcHeight[ulChannel])
        {
            PRINT(ERR, "cut over\n");
            return;
        }

        /* 2 */
        if (cutInfo.xPos & 0x1 || cutInfo.yPos & 0x1 || cutInfo.width & 0x1 || cutInfo.height & 0x1
            || cutInfo.width < 1 || cutInfo.height < 1)
        {
            PRINT(ERR, "cut over\n");
            return;
        }

        g_cutInfo[ulChannel].xPos = cutInfo.xPos;
        g_cutInfo[ulChannel].yPos = cutInfo.yPos;
        g_cutInfo[ulChannel].width = cutInfo.width;
        g_cutInfo[ulChannel].height = cutInfo.height;
    }
    else if (ulMode & 0x40000000)                   /* ùؼ֡1 */
    {
        /* [kfCntThr = frame_height * 6 / 8 * (frame_width - 2) * N_THR_MAIN / 128] */
        num = (ulMode >> 8) & 0xFF;
        num = g_nPreSrcHeight[ulChannel] * (g_nPreSrcWidth[ulChannel] - 2) * num * 3 / 512;

        write_reg(g_ulList_s + (ulChannel << 10) + 0x334, ulMode & ~0x40000000);
        write_reg(g_ulList_s + (ulChannel << 10) + 0x338, ulSwitch);
        write_reg(g_ulList_s + (ulChannel << 10) + 0x33C, num);

        update_list(ulChannel);
    }
    else if (12 == ulMode)                          /* ùؼ֡2 */
    {
        write_reg(g_ulList_s + (ulChannel << 10) + 0x340, ulSwitch);
        update_list(ulChannel);
    }
    else if (13 == ulMode)                          /* ùؼ֡ʹ */
    {
        i = (g_nPreSrcWidth[ulChannel] >> 1) & 0x7FF;

        write_reg(0x61230060 + (ulChannel << 12), 0);   /* ֡ۻ */
        write_reg(0x61230064 + (ulChannel << 12), (i << 16) | i);

        write_reg(0x61240038, (0x1 << ulChannel));  /* first flag */

        if (ulChannel < 8)
        {
            ulAddr = 0x612600D0;
            i = ulChannel * 4;
        }
        else
        {
            ulAddr = 0x612600D4;
            i = (ulChannel - 8) * 4;
        }

        ulVal = read_reg(ulAddr);
        ulVal &= ~(0x7 << i);
        ulVal |= ((ulSwitch & 0x7) << i);
        write_reg(ulAddr, ulVal);
    }
    else
    {
        FUNC_COUNTER(0x97, 0x01);
    }

    return;
}


/*
**  ԤĿǷϷ
*/
inline int check_size(unsigned long ulWidth, unsigned long ulHeight)
{
    if (0 == ulWidth || 0 == ulHeight)              /* Ϊ0 */
    {
        return -1;
    }

    if (ulWidth > 2047 || ulHeight > 2047)          /* ܳ */
    {
        return -1;
    }

    /* Ӧñ2߶Ӧñ2 */
    if (((ulWidth & 0x1) != 0) || ((ulHeight & 0x1) != 0))
    {
        return -1;
    }

    return 0;
}


/*
**  ԤdmaַȲܳ
**  0x96
*/
void cmd_pre_set_dma_addr(unsigned char *pucData, int nLength)
{
    msg_pdma_t *pMsg;
    unsigned long ulChannel;
    unsigned long ulWidth;
    unsigned long ulHeight;
    unsigned long ulPitch;
    unsigned long str;
    unsigned long ch;
    unsigned long ulBase;
    int i, j;

    FUNC_TRACK(0x96);

    pMsg = (msg_pdma_t *)pucData;

    ulChannel = byte_swap4(pMsg->channel);
    if (ulChannel > 50)                             /* ֤ͨ */
    {
        FUNC_COUNTER(0x96, 0x00);
        PRINT(ERR, "cmd_pre_set_dma_addr ch 0x%lx\n", ulChannel);
        return;
    }

    str = ulChannel / 17;
    ch = ulChannel % 17;
    ch = chMap[ch];                                 /* ͨӳ */

    g_nPreQuality[str][ch] = byte_swap4(pMsg->quality);     /* ֱ */
    g_ulPreAddr[str][ch] = byte_swap4(pMsg->addr);  /* pcַ */
    ulWidth = byte_swap4(pMsg->width);              /*  */
    ulHeight = byte_swap4(pMsg->height);            /* ߶ */
    ulPitch = byte_swap4(pMsg->pitch);              /* ࣬Ŀǰֻõַ */

    /* 0ͨdmaַƳͨdmaַȲӳ */
    if (0x56 == ulPitch)
    {
        ulBase = g_ulPreAddr[0][0];
        for (i = 0; i < 3; i++)
        {
            for (j = 0; j < 17; j++)
            {
                if (0 == g_ulPreAddr[i][j])
                {
                    g_ulPreAddr[i][j] = ulBase;
                }

                ulBase += 0xCA800;                  /* 51ͨdmaַd1 */
            }
        }

        PRINT(INFO, "pre_dma_addr %#lx\n", g_ulPreAddr[0][0]);
        return;
    }

    if (check_size(ulWidth, ulHeight) != 0)         /*  */
    {
        FUNC_COUNTER(0x96, 0x01);
        PRINT(ERR, "cmd_pre_set_dma_addr size 0x%lx 0x%lx\n", ulWidth, ulHeight);
        return;
    }

    /* Ԥţ0ʾ4201ʾ422 */
    set_scale(ch, ulWidth, ulHeight, str, g_nYuvType[str][ch], 0);

    update_list(ch);

    return;
}


/*
**  Ԥ
**  0x95
*/
void cmd_pre_set_switch(unsigned char *pucData, int nLength)
{
    msg_switch_t *pMsg;
    unsigned long ulChannel;
    unsigned long ulSwitch;
    unsigned long ulVal;
    unsigned long ulBase;
    unsigned long bit;
    unsigned long str;
    unsigned long ch;

    FUNC_TRACK(0x95);

    pMsg = (msg_switch_t *)pucData;
    ulChannel = byte_swap4(pMsg->channel);
    ulSwitch = byte_swap4(pMsg->enable);

    if (ulChannel > 50)                             /* ֤ͨ */
    {
        FUNC_COUNTER(0x95, 0x00);                   /* ¼쳣Ϣ */
        PRINT(ERR, "set_pre_switch ch 0x%lx\n", ulChannel);
        return;
    }

    str = ulChannel / 17;
    ch = ulChannel % 17;
    ch = chMap[ch];                                 /* ͨӳ */

    if (0 == str)                                   /* PV */
    {
        bit = ch;
        ulBase = 0x61260020;
    }
    else if (1 == str)                              /* NV */
    {
        bit = ch;
        ulBase = 0x61260040;
    }
    else                                            /* MUX */
    {
        bit = ch + 16;
        ulBase = 0x61260060;
    }

    ulVal = read_reg(ulBase);

    if (0 == ulSwitch)                              /* رԤ */
    {
        g_nPreSwitch[str][ch] = 0;
        ulVal &= ~(0x1 << bit);
    }
    else                                            /*  */
    {
        g_nPreSwitch[str][ch] = 1;

        if (2 == str)                               /* ʹMUXԤ */
        {
            ulVal |= (0x1 << bit) | 0xFFFF;
        }
        else
        {
            ulVal |= (0x1 << bit);
        }
    }

    write_reg(ulBase, ulVal);

    return;
}


/*
**  Ԥ
**  chΪͨ
**  strΪ0ʾPVΪ1ʾNVΪ2ʾMUXԤ
**  ֵΪ0˵ӦԤûdmaַΪգԤʼַΪ
**  ֵΪ1˵߲Ϸ
**  ֵΪ2˵ͳһ֡
**
**  0x94
*/
static int preview_frame(int ch, int str)
{
    int ret;
    yuv_type_t *p0;
    pre_size_t *p1;
    dma_info_t dmaInfo;
    unsigned long *pul;
    unsigned long ulSize;
    unsigned long ulAddr;
    unsigned long ulWidth;
    unsigned long ulHeight;
    unsigned long ulLength;
    unsigned long ulSendChannel;

    FUNC_TRACK(0x94);

    if (0 == g_nPreSwitch[str][ch])                 /* Ԥû */
    {
        return 0;
    }

    if (0 == g_ulPreAddr[str][ch])                  /* Ѿ򿪣ûdmaַ쳣 */
    {
        FUNC_COUNTER(0x94, 0x00);
        PRINT(ERR, "preview_frame pc dma addr null\n");
        return 0;
    }

    /* ȡʼַͿ */
    ulSize = read_reg(0x61230000 + (ch << 12) + (str << 3));
    ulAddr = read_reg(0x61230004 + (ch << 12) + (str << 3));
    ulHeight = ulSize & 0xfff;
    ulWidth = (ulSize >> 16) & 0xfff;

    if (0 == ulAddr)                                /* ַ */
    {
        return 0;
    }

    if (check_size(ulWidth, ulHeight) != 0)         /* ߣʱһжϸΪ0ҲҪԴ? */
    {
        if (id_pre_doing_now && 0 == str)
        {
            kf_frame(ch);                           /* һжҲҪؼ֡ */
        }

        //PRINT(WARN, "pre ch%d 0x%lx 0x%lx\n", ch, ulWidth, ulHeight);
        return 1;
    }

    if (id_pre_doing_now)                           /* жǷԤ */
    {
        if (0 == str)
        {
            process_md_diff(ch, 0x08);              /* ͶвݣֻڴԤʱ */

            kf_frame(ch);                           /* ؼ֡ */
        }

        PRINT(INFO, "pre %d %d\n", ch, str);
    }

    /* ݳ */
    if (0 == g_nYuvType[str][ch])                   /* 420, w * h * 1.5 */
    {
        ulLength = (ulWidth * ulHeight * 3) / 2;
    }
    else                                            /* 422, w * h * 2 */
    {
        ulLength = ulWidth * ulHeight * 2;
    }

    ulSendChannel = chMap[ch];                      /* ͨӳ(һһԿͬһ) */
    ulSendChannel += str * 17;

    pul = (unsigned long *)(dmaInfo.msgBuffer);
    pul[0] = byte_swap4(ulSendChannel);             /* ͨ */
    pul[1] = byte_swap4(ulLength);                  /*  */

	p0 = (yuv_type_t *)(pul + 2);                   /* pul[2], 3ֽͣôСת */
	p0->yuv = g_nYuvType[str][ch];                  /* yuv(420 422) */
	p0->pack = g_nPackType[str][ch];                /* ʽ */
    p0->qua = g_nPreQuality[str][ch];               /* ֱʣֱתcharͣ˲ôСת */

	p1 = (pre_size_t *)(pul + 3);                   /* pul[3] */
	p1->width = byte_swap2(ulWidth);                /* ʵ */
	p1->height = byte_swap2(ulHeight);              /* ʵ߶ */

    dmaInfo.pciAddr = g_ulPreAddr[str][ch];
    dmaInfo.ahbAddr = ulAddr;
    dmaInfo.dmaLength = ulLength;
    dmaInfo.module = 0;                             /* Ҫص */
    dmaInfo.command = 0xB1;
    dmaInfo.msgLength = 16;

    ret = pci_dma_write(&dmaInfo, 0, 0);            /* ΪжԲҪж */
    if (ret != 0)
    {
        FUNC_COUNTER(0x94, 0x01);
        PRINT(ERR, "pre write fail\n");
    }

    return 2;
}


/*
**  Ԥж
**  0x44
**
**  ʹʱͨͬʱ£ֻᷢһж
**  ԴʱͨжжϣҪظԤ
**
**  20100805ԤƸĶ
**  ʹʱͨͬʱֻᷢһж
**  ԴʱͨͬʱҲֻһжϣһͨʱŷ
**
**  0x93
*/
static void preview_handler(int irq, void *dummy, struct pt_regs *regs)
{
    int ch;
    int ret;
    int nValidIrqFlag;

    FUNC_TRACK(0x93);

    if (g_nGlobalQueueFull)                         /* ʱԣdma֮󣬲Ԥ */
    {
        return;
    }

    nValidIrqFlag = 0;                              /* ־ûЧԤ */

    if (id_pre_doing_now)
    {
        id_frame_jiffies = jiffies;                 /* ʾԤԴԻڽ */
    }

    for (ch = 0; ch < 16; ch++)                     /* ѯ16ͨ */
    {
        ret = preview_frame(ch, 2);                 /* MUXԤ */
        if (ret)
        {
            nValidIrqFlag = 1;
        }

        ret = preview_frame(ch, 1);                 /* Ԥ */
        if (ret)
        {
            nValidIrqFlag = 1;
        }

        ret = preview_frame(ch, 0);                 /* Ԥ */
        if (ret)
        {
            nValidIrqFlag = 1;
        }
    }

    /*
    **  Ԥģ˵ֻҪһЧԤжϣ
    **  ˵ͨϣͨԴʹ
    */
    if (1 == id_pre_yuv_ready && 1 == nValidIrqFlag)
    {
        id_pre_yuv_ready = 0;
    }

    return;
}


/*
**  벢Ԥڴ
**  0x92
*/
static int pre_memory_init(void)
{
    int i;
    unsigned long ulViuSize;
    unsigned long ulDeiSize;
    unsigned long ulBase;

    FUNC_TRACK(0x92);

    /* bankڴ棬Ĭ4Ƭ */
    ulBase = get_memory(PRE_BANK_SIZE * PRE_BANK_NUM);
    if (0 == ulBase)
    {
        FUNC_COUNTER(0x92, 0x00);
        return 0;
    }
    for (i = 0; i < PRE_BANK_NUM; i++)
    {
        write_reg(0x61240084 + i * 4, ulBase + i * PRE_BANK_SIZE);
    }
    write_reg(0x61240080, PRE_BANK_NUM_SEL);

#ifdef PRE_NV
    ulBase = get_memory(PRE_BANK_SIZE * PRE_BANK_NUM);
    if (0 == ulBase)
    {
        FUNC_COUNTER(0x92, 0x01);
        return 0;
    }
    for (i = 0; i < PRE_BANK_NUM; i++)
    {
        write_reg(0x612400A4 + i * 4, ulBase + i * PRE_BANK_SIZE);
    }
    write_reg(0x612400A0, PRE_BANK_NUM_SEL);
#endif

#ifdef PRE_MUX
    ulBase = get_memory(PRE_BANK_SIZE * PRE_BANK_NUM);
    if (0 == ulBase)
    {
        FUNC_COUNTER(0x92, 0x02);
        return 0;
    }
    for (i = 0; i < PRE_BANK_NUM; i++)
    {
        write_reg(0x612400C4 + i * 4, ulBase + i * PRE_BANK_SIZE);
    }
    write_reg(0x612400C0, PRE_BANK_NUM_SEL);
#endif

    /* viuڴ */
    ulViuSize = WIDHT_FOR_MEM * HEIGHT_FOR_MEM * PRE_VIU_MULTI;
    i = ulViuSize & 0x3FF;
    if (i != 0)
    {
        ulViuSize += (0x400 - i);                   /* 1K */
    }
    for (i = 0; i < PRE_CH_NUM; i++)
    {
        ulBase = get_memory(ulViuSize);
        if (0 == ulBase)
        {
            FUNC_COUNTER(0x92, 0x03);
            break;
        }

        write_reg(0x61002040 + (chMap[i] << 2), ulBase);
    }

    /* ⽻ο֡ڴ */
    ulDeiSize = (WIDHT_FOR_MEM * HEIGHT_FOR_MEM * 3) >> 4;
    i = ulDeiSize & 0x3FF;
    if (i != 0)
    {
        ulDeiSize += (0x400 - i);                   /* 1K */
    }
    for (i = 0; i < PRE_CH_NUM; i++)                /* ⽻ο֡0 */
    {
        ulBase = get_memory(ulDeiSize);
        if (0 == ulBase)
        {
            FUNC_COUNTER(0x92, 0x04);
            break;
        }

        write_reg(g_ulList_s + (chMap[i] << 10) + 0x08, ulBase);
    }

    for (i = 0; i < PRE_CH_NUM; i++)                /* ⽻ο֡1 */
    {
        ulBase = get_memory(ulDeiSize);
        if (0 == ulBase)
        {
            FUNC_COUNTER(0x92, 0x05);
            break;
        }

        write_reg(g_ulList_s + (chMap[i] << 10) + 0x0C, ulBase);
    }

    /* ο֡ڴ */
    g_ulDenSize = (WIDHT_FOR_MEM * HEIGHT_FOR_MEM * 3) >> 1;
    i = g_ulDenSize & 0x3FF;
    if (i != 0)
    {
        g_ulDenSize += (0x400 - i);                 /* 1K */
    }

    /* ͨýڴܺ */
    g_ulDenTotalSize = PRE_CH_NUM * g_ulDenSize * 2;

    /* ýڴ棬CΣҪˢlist */
    i = hw_set_den_mem(0, 0);

    return i;
}


/*
**  Ԥģע
**  0x91
*/
void preview_exit(void)
{
    FUNC_TRACK(0x91);

    disable_irq(PREVIEW_IRQ);                       /* ͷԤж */
    free_irq(PREVIEW_IRQ, 0);

    return;
}


/*
**  Զtgģʽ
*/
static void tg_init(void)
{
    int clk;

    write_reg(0x61000004, 0);

#if defined CONFIG_CLOCK_27MHz
    clk = 27;
#elif defined CONFIG_CLOCK_54MHz
    clk = 54;
#elif defined CONFIG_CLOCK_81MHz
    clk = 81;
#elif defined CONFIG_CLOCK_88MHz
    clk = 88;
#elif defined CONFIG_CLOCK_108MHz
    clk = 108;
#elif defined CONFIG_CLOCK_133MHz
    clk = 133;
#elif defined CONFIG_CLOCK_135MHz
    clk = 133;                                      /* 135M133M? */
#elif defined CONFIG_CLOCK_147MHz
    clk = 147;
#elif defined CONFIG_CLOCK_216MHz
    clk = 216;
#elif defined CONFIG_CLOCK_266MHz
    clk = 266;
#else
    PRINT(INFO, "TG TG\n");
    return;
#endif

    PRINT(INFO, "TG %dM\n", clk);
    write_reg(0x61000008, clk * 22000);

    return;
}


/*
**  Դߴ
*/
static void source_size_init(void)
{
    int i;
    int num;

    for (i = 0; i < 16; i++)
    {
        g_nPreSrcWidth[i] = SRC_D1_WIDTH;
        g_nPreSrcHeight[i] = SRC_D1_HEIGHT;
        g_nPreStandard[i] = DEFAULT_STANDARD;

#ifdef TW2864_54M_4CIF                              /* 54M4CIFģʽ£߼ */
        g_nPreSrcWidth[i] /= 2;
        g_nPreSrcHeight[i] /= 2;
#endif

#ifdef DEFAULT_CUTPIXEL                             /* Դȼ */
        g_nPreSrcWidth[i] -= CUT_VAL;               /* 720->704, 360->352 */
        g_nPreCutPixel[i] = 1;
#else
        g_nPreCutPixel[i] = 0;
#endif

#ifdef DEFAULT_HALFSCALE                            /* 1/2ţȼ */
        g_nPreSrcWidth[i] /= 2;
        g_nPreHalfScale[i] = 1;
#else
        g_nPreHalfScale[i] = 0;
#endif

        g_cutInfo[i].xPos = 0;                      /* ĬԴС */
        g_cutInfo[i].yPos = 0;
        g_cutInfo[i].width = g_nPreSrcWidth[i];
        g_cutInfo[i].height = g_nPreSrcHeight[i];

        /*
        **  ʼʱ360Ϊȷ
        **  Ҫ򿪱룬ҪǱ
        **  ÿĿȲܳ450
        */
        num = g_nPreSrcWidth[i] / 360;
        if (num * 360 != g_nPreSrcWidth[i])
        {
            num++;
        }
        g_nPreBlockNum[i] = num;
    }

    return;
}


/*
**  ʼ
*/
static void variant_init(void)
{
    int i;
    unsigned long val;

    /* ʽԴԼdcmģʽʽĬΪPAL */
    write_reg(0x61002000, VPS_VIU);

	for (i = 0; i < 8; i++)
	{
        /* ͨidĿǰֻʹ0ͨituûʹܼ */
	    write_reg(0x61002004 + (i * 4), idTab[i]);
	}

    memset(g_nPreSwitch, 0, sizeof(g_nPreSwitch));  /* Ԥ0 */
    memset(g_nPreQuality, 0, sizeof(g_nPreQuality));/* ֱ0 */
    memset(g_ulPreAddr, 0, sizeof(g_ulPreAddr));    /* dmaַ0 */
    memset(g_nPackType, 0, sizeof(g_nPackType));    /* ʽ0yuvֿ */

    for (i = 0; i < 16; i++)
    {
        /*
        **  ѽ⽻->ǿ->->ram0(ram1)ȻٿƸģڲ
        **  ѡram0
        */
        write_reg(g_ulList_s + (i << 10) + 0x50, 0xFDB9);

        /* Ԥ֡ʺݸʽ25f/s422ֿ */
	    g_nYuvType[0][i] = 1;
        g_nYuvType[1][i] = 1;
        g_nYuvType[2][i] = 1;

        val = 0x190 | (g_nYuvType[0][i] << 3) | (g_nPackType[0][i] << 1);     /* PV */
        write_reg(g_ulList_s + (i << 10) + 0x54, val);

        val = 0x190 | (g_nYuvType[1][i] << 3) | (g_nPackType[1][i] << 1);     /* NV */
        write_reg(g_ulList_s + (i << 10) + 0xCC, val);

        val = 0x3200 | (g_nYuvType[2][i] << 4) | (g_nPackType[2][i] << 2);    /* MUX */
        write_reg(g_ulList_s + (i << 10) + 0x148, val);

        /* ʽ */
        hw_pre_set_standard(i, g_nPreStandard[i]);

        /* ü */
        hw_pre_set_cut(i, g_nPreCutPixel[i], 0);

        /* 1/2 */
        hw_pre_set_halfscale(i, g_nPreHalfScale[i]);

        /* ԤֿؼĴ(ֻڿԤ֮) */
        hw_pre_set_blkdiv(i, g_nPreSrcWidth[i], g_nPreBlockNum[i]);
	}

    return;
}


/*
**  Ԥģʼ
**  0x90
*/
int preview_init(void)
{
    int ret;

    FUNC_TRACK(0x90);

    source_size_init();                             /* Դߴ */

    ret = pre_memory_init();                        /* Ԥڴ */
    if (0 == ret)
    {
        FUNC_COUNTER(0x90, 0x00);
        PRINT(ERR, "preview_init mem fail\n");
        return -1;
    }
    else
    {
        PRINT(INFO, "pre mem %d\n", ret);
    }

    kf_init();                                      /* ؼ֡ģ */

    ret = request_irq(PREVIEW_IRQ, preview_handler, SA_INTERRUPT, "preview_handler", 0);
    if(ret != 0)
    {
        FUNC_COUNTER(0x90, 0x01);
        PRINT(ERR, "preview_init request_irq fail\n");
        return -1;
    }
    enable_irq(PREVIEW_IRQ);

    tg_init();                                      /* TGʼ */

    variant_init();                                 /* ʼ */

    write_reg(0x61260020, 0x10000);                 /* Ԥж */

    /* Ԥ̫ʱdmaӶֹͣԤı־λ */
	PRINT(INFO, "preview_init 0x%lx\n", (unsigned long)&g_nGlobalQueueFull);

    return 0;
}
