/*
**  jpegģĴ֣Ҫjpegģ
*/

#include "../vs28xx.h"
#include "jpeg_reg.h"
#include "enc_reg.h"


#include "jpeg_quality.h"                           /* s_ulSoftQuantTableĶ */


/*
**  øͨjpegַַӦcΣʼַӦ4k룬ַ1ҲӦ4k
*/
void hw_jpg_set_addr(unsigned long ulChannel, unsigned long ulStartAddr, unsigned long ulEndAddr)
{
    unsigned long ulReg;
    unsigned long ulData;

    if (ulChannel > 16)                             /* jpegϷͨΪ0-16 */
    {
        return;
    }

    if ((ulStartAddr & 0xF0000000) != 0xC0000000)   /* ַc */
    {
        return;
    }
    ulStartAddr &= 0xFFFFFFF;

    if ((ulEndAddr & 0xF0000000) != 0xC0000000)
    {
        return;
    }
    ulEndAddr &= 0xFFFFFFF;

    if ((ulStartAddr & 0xFFF) != 0)                 /* ַҪ4k */
    {
        return;
    }

    if (((ulEndAddr + 1) & 0xFFF) != 0)
    {
        return;
    }

    ulData = ((ulEndAddr + 1) >> 12) - 1;           /* ַ4KΪλ */
    ulData |= (ulStartAddr << 4);                   /* ʼַڸ16λ4KΪλֱ4λ */

    ulReg = JPEG_ENC_ADDR_BASE + (ulChannel * 4);
    write_reg(ulReg, ulData);

    return;
}


/*
**  jpegƣulChannelHexλʾͨĳͨΪ1ʾͨʹ
**  ulDiffΪ1ʾͨʹòͬʾʹͬ
**  Ŀǰδõ˺
*/
void hw_jpg_soft_quant(unsigned long ulChannelHex, unsigned long ulDiff)
{
    unsigned long ulData;

    ulChannelHex &= 0x1FFFF;                        /* jpegϷͨΪ0-16 */

    ulData = ulChannelHex << 15;
    if (1 == ulDiff)
    {
        ulData |= 0x1;
    }

    write_reg(JPEG_QT_CTL, ulData);

    return;
}


/*
**  jpegַַeΣ4k
**  Ŀǰδõ˺
*/
void hw_jpg_quant_table(unsigned long ulAddr)
{
    if ((ulAddr & 0xFFF) != 0)                      /* ַҪ4k */
    {
        return;
    }

    if ((ulAddr & 0xF0000000) != 0xE0000000)        /* e */
    {
        return;
    }

    ulAddr &= 0xFFFFFFF;                            /* ȥEͷ */
    ulAddr >>= 12;                                  /* 4KΪλ */

    write_reg(JPEG_QT_ADDR, ulAddr);

    return;
}


/*
**  ʼ
**  0xE000E000ʼ6ռ24Kռ
*/
void hw_jpg_quant_init(void)
{
    int i;
    char *dst;
    char *src;

    /*
    **  ĿǰͨʹͳһӣʹӲʱͨжӦļĴ
    **  ʹʱͨʹһ̬ıַ
    **  ڻַҪ4K룬Ӧÿ4K256ֽ
    */
    dst = (char *)JSQ_BADDR;
    src = (char *)s_ulSoftQuantTable;
    for (i = 0; i < 6; i++)
    {
        memcpy(dst, src, 256);
        dst += 0x1000;
        src += 256;
    }

    return;
}


/*
**  øͨjpeg
**  Ϊ0-13ʱʾӲӣ14-19ʾʹ0-5
*/
void hw_jpg_set_quality(unsigned long ulChannel, unsigned long ulQuality)
{
    int nBit;
    int nBank;
    unsigned long ulReg;
    unsigned long ulData;

    if (ulQuality > 13)
    {
#if 0
        ulData = JSQ_BADDR_4K + ulQuality - 14;     /* 4KΪλ14-19Ӧ0-5 */
        write_reg(JPEG_QT_ADDR, ulData);            /* ַ */
        write_reg(JPEG_QT_CTL, 0xFFFF8000);         /* ͨʹͬ */
#endif
        write_reg(JPEG_QT_ADDR, ulQuality);         /* ַJSQ_BADDR_4KֵΪ14Чһ */
        write_reg(JPEG_QT_CTL, 0xFFFF8000);         /* ͨʹͬ */
    }
    else
    {
        /*
        **  0x63000044Ϊͨ0-7ͨӣ0x63000048Ϊ8-15ͨӣ
        **  0x6300004CΪ16ͨӣÿͨռ4λ
        */
        nBit = (ulChannel & 0x7) * 4;
        nBank = ulChannel / 8;

        ulReg = JPEG_QUALITY0 + (nBank * 4);        /* ע⣬ĳ8ϣΪһ */

        ulData = read_reg(ulReg);
        ulData &= (~(0xF << nBit));                 /* ȰͨӦ0 */
        ulData |= (ulQuality << nBit);
        write_reg(JPEG_QT_CTL, 0);                  /* ʹӲ */
        write_reg(ulReg, ulData);
    }

    return;
}


/*
**  jpegһ֡ʱ
*/
void hw_jpg_set_clock(unsigned long ulClock)
{
    write_reg(JPEG_ENC_CLK, ulClock);

    return;
}


/*
**  jpegжϻ
**  ulMaskΪ1ʾjpegжϣulNumЧ
**  ulMaskΪ0ʾʹjpegжϣÿulNumжϷһ(ulNumֵΪ01ʾһж)
*/
void hw_jpg_set_mask(unsigned long ulMask, unsigned long ulNum)
{
    unsigned long ulData;

    ulData = read_reg(JPEG_ENC_CTL);

    if (1 == ulMask)
    {
        ulData |= 0x80000000;                       /* 31λ1ж */
    }
    else
    {
        /*
        **  Ĵ0ʾһ1ʾ
        **  16ʱĴֵΪ15
        */
        if (ulNum > 15)
        {
            ulNum = 15;
        }
        else if (ulNum > 0)
        {
            ulNum--;
        }

        ulData &= 0x7FFFFFFF;                       /* 31λ0 */
        ulData |= (ulNum << 24);                    /* λڼĴ24-27λ */
    }

    write_reg(JPEG_ENC_CTL, ulData);

    return;
}


/*
**  jepgץͼĿǰֵֻ֧ͨץͼ
*/
void hw_jpg_enable(unsigned long ch)
{
    unsigned long ulData;

    if (ch < 16)
    {
        write_reg(0x6123002C + (ch << 12), 0x10000);/* jpegԴ */
    }
    else if (ch == 16)
    {
        write_reg(0x61220018, 0x10000);             /* nvƴjpegԴ */
    }
    else
    {
        return;
    }

    ulData = read_reg(JPEG_ENC_CTL);
    ulData &= 0xFFFE0000;                   	    /* 0-16λ0 */
    ulData |= (0x1 << ch);

    write_reg(JPEG_ENC_CTL, ulData);

    return;
}


/*
**  jpegģλ
*/
void hw_jpg_reset(void)
{
    write_reg(JPEG_ENC_RST, 0x1);

    return;
}


/*
**  ȡǰжϵͨλʾͨ
**  ж֮Ͳﴦ
*/
unsigned long hw_jpg_get_channel(void)
{
    int i;
    unsigned long chs;
    unsigned long ulIrqState;

    ulIrqState = read_reg(JPEG_IRQ_STATE);          /* ȡж״̬һжλûУֱӷ */
    if (0 == (ulIrqState & 0xFFFF8000))
    {
    	return 0;
    }

    write_reg(JPEG_IRQ_STATE, 0xFFFFFFFF);          /* д1жλͣȫд1 */

    chs = 0;
    ulIrqState >>= 15;
    for (i = 0; i < 17; i++)
    {
        if ((ulIrqState >> i) & 0x1)
        {
            if (0x2000000 == (read_reg(JPEG_VP0_BASE + i * 8) & 0xE000000) )
            {
                chs |= (0x1 << i);
            }
            else
            {
                PRINT(ERR, "jpg sta0 %#lx\n", read_reg(JPEG_VP0_BASE + i * 8));
            }
        }
    }

    return chs;
}


/*
**  jpegжϲ֮󣬷
**  ulChannelΪͨţ3
**  ulStartAddrΪʼַjpegͷϢӦ4K
**  ulEndAddrΪjpegĽַ
**  jpegݵĳȣ-1ʾ
*/
unsigned long hw_jpg_analyze(unsigned long ulChannel, unsigned long ulStartAddr, unsigned long ulEndAddr)
{
    unsigned long ulRealEndAddr;
    unsigned long ulState;
    unsigned long ulLength;

    if ((ulStartAddr & 0xFFF) != 0)                 /* ʼַӦ4k */
    {
        PRINT(ERR, "jpeg_analyze addr err 0x%lx\n", ulStartAddr);
        return -1;
    }

    ulRealEndAddr = read_reg(ulStartAddr + 4);      /* ȡַ״̬ */
    ulState = read_reg(ulStartAddr);

    if ((ulState & 0xC0000000) != 0x40000000)       /* жͨǷЧ */
    {
        PRINT(ERR, "jpeg_analyze err2 0x%lx 0x%lx 0x%lx\n", ulChannel, ulState, ulRealEndAddr);
        return -1;
    }

    if (((ulState >> 23) & 0x3F) != ulChannel)      /* жͨǷһ */
    {
        PRINT(ERR, "jpeg_analyze err3 0x%lx 0x%lx 0x%lx\n", ulChannel, ulState, ulRealEndAddr);
        return -1;
    }

    if (ulRealEndAddr > ulEndAddr)                  /* жϽַûԽ */
    {
        PRINT(ERR, "jpeg_analyze overflow err 0x%lx 0x%lx\n", ulRealEndAddr, ulEndAddr);
        return -1;
    }

    /*
    **  㳤ȣҪȥ8ֽڵjpegͷϢ(ַʼַü1)
    **  ȻJPEG_MEM_SIZEޣʵjpeg󳤶Ϊ1M-8
    */
    ulLength = ulRealEndAddr - ulStartAddr - 8;
    if (ulLength < 1 || ulLength > JPEG_MEM_SIZE)
    {
        PRINT(ERR, "jpeg_analyze len err 0x%lx 0x%lx!\n", ulStartAddr, ulRealEndAddr);
        return -1;
    }

    return ulLength;
}
