/*
**  pciģĴͷļ
*/

#ifndef _VS28XX_PCI_REG_H_
#define _VS28XX_PCI_REG_H_


extern unsigned long g_ulPciInitBuffer[82];         /* pciʼϢ */


/***********************************************
**  䲿
***********************************************/

/* ͷ */
typedef struct mbx_head
{
    unsigned short  len;                            /* ݳȣͷ */
    unsigned char   rsv[30];                        /*  */
} mbx_head_t;

/* Ϣͷ */
typedef struct msg_head
{
    unsigned char   cmd;                            /*  */
    unsigned char   link;                           /* ǷϢA0-û AA- */
    unsigned short  len;                            /* ݳȣϢͷ */
    unsigned char   ack;                            /* ǷҪӦ0-Ҫ 1-Ҫ */
    unsigned char   rsv[3];                         /*  */
} msg_head_t;

/* pcckϢûַ */
#define PC2CK_MSG_BASE              0xC0000000

/* pcϢ󳤶 */
#define PC2CK_MAIL_MAX              (0xA000 - sizeof(mbx_head_t))

/* ckpcϢûַ */
#define CK2PC_MSG_BASE              0xC000A000

/* ckϢ󳤶 */
#define CK2PC_MAIL_MAX              (0x6000 - sizeof(mbx_head_t))



/***********************************************
**  pciжϣdma
***********************************************/

#define PCI_IRQ                     0x22            /* pciжϺ */

#define DOOR_MASK1                  0x20000         /* pcж룬ʹdoorbell1 */
#define DOOR_MASK3                  0x80000         /* pc˵ж룬ʹdoorbell3 */
#define WDMA_MASK                   0x1             /* dmaдж */

#define CPUDOORBELL0                0x100000        /* ж0ckж(ckϢpc) */

/* pci ahbĴַ */
#define PCI_AHB_BASE                ((volatile unsigned long *)0x90000000)

/* дahbĴ */
#define write_ahb(o, v)             (*(PCI_AHB_BASE + (unsigned long)((o) / 4)) = (unsigned long)(v))

/* ahbĴ */
#define read_ahb(o)                 (*(PCI_AHB_BASE + (unsigned long)((o) / 4)))

/* pci ahbĴ */
enum pci_ahb_registers
{
    WDMA_PCI_ADDR   =               0x00,           /* дdmaģpciַ(pcṩڴַ)Ŀַ */
    WDMA_AHB_ADDR   =               0x04,           /* дdmaģahbַ(ckڴַҪcڴ)Դַ */
    WDMA_CONTROL    =               0x08,           /* дdmaģ鳤ȼƼĴ */
    RDMA_PCI_ADDR   =               0x20,           /* dmaģpciַ(pcṩڴַ)Դַ */
    RDMA_AHB_ADDR   =               0x24,           /* dmaģahbַ(ckڴַҪcڴ)Ŀַ */
    RDMA_CONTROL    =               0x28,           /* dmaģ鳤ȼƼĴ */
    CPU_IMASK       =               0x40,           /* ж */
    CPU_ISTATUS     =               0x44,           /* ж״̬ */
    CPU_ICMD        =               0x48            /* ж */
};


/*
**  ʹжϣʹdoorbell1pc˷Ϣʹõж
*/
void hw_pci_enable_door1(void);

/*
**  ʹжϣʹdoorbell3pc˵ʹõж
*/
void hw_pci_enable_door3(void);

/*
**  ʹpci dmaжϣд
*/
void hw_pci_enable_dma(void);

/*
**  жϸpcˣʹdoorbell0
*/
void hw_pci_knock_door(void);

/*
**  ж״̬ʹdoorbell1pc˷Ϣʹõж
*/
void hw_pci_clear_door1_irq(void);

/*
**  ж״̬ʹdoorbell3pc˵ʹõж
*/
void hw_pci_clear_door3_irq(void);

/*
**  pci dmaж״̬д
*/
void hw_pci_clear_dma_irq(void);

/*
**  pciж״̬
*/
void hw_pci_clear_irq(void);

/*
**  ȡpciж״̬Ȼж
*/
void hw_pci_get_state(unsigned long *pul);


/***********************************************
**  pci
***********************************************/

#define PCI_MEM_SIZE            0x100400            /* pciڴĴС */
#define PCI_FILE_SIZE           0x100000            /* pciļߴ */

#endif
