/*
**  2Dģļ
*/

#include "vs28xx.h"
#include "pci.h"
#include "yuv.h"
#include "patch.h"
#include "preview.h"
#include "reg/preview_reg.h"
#include "reg/patch_reg.h"
#include "reg/enc_reg.h"


//#define USE_TIMER
#define TDE_IRQ 59

#ifdef USE_TIMER
#define DMA_IRQ                     1               /* ʱʹdmaҪж */
#define TDE_TIMER_INTERVAL          300             /* ʱΪ300 */
struct timer_list tde_timer;
#else
#define DMA_IRQ                     0               /* жʹdmaҪж */
#endif

#define TDE_C_BUFFER                0xCE000000      /* eεcεתַ */

/*
**  task0pv0ͨռ20D1֧2000*2000*4
**  task1nv3ͨռ10D1֧1920*1080*4
**  task2nv13ͨռ10D1֧1920*1080*4
**  task3mux6ͨռ10D1֧1920*1080*4
*/
static int tdestr[4] = {0, 20, 30 ,40};
static int tdebank[4] = {0, 1, 1 , 2};
static int tdech[4] = {0, 3, 13, 6};


/*
**  ȡصλ
*/
static unsigned long GetPixelBit(int task)
{
    int fmt;
    static int bits[8] = {1, 2, 4, 16, 16, 16, 24, 32};

    fmt = read_reg(0x56000008 + (task << 12));
    fmt = (fmt >> 16) & 0xF;
    if (fmt > 7)
        return 0;

    return bits[fmt];
}


/*
**  
*/
static void send_tde_data(int task)
{
    int ret;
    yuv_type_t *p0;
    dma_info_t dmaInfo;
    unsigned long *pul;
    unsigned long ulSize;
    unsigned long ulWidth;
    unsigned long ulHeight;
    unsigned long ulAhbAddr;
    unsigned long ulBitPerPixel;
    unsigned long ulBack;
    unsigned long ulRealAhb;
    unsigned long ulSendSize;

    id_frame_jiffies = jiffies;                     /* ʾƴӲԻڽ */

    ulSize = read_reg(0x5600002C + (task << 12));
    ulBitPerPixel = GetPixelBit(task);

    ulWidth = (ulSize >> 16) & 0x7FF;
    ulHeight = ulSize & 0x7FF;

    ulSize = ulWidth * ulHeight * ulBitPerPixel / 8;
    if ((0 == ulSize) || (ulSize > 0x1000000))
    {
        PRINT(ERR, "tde size fail 0x%lx\n", ulSize);
        return;
    }

    ulAhbAddr = read_reg(0x56000030 + (task << 12));
    if ((ulAhbAddr & 0xF0000000) == 0xE0000000)     /* pci dmaܴEݣҪȿC */
    {
        memcpy((void *)TDE_C_BUFFER, (void *)ulAhbAddr, ulSize);
        ulAhbAddr = TDE_C_BUFFER;
    }
    else if ((ulAhbAddr & 0xF0000000) != 0xC0000000)
    {
        PRINT(ERR, "tde addr fail 0x%lx\n", ulAhbAddr);
        return;
    }

    id_frame_jiffies = jiffies;                     /* EοCʱܱȽʱ */

    PRINT(INFO, "tde size %d %#lx %#lx\n", task, ulAhbAddr, ulSize);

    /* ʼַʱ˵ĵַ */
    ulBack = ulAhbAddr & 0x3;
    ulRealAhb = ulAhbAddr - ulBack;

    /* ȸպøַ෴ʱҪѳ */
    ulSendSize = ulSize + ulBack;
    ret = ulSendSize & 0x3;
    if (ret)
    {
        ulSendSize += (4 - ret);
    }

    pul = (unsigned long *)(dmaInfo.msgBuffer);
    pul[0] = byte_swap4(tdestr[task]);              /* Ԥͨ */
    pul[1] = byte_swap4(ulSize);                    /* ʵ */

	p0 = (yuv_type_t *)(pul + 2);                   /* pul[2], 3ֽͣôСת */
	p0->yuv = 1;                                    /* yuvΪ422 */
	p0->pack = ulBack;                              /* ãʾʼַ */
    p0->qua = 0x56;                                 /* ֱʣ־ʾ֤ߺͳȵĹϵ */

    dmaInfo.pciAddr = g_ulPreAddr[tdebank[task]][tdech[task]];  /* ôԤͨ */
    dmaInfo.ahbAddr = ulRealAhb;                    /* ʼַ */
    dmaInfo.dmaLength = ulSendSize;                 /* ͳ */
    dmaInfo.module = 0;                             /* Ҫص */
    dmaInfo.command = 0xB1;
    dmaInfo.msgLength = 16;

    ret = pci_dma_write(&dmaInfo, 0, DMA_IRQ);
    if (ret != 0)
    {
        PRINT(ERR, "tde write fail\n");
    }

    return;
}


/*
**  ʱ
*/
#ifdef USE_TIMER
static void timer_handler(unsigned long v)
#else
static void tde_handler(int irq, void *dummy, struct pt_regs *regs)
#endif
{
    int i;
    unsigned long state;

    state = read_reg(0x56000000);
    for (i = 0; i < 4; i++)
    {
        if (state & (0x10000 << i))
        {
            send_tde_data(i);
        }
    }

#ifdef USE_TIMER
    tde_timer.data = 0;
    tde_timer.function = timer_handler;
    tde_timer.expires = jiffies + TDE_TIMER_INTERVAL;
    add_timer(&tde_timer);
#endif

    return;
}


/*
**  2Dģע
*/
void tde_exit(void)
{
#ifndef USE_TIMER
    disable_irq(TDE_IRQ);                           /* ͷж */
    free_irq(TDE_IRQ, 0);
#endif
    return;
}


/*
**  2Dģʼ
**  ûڴ棬IDļַָ
*/
int tde_init(void)
{
    config_ddr();                                   /* ddr */

#ifdef USE_TIMER
    tde_timer.data = 0;
    tde_timer.function = timer_handler;
    tde_timer.expires = jiffies + TDE_TIMER_INTERVAL;
    add_timer(&tde_timer);
#else
    if(request_irq(TDE_IRQ, tde_handler, SA_INTERRUPT, "tde_handler", 0) != 0)
    {
        PRINT(ERR, "tde_init request_irq fail\n");
        return -1;
    }
    enable_irq(TDE_IRQ);
#endif

    PRINT(INFO, "tde_init\n");

    return 0;
}
