/*
**  vs2811ƽ̨ļvs2811ģڣԼһЩȫֺʵ
*/

#include <linux/init.h>                             /* __init, __exit */
#include <linux/autoconf.h>                         /* I Dcache */
#include "vs28xx.h"
#include "log.h"
#include "list.h"
#include "effect.h"
#include "patch.h"
#include "osd.h"
#include "md.h"
#include "im.h"
#include "audio.h"
#include "iic.h"
#include "yuv.h"
#include "enc.h"
#include "jpeg.h"
#include "preview.h"
#include "tde.h"
#include "dec.h"
#include "pci.h"


#ifdef BIG_ENDIAN
/*
**  unsigned long(4ֽ)ĴСת
**  ʱľΪʡ(zxj)
*/
unsigned long byte_swap4(unsigned long v)
{
    unsigned int reg;

    __asm__ __volatile__
    (
        "mov %0, r2\n"

        "lsli r2, 8\n"
        "xtrb1 r1, r2\n"
        "or    r2, r1\n"
        "lsli r2, 16\n"

        "xtrb0 r1, %0\n"
        "or    r2, r1\n"
        "xtrb1 r1, %0\n"
        "lsli r1,8\n"

        "or    r2, r1\n"
        : "=r" (reg)
        : "0"(reg)
    );
}


/*
**  unsigned short(2ֽ)ĴСת
*/
unsigned short byte_swap2(unsigned short v)
{
    __asm__ __volatile__
    (
        "lsli r2, 8\n"
        "xtrb1 r1, r2\n"
        "or    r2, r1\n"
    );

    return v;
}
#endif


/*
**  ȡڴռ䣬ĿǰοռķΧ0xC2000000-0xCFFFFFFF
**  ulSizeΪռĴСֽΪλ
**  ֵΪ뵽ռʼַ0˵ʧ
**
**  ulSize4K룬Զ4K(ȡ)
**  Ŀռ䣬ֻ룬ͷţҪСʹ
**
**  0x03
*/
unsigned long get_memory(unsigned long ulSize)
{
    unsigned long ulAlign;
    unsigned long ulAddr;
    static unsigned long s_ulCBank = 0xC2000000;

    FUNC_TRACK(0x03);

    if (0 == ulSize)
    {
        FUNC_COUNTER(0x03, 0x00);
        PRINT(ERR, "zero size\n");
        return 0;
    }

    ulAlign = ulSize & 0xFFF;                       /* ʹulSize 4K */
    if (ulAlign != 0)
    {
        ulSize += (0x1000 - ulAlign);
    }

    if ((s_ulCBank + ulSize) > 0xD0000000)
    {
        FUNC_COUNTER(0x03, 0x01);
        PRINT(ERR, "not enough memory\n");
        return 0;
    }

    ulAddr = s_ulCBank;
    s_ulCBank += ulSize;                            /* ַ */

    return ulAddr;
}


/*
**  ӡϢҪģ鶨Ϣ
**  0x02
*/
static void print_vs28xx_info(void)
{
    FUNC_TRACK(0x02);

#if defined CONFIG_ICACHE || defined CONFIG_DCACHE
#ifdef CONFIG_ICACHE
    PRINT(INFO, "I");
#endif
#ifdef CONFIG_DCACHE
    PRINT(INFO, "D");
#ifdef CONFIG_CK510_DATA_CACHE_WB
    PRINT(INFO, "(WB)");
#endif
#endif
#else
    PRINT(INFO, "No ");
#endif
    PRINT(INFO, "Cache\n");

#if defined VS28XX_MODE_PURE
    PRINT(INFO, "VS28XX_MODE_PURE\n");
#elif defined VS28XX_MODE_PRE
    PRINT(INFO, "VS28XX_MODE_PRE\n");
#elif defined VS28XX_MODE_ALL
    PRINT(INFO, "VS28XX_MODE_ALL\n");
#elif defined VS28XX_MODE_AUD
    PRINT(INFO, "VS28XX_MODE_AUD\n");
#elif defined VS28XX_MODE_ID
    PRINT(INFO, "VS28XX_MODE_ID\n");
#elif defined VS28XX_MODE_PATCH
    PRINT(INFO, "VS28XX_MODE_PATCH\n");
#endif

#ifdef HD_TEST
    PRINT(INFO, "HD_TEST\n");
#endif

#if defined TW2864_27M_1D1
    PRINT(INFO, "TW2864_27M_1D1\n");
#elif defined TW2864_54M_2D1
    PRINT(INFO, "TW2864_54M_2D1\n");
#elif defined TW2864_54M_4CIF
    PRINT(INFO, "TW2864_54M_4CIF\n");
#elif defined TW2864_108M_4D1
    PRINT(INFO, "TW2864_108M_4D1\n");
#endif

#if defined CHIP4_0
    PRINT(INFO, "CHIP4_0\n");
#elif defined CHIP2_02
    PRINT(INFO, "CHIP2_02\n");
#endif

#ifdef DEFAULT_NTSC
    PRINT(INFO, "DEFAULT_NTSC\n");
#endif

    return;
}


/*
**  vs2811ģע˳Ƚ
**  0x01
*/
static void __exit vs28xx_exit(void)
{
    FUNC_TRACK(0x01);

    pci_exit();                                     /* pciģע */

#ifdef PRE
    preview_exit();                                 /* Ԥģע */
#endif

#ifdef ENC
    enc_exit();                                     /* ģע */

    jpeg_exit();                                    /* jpegģע */
#endif

#ifdef YUV
    yuv_exit();                                     /* yuvģע */
#endif

#ifdef IIC
    iic_exit();                                     /* iicģע */
#endif

#ifdef AUD
    audio_exit();                                   /* Ƶģע */
#endif

#ifdef MOTION
    md_exit();                                      /* ģע */
#endif

#ifdef OSD
    osd_exit();                                     /* osdģע */
#endif

#ifdef VS28XX_MODE_PATCH
    dec_exit();                                     /* ģע */
    tde_exit();                                     /* 2Dģע */
    patch_exit();                                   /* ƴӲģע */
#endif

#ifdef LIST_EFFECT
    list_exit();                                    /* listģע */
#endif

    return;
}


/*
**  vs2811ģʼ
**  0x00
*/
static int __init vs28xx_init(void)
{
    int ret;

#if 0
    PRINT(INFO, "I'm not work\n");
    return 0;
#endif

    ZERO_LOG();                                     /* ־ */

    FUNC_TRACK(0x00);                               /* 㼣 */

    PRINT(INFO, "+vs28xx_init v35\n");

    print_vs28xx_info();                            /* ӡģ鶨ĺϢ */

#ifdef LIST_EFFECT
    ret = list_init();                              /* listģʼ(64K) */
    if (ret != 0)
    {
        FUNC_COUNTER(0x00, 0x00);                   /* 쳣Ϣ */
        return -1;
    }

    /*
    **  listҪǽȲ
    **  ֮ǰeffect_initpreview_initǰãġ
    **  effect_initи̣ȷͨĳʼһµģ
    **  ͵ΪͨڴҲظˣosdʱڱͨosdһµģû
    **  ⶯ʱִ⡣
    */
    ret = effect_init();
    if (ret != 0)
    {
        FUNC_COUNTER(0x00, 0x01);
        return -1;
    }
#endif

#ifdef VS28XX_MODE_PATCH
    ret = patch_init();                             /* ƴģʼ(68Mռ) */
    if (ret != 0)
    {
        FUNC_COUNTER(0x00, 0x02);
        return -1;
    }
#if 0
    ret = tde_init();                               /* 2DģʼƴģһӦòӰ */
    if (ret != 0)
    {
        FUNC_COUNTER(0x00, 0x02);
        return -1;
    }

    ret = dec_init();                               /* ģʼ */
    if (ret != 0)
    {
        FUNC_COUNTER(0x00, 0x02);
        return -1;
    }
#endif
#endif

#ifdef OSD
    ret = osd_init();                               /* osdģʼ(1M/?) */
    if (ret != 0)
    {
        FUNC_COUNTER(0x00, 0x03);
        return -1;
    }
#endif

#ifdef MOTION
    ret = md_init();                                /* ģʼ(512K) */
    if (ret != 0)
    {
        FUNC_COUNTER(0x00, 0x04);
        return -1;
    }
#endif

#ifdef AUD
    ret = audio_init();                             /* Ƶģʼ(1M256K) */
    if (ret != 0)
    {
        FUNC_COUNTER(0x00, 0x06);
        return -1;
    }
#endif

	udelay(10000);									/* for vs2811_sys_top_pv_nv_mux_B2_101109_1.bit */

#ifdef IIC
    ret = iic_init();                               /* iicģʼ */
    if (ret != 0)
    {
        FUNC_COUNTER(0x00, 0x07);
        return -1;
    }
#endif

#ifdef YUV
    ret = yuv_init();                               /* yuvģʼ */
    if (ret != 0)
    {
        FUNC_COUNTER(0x00, 0x08);
        return -1;
    }
#endif

#ifdef ENC
    ret = enc_init();                               /* ģʼ(102M63M768K) */
    if (ret != 0)
    {
        FUNC_COUNTER(0x00, 0x09);
        return -1;
    }

    ret = jpeg_init();                              /* jpegģʼ(1M)ܷenc_init֮ǰΪҪE */
    if (ret != 0)
    {
        FUNC_COUNTER(0x00, 0x0A);
        return -1;
    }
#endif

#ifdef PRE
    ret = preview_init();                           /* Ԥģʼ(16ch90M1008K122M640K) */
    if (ret != 0)
    {
        FUNC_COUNTER(0x00, 0x0B);
        return -1;
    }
#endif

#ifdef LIST_EFFECT
    list_fill_para_finish();                        /* listӲ */
#endif

    ret = vs2811_pci_init();                        /* pciģʼ */
    if (ret != 0)
    {
        FUNC_COUNTER(0x00, 0x0C);
        return -1;
    }

    PRINT(INFO, "-vs28xx_init %#lx %#lx\n", get_memory(0x1000), get_e_memory(0x1000));

    return 0;
}


module_init(vs28xx_init);
module_exit(vs28xx_exit);
