/*
**  yuvģļ
**  yuvģҪǹã룬ԤjpegṩyuvԴ
*/

#include "vs28xx.h"
#include "log.h"
#include "list.h"
#include "pci.h"
#include "enc.h"
#include "yuv.h"
#include "osd.h"
#include "md.h"
#include "im.h"
#include "preview.h"
#include "patch.h"
#include "reg/yuv_reg.h"
#include "reg/audio_reg.h"
#include "reg/jpeg_reg.h"


#define YUV_TIMER_INTERVAL          10              /* ԴʱΪ10 */
struct timer_list yuv_timer;                        /* Դʱ */

#define ID_ACTIVE_TIME              10000           /* 10붼ûݲΪһIDѾ */
#define ID_TIMER_INTERVAL           1000            /* IDʱΪ1 */
struct timer_list id_timer;                         /* IDʱ */


/**  +@õľ̬@+  ***************************/
static unsigned long s_id_running;                  /* ־ǷID */
static unsigned long s_id_yuv_buffer;               /* Դַ */
static int s_id_yuv_valid;                          /* ԴǷЧ */
/**  -@õľ̬@-  **************************/

/**  +@õľ̬@+  ******************/
static unsigned long s_id_enc_timestamp;            /* ʱ0ʼÿμ1 */
static unsigned long s_id_enc_bp_change;            /* ı־λp֡b֡ */
static unsigned long s_id_enc_crc_addr = 0x52800000;/* crcУַ */
static unsigned long s_id_enc_req_buf_index;        /* 뵽֡ */
static unsigned long s_id_enc_req_buf_addr;         /* 뵽ַ֡ */
/**  -@õľ̬@-  ******************/

/**  +@Ԥõľ̬@+  ******************/
static int s_id_pre_first_frame[16];                /* ־ĵĵһ֡ */
static unsigned long s_id_pre_cur_bank[16];         /* ǰַ֡ */
static unsigned long s_id_pre_lst_bank[16];         /* һַ֡ */
static unsigned long s_id_pre_delay_swh;            /* ӳٿ */
/**  -@Ԥõľ̬@-  ******************/

/**  +@Ƶõľ̬@+  ******************/
static unsigned long s_id_aud_delay_swh;            /* ӳٿ */
/**  -@Ƶõľ̬@-  ******************/


/*
**  һƬе֡
**  typeΪ0ʾh264֡棬Ϊ1ʾjpeg֡
**  userʾûjpegֻ֡ͣjpegʱЧ
**  chʾͨ(0-16)ֻh264ʱЧ
**  strʾ(0-2)ֻh264ʱЧ
**  0ʾɹ-1ʾʧ
*/
static int request_free_buffer(int type, int user, int ch, int str)
{
    int repeat;
    unsigned long state;

	/* ʼ */
	write_reg(0x54030000, (1 << 23) + (1 << 19) + (1 << 15));
	write_reg(0x54030004, 0);

	if (0 == type)                                  /* ֡0ʾh264֡棬1ʾjepg֡ */
	{
	    write_reg(0x54030000, (1 << 15) + (1 << 12) + (ch << 6) + (str << 4));
	}
	else
	{
	    write_reg(0x54030000, (1 << 15) + (1 << 12) + (3 << 4) + user);
	}

	repeat = 0;                                     /* ȴACK */
	while (1)
	{
		state = read_reg(0x54030004);
		if((state & (1 << 21)) != 0)                /* ȵACK */
		{
			if(0 == (state & (1 << 20)))            /* ûг */
			{
			    s_id_enc_req_buf_index = (state >> 24);
			    s_id_enc_req_buf_addr  = 0xe0000000 + ((state & 0x1ffff) << 11);
				return 0;
			}

            PRINT(ERR, "wait ack fail\n");
			return -1;
		}

		repeat++;
		if (repeat > 0x100000)
		{
		    PRINT(ERR, "wait ack timeout\n");
		    return -1;
		}
	}

	return -1;
}


/*
**  յpc˴yuv
*/
void yuv_data_ready(unsigned long ulMemory)
{
	s_id_yuv_valid = 1;
	s_id_yuv_buffer = ulMemory;

    return;
}


/*
**  ׼idԣбλȲ
**  ˺ȿڱʱãҲԤʱ(Ϊõģ)
*/
void enc_id_prepare(void)
{
    enc_reset();                                    /* λģ */

    s_id_enc_timestamp = 0;                         /* ʱ0ʼ */
    s_id_enc_bp_change = 0x1000000;                 /* ı־λp֡b֡ */
    s_id_enc_crc_addr = 0x52800000;                 /* crcַصʼ */

	s_id_running = 1;                               /* ־IDԿʼ */

    return;
}


/*
**  ԤԴʱIDοtrans_write_direct
**  ҪΪID̫ѾôϢĻ
**  nJpgEnʾjpegʹ
**  nKFYLenʾؼ֡Yݳ
**  nKFMapLenʾؼ֡mapݳ
**
**  ϢȲ̶£
**  ţ֣01...n
**  ÿΪʼַĵַnnֵ
*/
static int preview_id(int nLength, int nJpgEn, int nKFYLen, int nKFMapLen, unsigned char *pucData)
{
    int i, j;
    int nItemCount;
    int nAddrCount;
    unsigned long *pulData;
    unsigned long ulAddr;
    unsigned long ulOffset;
    unsigned long val;

    pulData = (unsigned long *)(pucData + 4);       /* ȡ0Ϊ1,2Ϊд(), 3ΪԤID */
    if (byte_swap4(pulData[0]) != 3)                /* ʹҲҪ */
    {
        return 0;
    }

#ifdef ENC
    enc_id_prepare();                               /* ׼idԣs_id_running1־IDԿʼ */
#else
    s_id_running = 1;                               /* ʾѾʼ */
#endif

    write_reg(0x61000144, 0x1);                     /* ɲģʽҪڸλ֮ǰ */

    write_reg(0x61000204, 0x1);                     /* λԤģ */

    write_reg(0x61240030, 0xFFFF);                  /* дһ֡źţҪǽ? */

    write_reg(0x61240034, 0xFFFF);                  /* дһ֡ź */

    write_reg(0x61240038, 0xFFFF);                  /* дؼ֡һ֡ź */

    id_pre_doing_now = 1;                           /* ʾڽԤԴ */

    id_pre_md_frame_pos = 0;                        /* õ֡λ0 */

    id_pre_kf_y_len = nKFYLen;                      /* ؼ֡ */
    id_pre_kf_map_len = nKFMapLen;

    id_pre_jpeg_en = nJpgEn;                        /* jpegʹ */

    for (i = 0; i < 16; i++)
    {
        /* ѸͨĽοֵóɳʼֵ */
        write_reg(0x6123003C + (i << 12), 0x10000001);

        /* Ѹͨܲοֵóɳʼֵ(723ĵ(֮ǰ)˵λֻ?) */
        write_reg(0x6123005C + (i << 12), 0x80);

        /* ؼ֡֡ۻ0 */
        write_reg(0x61230060 + (i << 12), 0);

        /* ͨĵһ֡־ */
        s_id_pre_first_frame[i] = 1;

        /*
        **  ڲģʽ£ΪͨviuڴΪw * h * 4Ƭڴ
        **  պøĵǰ֡һ֡ʹ
        **  ʱֻⵥͨ(0ͨ)lstbank4M
        */
        if (0 == s_id_pre_cur_bank[i] || 0 == s_id_pre_lst_bank[i])
        {
            s_id_pre_cur_bank[i] = read_reg(0x61002040 + (i << 2));
#ifdef HD_TEST
            s_id_pre_lst_bank[i] = s_id_pre_cur_bank[i] + 0x400000;
#else
            s_id_pre_lst_bank[i] = s_id_pre_cur_bank[i] + WIDHT_FOR_MEM * HEIGHT_FOR_MEM * 2;
#endif
        }

        /* Ȱѿ״̬رգȸͨԴʱٸԴ */
        g_nPreSwitch[0][i] = 0;
        g_nPreSwitch[1][i] = 0;
        g_nPreSwitch[2][i] = 0;
    }

    nItemCount = byte_swap4(pulData[1]);            /* ȡ */
    pulData += 2;                                   /* ָһ */

    for (i = 0; i < nItemCount; i++)
    {
        ulAddr = byte_swap4(pulData[0]);            /* ȡַ */
        nAddrCount = byte_swap4(pulData[1]);        /* ȡĵַ */
        pulData += 2;

        /*
        **  Ԥidԣlistַƫַ28-31λӦòΪ0
        **  IDڲӦиʹlistĲ
        **
        **  ע⣬ͨԤͱʱIDǴģдlistֲǹ̶λIDĿͷ
        **  IDмҲǻе
        */
        if (ulAddr & 0xF0000000)
        {
            ulOffset = 0;
        }
        else
        {
            ulOffset = g_ulList_h0;
        }

        for (j = 0; j < nAddrCount; j++)
        {
            write_reg(ulAddr + ulOffset, byte_swap4(pulData[j]));
            ulAddr += 4;
        }
        pulData += nAddrCount;
    }

    /* ȡyuvͺʹʽԱȷԤݵĳ */
    for (i = 0; i < 16; i++)
    {
        val = read_reg(g_ulList_h0 + (i << 10) + 0x54);    /* PV */
        g_nYuvType[0][i] = (val >> 3) & 0x1;
        g_nPackType[0][i] = (val >> 1) & 0x3;

        val = read_reg(g_ulList_h0 + (i << 10) + 0xCC);    /* NV */
        g_nYuvType[1][i] = (val >> 3) & 0x1;
        g_nPackType[1][i] = (val >> 1) & 0x3;

        val = read_reg(g_ulList_h0 + (i << 10) + 0x148);   /* MUX */
        g_nYuvType[2][i] = (val >> 4) & 0x1;
        g_nPackType[2][i] = (val >> 2) & 0x3;
    }

    PRINT(INFO, "W\n");

    return 0;
}


/*
**  2DԴ
**  chΪtask
**  lstchΪtask16λʾtaskʹܣ16λʾtaskǷҪԴ
**  lenΪԴĳ
**  srcΪԴַ
*/
static int tde_src(int ch, int lstch, int len, void *src)
{
    int i;
    unsigned long dst;
    unsigned long bank;

    if (ch < 0 || ch > 3)
    {
        PRINT(ERR, "tde_src ch err\n");
        return 0;
    }

    id_frame_jiffies = jiffies;                     /* ʾԻڽ */

    PRINT(INFO, "tde_ch %d %#x\n", ch, lstch);    	/* 䵱ʱpcд1Mļ˫ */

    /*
    **  жǷҪԴ
    **  lstch4λΪ0ҪݣʱchӦλΪ1ش
    */
    if ((lstch & 0xF) != 0)
    {
        dst = read_reg(0x56000024 + (ch << 12));    /* ȡĿַûϵ? */
        bank = dst >> 28;
        if ((0 == bank) || (bank != 0xC && bank != 0xE))
        {
            PRINT(ERR, "tde_src dst err %d %#lx\n", ch, dst);
            return 0;
        }

        memcpy((void *)dst, src, len);
        PRINT(INFO, "tde_src %#x\n", len);

        for (i = 3; i >=0; i--)
        {
            if ((lstch >> i) & 0x1)
            {
                break;
            }
        }

        /* һtaskԴ֮󣬲 */
        if (i != ch)
        {
            return 0;
        }
    }

    s_id_running = 1;                               /* ʾѾʼ */

    lstch >>= 16;
    for (i = 0; i < 4; i++)
    {
        if ((lstch >> i) & 0x1)
        {
            write_reg(0x56000004, (0x1 << i));
        }
    }

    return 0;
}


/*
**  ŲԴ
**  chΪͨţ̶Ϊ0
**  lstchԴȣģʽϢ
**  lenΪԴĳ
**  srcΪԴַ
*/
static int dec_src(int ch, int lstch, int len, void *src)
{
    id_frame_jiffies = jiffies;                     /* ʾԻڽ */

    PRINT(INFO, "dec_src %#x %#x\n", lstch, len);

    memcpy((void *)0xE0100000, src, len);

    id_frame_jiffies = jiffies;                     /* ʾԻڽУܱȽϺʱ */

    s_id_running = 1;                               /* ʾѾʼ */

    write_reg(0x55000010, 0xE0100000);
    write_reg(0x55000014, lstch);
    write_reg(0x55000018, 0);                       /* ʱ */
    write_reg(0x5500001C, 1);                       /*  */

    return 0;
}


/*
**  ƴԴ
**  chΪ(0-15)
**  lstchΪ
**  lenΪyuvԴĳ
**  signalΪʼͽź
**  srcΪԴַ
*/
static int patch_src(int ch, int lstch, int len, int signal, void *src)
{
    id_frame_jiffies = jiffies;                     /* ʾƴӲԻڽ */

    if (0 == id_patch_ready)                        /* жûܵ */
    {
        return -1;
    }

    memcpy((void *)g_ulBlockAddr[ch], src, len);    /* Դ */
    PRINT(INFO, "patch_src %d %d\n", ch, lstch);

    if (ch == lstch)                                /* ֻеһԴʱʹ */
    {
        s_id_running = 1;                           /* ʾѾʼ */

        write_reg(0x61300000, 0x10000);             /* λ */

        udelay(2000);                               /* ʱ */

        if (signal)                                 /* ʼͽź */
        {
            PRINT(INFO, "patch_signal %#lx\n", signal);
            write_reg(0x6120101C, signal);
        }

        write_reg(0x61000208, 1);                   /* ʹ */

        id_hdsd_ready = 1;                          /* ƴԴѾ׼ */

        id_patch_ready = 0;                         /* ȴһж */
    }

    return 0;
}


/*
**  Դ
**  chΪ(0-15)
**  lstchΪ
**  lenΪyuvԴĳ
**  srcΪԴַ
*/
static int std_src(int ch, int lstch, int len, void *src)
{
    id_frame_jiffies = jiffies;                     /* ʾƴӲԻڽ */

    memcpy((void *)g_ulBlockAddr[ch], src, len);    /* Դ */
    PRINT(INFO, "std_src %d %d\n", ch, lstch);

    if (ch == lstch)                                /* ֻеһԴʱʹ */
    {
        s_id_running = 1;                           /* ʾѾʼ */

        write_reg(0x61400000, 0x10000);             /* λ */

        udelay(2000);                               /* ʱ */

        write_reg(0x61400000, 0x100);               /* ʹ */

        write_reg(0x61000220, 1);                   /* ͨԶʹ */

        id_hdsd_ready = 2;                          /* ԴѾ׼(ƴӲԹ) */
    }

    return 0;
}


/*
**  ƴosd
**  lenΪosdݵܳ
**  srcΪԴַ
**
**  osdݸʽΪ:3ֱʾ3osdݵĳȣ3νӵosd
*/
static int patch_osd_data(int len, void *src)
{
    int i;
    char *pchData;
    int nRealLen[3];
    unsigned long *pulLen;

    id_frame_jiffies = jiffies;                     /* ʾƴӲԻڽ */

    pulLen = (unsigned long *)src;
    pchData = (char *)(pulLen + 3);

    nRealLen[0] = byte_swap4(pulLen[0]);            /* ȡosdݵĳ */
    nRealLen[1] = byte_swap4(pulLen[1]);
    nRealLen[2] = byte_swap4(pulLen[2]);

    if (len != (nRealLen[0] + nRealLen[1] + nRealLen[2] + 12))
    {
        PRINT(ERR, "patch_osd len err: %#x %#x %#x %#x\n",
            len, nRealLen[0], nRealLen[1], nRealLen[2]);
        return 0;                                   /* ʹˣҲҪosdԴ */
    }

    for (i = 0; i < 3; i++)
    {
        memcpy((void *)g_ulPatchOsdAddr[i], pchData, nRealLen[i]);
        pchData += nRealLen[i];
    }

    PRINT(INFO, "patch_osd %#x\n", len);

    return 0;
}


/*
**  osd
**  lenΪosdݵܳ
**  srcΪԴַ
**
**  osdݸʽΪ:3ֱʾ3osdݵĳȣ3νӵosd
*/
static int std_osd_data(int len, void *src)
{
    int i;
    char *pchData;
    int nRealLen[3];
    unsigned long *pulLen;

    id_frame_jiffies = jiffies;                     /* ʾԻڽ */

    pulLen = (unsigned long *)src;
    pchData = (char *)(pulLen + 3);

    nRealLen[0] = byte_swap4(pulLen[0]);            /* ȡosdݵĳ */
    nRealLen[1] = byte_swap4(pulLen[1]);
    nRealLen[2] = byte_swap4(pulLen[2]);

    if (len != (nRealLen[0] + nRealLen[1] + nRealLen[2] + 12))
    {
        PRINT(ERR, "std_osd len err: %#x %#x %#x %#x\n",
            len, nRealLen[0], nRealLen[1], nRealLen[2]);
        return 0;                                   /* ʹˣҲҪosdԴ */
    }

    for (i = 0; i < 3; i++)
    {
        memcpy((void *)g_ulPatchOsdAddr[i], pchData, nRealLen[i]);
        pchData += nRealLen[i];
    }

    PRINT(INFO, "std_osd %#x\n", len);

    return 0;
}


/*
**  ԤԴʱosdݣᳬ1MԵһ֡
**  lenʾηݳ
**  srcΪԴַ
*/
static int osd_src(int len, void *src)
{
    if (0 == id_pre_osd_base)
    {
        PRINT(ERR, "osd null addr\n");
        return 0;
    }

    if (len < 1 || len > 0x100000)
    {
        PRINT(ERR, "osd size fail %#x\n", len);
        return 0;
    }

    memcpy((void *)id_pre_osd_base, src, len);
    PRINT(INFO, "osd_src %#x\n", len);

    return 0;
}


/*
**  ƵԴĿǰֻԽ
**  modeΪģʽȡֵ0-3ʱʾԽΪbypassԽֱΪbypassg711ag711ug721
**  modeȡֵ4-6ʱʾԽΪbypassԽֱΪg711ag711ug721
**  lenʾݳ
**  totalʾԴĴС
**  sendʾ֮ǰѷ͵(PC˵)
**  srcΪԴַ
*/
static int audio_src(int mode, int len, int total, int send, void *src)
{
    static int rate[7] = {1, 2, 2, 4, 2, 2, 4};

    if (mode < 0 || mode > 6)
    {
        PRINT(ERR, "audio mode error\n");
        return 0;
    }

    if (send + len > 0x8000000)                     /* ĿǰƵԴӦòᳬ128M */
    {
        PRINT(ERR, "audio too big\n");
        return 0;
    }

    memcpy((void *)(0xC8000000 + send), src, len);
    PRINT(INFO, "audsrc %d 0x%x\n", mode, len);

    if (send + len >= total)                        /* жԴǷ */
    {
        if (total < g_nSphDecLen)                   /* ܳȻһ֡ */
        {
            PRINT(ERR, "audio too small\n");
            return 0;
        }

        total = total / g_nSphDecLen * g_nSphDecLen;/* ȷ֡ */

        if (mode < 4)
        {
            hw_aud_set_mode(1, mode);               /* Խģʽ */
            hw_aud_set_mode(2, 0);                  /* Խbypass */
            id_aud_data_desire = total / rate[mode];
        }
        else
        {
            hw_aud_set_mode(1, 0);                  /* Խbypass */
            hw_aud_set_mode(2, mode - 3);           /* ԽģʽעⲻǼ4 */
            id_aud_data_desire = total * rate[mode];
        }

        id_aud_data_send = 0;                       /* δ */
        s_id_running = 1;                           /* ־ID */

        g_ulSphDecDataAddr = 0xC8000000;            /* ʼַ */
        g_ulSphDecDataLeng = total - g_nSphDecLen;  /* ݳԤ */

        PRINT(INFO, "audsrc start\n");

        write_reg(SPH_DEC_MEM_BASE, 0xC8000000);    /* дݵַ */
        s_id_aud_delay_swh = 2;                     /* ӳ10msһʱ */
    }

    return 0;
}


/*
**  
**  УԴǴǰ˽ǴPC˵
**  ΪֵַУѾСת
**  frameΪҪ֡
**  lenΪ
*/
static int encpara_src(int frame, int len, unsigned long *pul)
{
    int i;
    int list;

    enc_id_prepare();                               /* λģ飬s_id_running1־IDԿʼ */

    len /= 4;                                       /* ȳ4Ϊλ */

    id_par_frame_send = 0;                          /* ѷ֡0 */
    id_par_frame_desire = frame;                    /* Ҫ֡ */

    /*
    **  ʼһдlistȥĶԵֱַ0xffffffff
    **  һԴˢlistĲ
    */
    list = 1;

    for (i = 0; i < len; i += 2)
    {
        if (list)
        {
            if (0xFFFFFFFF == pul[i])
            {
                list = 0;
                continue;
            }

            /*
            **  ȻֱдӲlistȥ֮ǰӲlistѾһ£
            **  ûдֵַ(ַ)֮Ӳlistĵֵַһµ
            */
            pul[i] += g_ulList_h0;
        }

        if (0 == pul[i] || (pul[i] & 0x3) != 0)     /* ַΪ0Ҫ4ֽڶ */
        {
            PRINT(ERR, "encpara_src addr 0x%lx\n", pul[i]);
            return 0;
        }

        write_reg(pul[i], pul[i + 1]);
    }

    PRINT(INFO, "encpara_src %d %d\n", frame, len);

    return 0;
}


/*
**  ԤԴ
**  chΪͨ(0-15)
**  lstchΪͨ
**  w,hΪԴĿߣ16Ϊλ
**  lenΪԴĳ
**  srcΪԴַ
*/
static int preview_src(int ch, int lstch, int w, int h, int len, void *src)
{
    int i;
    unsigned long tmp;
    static int s_nMsg = 0;

    if (1 == id_pre_yuv_ready)                      /* ԤԴûʹ */
    {
        if (0 == s_nMsg)                            /* ֻʾһ */
        {
            s_nMsg = 1;
            PRINT(ERR, "preview_src busy\n");
        }

        return -1;
    }

    /* ǰ֡һַ֡֡Ϊ */
    if (0 == s_id_pre_cur_bank[ch] || 0 == s_id_pre_lst_bank[ch])
    {
        PRINT(ERR, "preview_src null addr!\n");
        return 0;
    }

    /*
    **  Ԥأ֮ԲIDʱȫ򿪣
    **  ΪûпԤͨᱨ
    */
    g_nPreSwitch[0][ch] = 1;
    g_nPreSwitch[1][ch] = 1;
    g_nPreSwitch[2][ch] = 1;

    memcpy((void *)s_id_pre_cur_bank[ch], src, len);/* Դǰ֡ */

    write_reg(0x61002040 + (ch << 2), s_id_pre_cur_bank[ch]);
    write_reg(0x61000180 + (ch << 2), s_id_pre_lst_bank[ch]);

    tmp = s_id_pre_cur_bank[ch];                    /* л֡ */
    s_id_pre_cur_bank[ch] = s_id_pre_lst_bank[ch];
    s_id_pre_lst_bank[ch] = tmp;

    if (s_id_pre_first_frame[ch])
    {
        s_id_pre_first_frame[ch] = 0;               /* һ֡ñ־Դ */
        PRINT(INFO, "pre_first %d\n", ch);
        return 0;
    }

    PRINT(INFO, "pre_src %d\n", ch);

    /* ģʽĿ */
    write_reg(0x610001C0 + (ch << 2), (h << 16) | w);

    if (ch == lstch)                                /* ֻеһͨԴʱ */
    {
        if (id_pre_jpeg_en)                         /* jpegʹ */
        {
            tmp = -1;                               /* һβж */
            for (i = 0; i < 17; i++)
            {
                if ((id_pre_jpeg_en >> i) & 0x1)
                {
                    tmp++;
                }
            }

            write_reg(JPEG_ENC_CTL, id_pre_jpeg_en | (tmp << 24));
        }

        id_pre_md_frame_pos++;                      /* õ֡λü1 */

        id_pre_yuv_ready = 1;                       /* ־ԤԴ */

        /*
        **  ͨʱһδжжϣ粻ӳٿأᶪж
        **  ѾĳɶֻͨһжϣӦûϵ?
        **  վ
        */
        s_id_pre_delay_swh = 2;
    }

    return 0;
}


/*
**  Դ(ͬʱjpgԴ)
**  chΪͨ(0-16)
**  w,hΪߣֵΪʵ߳16
**  lenΪyuvԴĳ
**  streamΪͣbit0-2ʾbit4-6ʾjepg3
**  srcΪԴַ
*/
static int h264_src(int ch, int w, int h, int len, int stream, void *src)
{
    int i;
    int ret;
	unsigned long ulH264YuvAddr;
	unsigned long ulH264Index[3];
    unsigned long ulJpegIndex;
    unsigned long ulJpegBit;

#if 0
    unsigned long ulCpyLen;
    unsigned long ulCrcCnt;
    unsigned long ulCrcLen;
    unsigned long ulCrcDst;
    unsigned long ulCrcSrc;
#endif

    ret = read_reg(0x54030000);
    if ((ret & (1 << 16)) != 0)                     /* REG_INFO_WR_REQΪ0ʱܼ */
    {
        PRINT(ERR, "REG_INFO_WR_REQ busy\n");
        return -1;
    }

    ulH264YuvAddr = 0;                              /* ־λ */
    ulJpegBit = 0;
    ulJpegIndex = 0;

    for (i = 0; i < 3; i++)                         /* ȴ3 */
    {
        if (stream & (0x1 << i))                    /* str0:bit0, str1:bit1, str2:bit2 */
        {
            ret = request_free_buffer(0, 0, ch, i); /* еh264֡ */
            if (0 == ret)
            {
                if (0 == ulH264YuvAddr)             /* 俽ַ(һĵַ0120121030) */
                {
                    ulH264YuvAddr = s_id_enc_req_buf_addr;
                }

                /* ÿindexҪס */
                ulH264Index[i] = s_id_enc_req_buf_index;
            }
            else
            {
                PRINT(ERR, "enc string%d busy\n", i);
                return -1;
            }
        }
    }

    if (stream & 0x70)                              /* jpeg bit4-6 */
    {
        ret = request_free_buffer(1, 0, 0, 0);      /* еjpegռ */
        if (0 == ret)
        {
            if (0 == ulH264YuvAddr)                 /* 俽ַ(Ҫ) */
            {
                ulH264YuvAddr = s_id_enc_req_buf_addr;
            }

            ulJpegIndex = s_id_enc_req_buf_index;   /* jpeg index*/

            for (i = 0; i < 3; i++)                 /* ʹλ */
            {
                if (stream & (0x10 << i))           /* str0:bit4, str1:bit5, str2:bit6 */
                {
                    ulJpegBit |= (0x1000000 >> (i << 3));   /* str0:bit24, str1:bit16, str2:bit8 */
                }
            }
        }
        else
        {
            /*
            **  ֻjpegæΪǳ
            **  ͬʱ˱룬򲻹jepgæ뻹Ҫ
            **  и⣬jpegỺǰ??
            */
            if (0 == (stream & 0x7))
            {
                PRINT(ERR, "jpeg string busy\n");
                return -1;
            }
        }
    }

    if (0 == ulH264YuvAddr)                         /* ûʹκش󣬰Դ */
    {
        PRINT(ERR, "ulH264YuvAddr null\n");
        return 0;
    }

    w >>= 4;                                        /* 16Ϊλ */
    h >>= 4;

#if 1
    memcpy((void *)ulH264YuvAddr, src, len);        /* ʹʹ˶Ҳֻ追׸ */
#else
    ulCrcCnt = w * h;                               /* ʹcrc */
    ulCrcLen = ulCrcCnt << 2;
    ulCpyLen = len - ulCrcLen;

    memcpy((void *)ulH264YuvAddr, src, ulCpyLen);
    PRINT(INFO, "crc cpy\n");
    ulCrcSrc = (unsigned long)src + ulCpyLen;
    ulCrcDst = s_id_enc_crc_addr;
    for (i = 0; i < ulCrcCnt; i++)
    {
        write_reg(ulCrcDst, *(unsigned long *)ulCrcSrc);
        ulCrcDst += 4;
        ulCrcSrc += 4;
    }

    s_id_enc_crc_addr += 0x10000;
    if (s_id_enc_crc_addr > 0x52830000)
    {
        s_id_enc_crc_addr = 0x52800000;
    }
#endif

    /* дĿߣʱ */
    write_reg(0x54030008, (ch << 24) + (w << 8) + h);
    write_reg(0x5403000c, s_id_enc_timestamp++);

    for (i = 0; i < 3; i++)                         /* ʹܱ */
    {
        if (stream & (0x1 << i))                    /* str0:bit0, str1:bit1, str2:bit2 */
        {
            write_reg(0x54030010 + (i << 2), (1 << 28) + (25 << 8) + ulH264Index[i] + s_id_enc_bp_change);
        }
        else
        {
            write_reg(0x54030010 + (i << 2), 0);    /* ûʹܵӦд0 */
        }
    }

    s_id_enc_bp_change = 0;                         /* ı־λֻڵһ֡ʱ裬ﲻжֱд0 */

    if (ulJpegBit)                                  /* ʹjpeg(ʹulJpegIndexж) */
    {
        write_reg(0x5403001c, ulJpegBit | ulJpegIndex);
    }
    else
    {
        write_reg(0x5403001c, 0);                   /* ûʹܵд0 */
    }

    write_reg(0x54030000, (1 << 19) + (1 << 16));   /* ź */

    return 0;
}


/*
**  жһidԽĶʱ
*/
static void id_timer_handler(unsigned long v)
{
	if (s_id_running && id_frame_jiffies)           /* ֻidЧһڳʱж */
	{
		/* һαݲ10sΪidԽ */
		if ((jiffies - id_frame_jiffies) > ID_ACTIVE_TIME)
		{
			id_frame_jiffies = 0;                   /* ־λ */
			s_id_running = 0;                       /* ʾidԻûʼ */

			send_message(0xA5, NULL, 0, 1);         /* Ϣ֪ͨpcˣڶʱҪжϱ */
		}
	}

    id_timer.data = 0;                              /* һʱ */
    id_timer.function = id_timer_handler;
    id_timer.expires = jiffies + ID_TIMER_INTERVAL;
    add_timer(&id_timer);

    return;
}


/*
**  ʱ
**  jpegԴʱͨϷֵΪ0-15
**  ԴǣͨϷֵΪ0-16ʹaddrʾ
*/
static void yuv_timer_handler(unsigned long v)
{
    int ret;
    unsigned long *pulSrc;
    unsigned long ulType;
    unsigned long ulStream;
	unsigned long ulLength;
	unsigned long ulChannel;
	unsigned long ulWidth;
	unsigned long ulHeight;

    if (0 == s_id_yuv_valid || 0 == s_id_yuv_buffer)/* жǷ */
    {
        goto next_timer;
    }

	pulSrc = (unsigned long *)s_id_yuv_buffer;
	ulType = byte_swap4(pulSrc[1]);                 /* ͣ1ʾͨݣ3ʾԴ(jpeg)4ʾԤԴ */
	ulStream = byte_swap4(pulSrc[2]);               /* bit0-2ʾ0-2bit4-6ʾjepg0-2 */
	ulLength = byte_swap4(pulSrc[3]);               /* yuvݳ */
	ulChannel = byte_swap4(pulSrc[4]);              /* ͨ(ͨ0-16) */
	ulWidth = byte_swap4(pulSrc[5]);                /*  */
	ulHeight = byte_swap4(pulSrc[6]);               /* ߶ */

	if (3 == ulType)                                /* (jpeg)Դ */
	{
	    ret = h264_src(ulChannel, ulWidth, ulHeight, ulLength, ulStream, (void *)(s_id_yuv_buffer + 64));
	    if (ret != 0)                               /* ʧʱ */
	    {
	        goto next_timer;
	    }
	}
	else if (4 == ulType)                           /* ԤԴ */
	{
	    ret = preview_src(ulChannel, ulStream, ulWidth, ulHeight, ulLength, (void *)(s_id_yuv_buffer + 64));
	    if (ret != 0)
	    {
	        goto next_timer;
	    }
	}
	else if (5 == ulType)                           /* ƵԴ */
	{
	    ret = audio_src(ulStream, ulLength, ulWidth, ulHeight, (void *)(s_id_yuv_buffer + 64));
	    if (ret != 0)
	    {
	        goto next_timer;
	    }
	}
	else if (6 == ulType)                           /*  */
	{
	    ret = encpara_src(ulStream, ulLength, (unsigned long *)(s_id_yuv_buffer + 64));
	    if (ret != 0)
	    {
	        goto next_timer;
	    }
	}
	else if (7 == ulType)                           /* ԤԴʱID */
	{
	    ret = preview_id(ulLength, ulStream, ulWidth, ulHeight, (unsigned char *)(s_id_yuv_buffer + 64));
	    if (ret != 0)
	    {
	        goto next_timer;
	    }
	}
	else if (8 == ulType)                           /* ԤԴʱosd */
	{
	    ret = osd_src(ulLength, (void *)(s_id_yuv_buffer + 64));
	    if (ret != 0)
	    {
	        goto next_timer;
	    }
	}
	else if (9 == ulType)                           /* mask */
	{
        memcpy((void *)g_ulMaskAddr, (void *)(s_id_yuv_buffer + 64), ulLength);
	}
	else if (10 == ulType)                          /* ƴԴ */
	{
	    ret = patch_src(ulChannel, ulStream, ulLength, ulWidth, (void *)(s_id_yuv_buffer + 64));
	    if (ret != 0)
	    {
	        goto next_timer;
	    }
	}
	else if (11 == ulType)                          /* ƴosd */
	{
	    ret = patch_osd_data(ulLength, (void *)(s_id_yuv_buffer + 64));
	    if (ret != 0)
	    {
	        goto next_timer;
	    }
	}
	else if (12 == ulType)                          /* Դ */
	{
	    ret = std_src(ulChannel, ulStream, ulLength, (void *)(s_id_yuv_buffer + 64));
	    if (ret != 0)
	    {
	        goto next_timer;
	    }
	}
	else if (13 == ulType)                          /* osd */
	{
	    ret = std_osd_data(ulLength, (void *)(s_id_yuv_buffer + 64));
	    if (ret != 0)
	    {
	        goto next_timer;
	    }
	}
	else if (14 == ulType)                          /* 2DԴ */
	{
	    /* ulWidthʾഫֽ(pcδҪ4ֽڶ) */
	    ret = tde_src(ulChannel, ulStream, (ulLength - ulWidth), (void *)(s_id_yuv_buffer + 64));
	    if (ret != 0)
	    {
	        goto next_timer;
	    }
	}
	else if (15 == ulType)                          /* ŲԴ */
	{
	    ret = dec_src(ulChannel, ulStream, ulLength, (void *)(s_id_yuv_buffer + 64));
	    if (ret != 0)
	    {
	        goto next_timer;
	    }
	}
	else
	{
	    PRINT(ERR, "yuv unknown type 0x%lx\n", ulType);
	}

    s_id_yuv_valid = 0;                             /* yuv */
    write_reg(s_id_yuv_buffer, 0);

next_timer:
    yuv_timer.data = 0;                             /* һʱ */
    yuv_timer.function = yuv_timer_handler;
    yuv_timer.expires = jiffies + YUV_TIMER_INTERVAL;
    add_timer(&yuv_timer);

    if (s_id_aud_delay_swh)                         /* Ƶӳٿ */
    {
        s_id_aud_delay_swh--;
        if (0 == s_id_aud_delay_swh)
        {
            /* Խ */
            //write_reg(SPH_CTRL, read_reg(SPH_CTRL) | 0x2010001);
            write_reg(SPH_CTRL, read_reg(SPH_CTRL) | 0x2000000);
            write_reg(SPH_CTRL, read_reg(SPH_CTRL) | 0x0010001);
        }
    }

    if (s_id_pre_delay_swh)                         /* Ԥӳٿ */
    {
        s_id_pre_delay_swh--;
        if (0 == s_id_pre_delay_swh)
        {
            write_reg(0x61000140, 1);               /* Ԥ */
        }
    }

    return;
}


/*
**  yuvģע
*/
void yuv_exit(void)
{
    return;
}


/*
**  yuvģʼ
*/
int yuv_init(void)
{
    yuv_timer.data = 0;                             /* Դʱ */
    yuv_timer.function = yuv_timer_handler;
    yuv_timer.expires = jiffies + YUV_TIMER_INTERVAL;
    add_timer(&yuv_timer);

    id_timer.data = 0;                              /* IDԶʱ */
    id_timer.function = id_timer_handler;
    id_timer.expires = jiffies + ID_TIMER_INTERVAL;
    add_timer(&id_timer);

    PRINT(INFO, "yuv_init\n");

    return 0;
}
