/****************************************************************************/

/*
 *	ckuart.h -- CK510 for CK510EVB Board internal UART support defines.
 *
 *  (C) Copyright 2004, Li Chunqiang (chunqiang_li@c-sky.com)
 *  (C) Copyright 2004 Kang Sun <sunk@vlsi.zju.edu.cn>
 *	(C) Copyright 1999-2003, Greg Ungerer (gerg@snapgear.com)
 * 	(C) Copyright 2000, Lineo Inc. (www.lineo.com) 
 */

/****************************************************************************/
#ifndef ckuart_h
#define	ckuart_h
/****************************************************************************/

#include <linux/config.h>

/*
 *	Define the base address of the UARTS within the MBAR address
 *	space.
 */
#if (defined(CONFIG_CSKY) || defined(CONFIG_CK510EVB))
#define	CK510EVB_UART_BASE1		0x1000B000	/* Base address of UART1 */
#define	CK510EVB_UART_BASE2		0x1000C000	/* Base address of UART2 */
#endif


/*
 *	Define the CK510 for CK510EVB Board UART register set addresses.
 */
#define	CK510EVB_UART_RBR	0x03		/* Receive Buffer Register (8 bits, R) */
#define	CK510EVB_UART_THR	0x03		/* Transmit Holding Register (8 bits, W) */
#define	CK510EVB_UART_DLL	0x03		/* Divisor Latch(Low)  (8 bits, R/W) */
#define	CK510EVB_UART_IER	0x02		/* Interrupt Enable Register (8 bits, R/W) */
#define	CK510EVB_UART_DLH	0x02		/* Divisor Latch(High) (8 bits, R/W) */
#define	CK510EVB_UART_IIR	0x01		/* Interrupt Identity Register (8 bits, R) */
#define	CK510EVB_UART_FCR	0x01		/* fifo Countrol Register (8 bits, W) */
#define	CK510EVB_UART_LCR	0x00		/* Line Control Register (8 bits, R/W) */
#define	CK510EVB_UART_MCR	0x07		/* Modem Control Register (8 bits, W) */
#define	CK510EVB_UART_LSR	0x06		/* Line Status Register (8 bits, R) */
#define	CK510EVB_UART_MSR	0x05		/* Modem Status Register (8 bits, R/W) */

/*
 *	Define bit flags in Interrupt Enable Register (IER)
 */
#define	CK510EVB_UART_IER_EDSSI		0x08	/* Enable Modem Status Interrupt */
#define	CK510EVB_UART_IER_ELSI		0x04	/* Enable Receiver Line Status Interrupt */
#define	CK510EVB_UART_IER_ETHEI		0x02	/* Enable Transmitter Holding Register Empty Interrupt */
#define	CK510EVB_UART_IER_ERDAI		0x01	/* Enable Received Data Available Interrupt */


/*
 *	Define bit flags in Interrupt Identity Register (IIR)
 */
#define	CK510EVB_UART_IIR_IP		0x01	/* Interrupt Pending */
#define CK510EVB_UART_IIR_FIFOEN	0xc0          /* FIFO enable */
			/* Interrupt ID (3 bits) */
			/* = 011 Hightest Priority Interrupt - Receiver Line Status*/
			/* = 010 Second Priority Interrupt - Receiver data available */
			/* = 110 Second Priority Interrupt - Character time out indication */
			/* = 001 Third Priority Interrupt - Transmitter Holding register empty */
			/* = 000 Fourth Priority Interrupt - Modem status */
#define CK510EVB_UART_IIR_PENEN        0x00          /* Interrupt Pending enable */
#define CK510EVB_UART_IIR_LCR          0x06          /* LCR status interrupt */
#define CK510EVB_UART_IIR_RDA          0x04          /* Receive data available interrupt */
#define CK510EVB_UART_IIR_CTOUT        0x0c          /* character time out interrupt */
#define CK510EVB_UART_IIR_THRE         0x02          /* transmitter holding register empty */
#define CK510EVB_UART_IIR_MS           0x00          /* modem status interrupt */

/*
 *	Define bit flags FIFO Control Register (FCR)
 *	Receive FIFO Interrupt Trigger Level (2 bits)
 *	= 00=1 byte
 *	= 01=4 bytes
 *	= 10=8 bytes
 *	= 11=14 bytes
 */
#define CK510EVB_UART_FCR_FIFO1B       0x00          /* receive interrupt trigger level: 1 byte */
#define CK510EVB_UART_FCR_FIFO4B       0x40          /* receive interrupt trigger level: 4 bytes */
#define CK510EVB_UART_FCR_FIFO8B       0x80          /* receive interrupt trigger level: 8 bytes */
#define CK510EVB_UART_FCR_FIFO14B      0xc0          /* receive interrupt trigger level: 14 bytes */
	


/*
 *	Define bit flags in Line Control Register (LCR).
 */
#define	CK510EVB_UART_LCR_DLAEN		0x80	/* Divisor Latch Access bit */
#define	CK510EVB_UART_LCR_BC 	    0x40	/* Break Control */
#define	CK510EVB_UART_LCR_SP		0x20	/* Stick Parity */
#define	CK510EVB_UART_LCR_ESP		0x10	/* Even Parity */
#define	CK510EVB_UART_LCR_PEN		0x08	/* Parity Enable */
#define	CK510EVB_UART_LCR_STOP     	0x04	/* Specify the number of generated stop bits */
#define	CK510EVB_UART_LCR_WLEN6	    0x01	/* Data Word Length (2 bits) */
#define	CK510EVB_UART_LCR_WLEN7	    0x02	/* Data Word Length (2 bits) */
#define	CK510EVB_UART_LCR_WLEN8	    0x03	/* Data Word Length (2 bits) */
											/* 00 = 5 bits */
											/* 01 = 6 bits */
											/* 10 = 7 bits */
											/* 11 = 8 bits */

/*
 *	Define bit flags in the Line Status Register (LSR)
 */
#define CK510EVB_UART_LSR_FIFOERR        0x80    /* FIFO Error */
#define CK510EVB_UART_LSR_TEMT           0x40    /* Transmitter Empty */
#define CK510EVB_UART_LSR_THRE           0x20    /* Transmit Holding Register Empty */
#define CK510EVB_UART_LSR_BI             0x10    /* Break Interrupt */
#define CK510EVB_UART_LSR_FERR           0x08    /* Frame Error */
#define CK510EVB_UART_LSR_PERR           0x04    /* Parity Error */
#define CK510EVB_UART_LSR_OVRERR         0x02    /* Overrun Error */
#define CK510EVB_UART_LSR_DR             0x01    /* Data Ready */

#define CK510EVB_UART_LSR_RXERR (CK510EVB_UART_SR_FERR | CK510EVB_UART_SR_OVRERR | CK510EVB_UART_LSR_PERR)

/*
 *	Define	bit flags in the Modem Control register (MSR)
 */
#define	CK510EVB_UART_MCR_LB			0x10	/* Loopback */
#define	CK510EVB_UART_MCR_OUT2			0x08	/* Auxiliary output 2 */
#define	CK510EVB_UART_MCR_OUT1			0x04	/* Auxiliary ouput 1 */
#define	CK510EVB_UART_MCR_RTS			0x02	/* Request to send */
#define	CK510EVB_UART_MCR_DTR			0x01	/* Data Terminal Ready */

/*
 *	Define bit flags in the Modem Status Register (MSR)
 */
#define	CK510EVB_UART_MSR_DCD			0x80	/* Data Carrier Detect */
#define	CK510EVB_UART_MSR_RI			0x40	/* Ring In */
#define	CK510EVB_UART_MSR_DSR			0x20	/* Data Set Ready */
#define	CK510EVB_UART_MSR_CTS			0x10	/* Clear To Send*/
#define	CK510EVB_UART_MSR_DDCD			0x08	/* Delt Carrier Detect */
#define	CK510EVB_UART_MSR_TERI			0x04	/* Trailing Edge Ring Indicator */
#define	CK510EVB_UART_MSR_DDSR			0x02	/* Delta Data Set Ready */
#define	CK510EVB_UART_MSR_DDCLS			0x01	/* Delta Clear to send */
/****************************************************************************/


#define CK510EVB_UART_DIV				0x4              /* Baud divisor */
#endif	/* ckuart_h */
