/*
 *	ckgpio.h -- CK510EVB or CK1000EVB Programmable Interrupt Controller support.
 *
 *  (C) Copyright 2004, Li Chunqiang (chunqiang_li@c-sky.com)
 */



/****************************************************************************/
#ifndef	_ckgpio_h
#define	_ckgpio_h
/****************************************************************************/

#include <linux/config.h>

/***************************************************************************/
#if defined( CONFIG_CK510 )
/*
 *	Define the base address of the CKcore CK1000-EVB Board GPIO
 */
#define CKGPIO_BASE		0x45000000

#define CKGPIO_SET_OUT  0x01
#define CKGPIO_SET_IN   0x00

#define CKGPIO_MAX_IO   32

/* add by zxj 2009-05-20 */
#define CKGPIO_SEL          0x6000001C  /* gpio multiplexed */
#define CKGPIO_DIR_OFF      ( CKGPIO_BASE + 0x00 )
#define CKGPIO_OUT_OFF      ( CKGPIO_BASE + 0x04 )
#define CKGPIO_IN_OFF       ( CKGPIO_BASE + 0x08 )
#define CKGPIO_SET_OFF      ( CKGPIO_BASE + 0x10 )
#define CKGPIO_CLR_OFF      ( CKGPIO_BASE + 0x14 )
#define CKGPIO_INTEN_OFF    ( CKGPIO_BASE + 0x18 )
#define CKGPIO_INTST_OFF    ( CKGPIO_BASE + 0x1C )
#define CKGPIO_INTTR_OFF    ( CKGPIO_BASE + 0x20 )
#define CKGPIO_INTBO_OFF    ( CKGPIO_BASE + 0x24 )
#define CKGPIO_INTRI_OFF    ( CKGPIO_BASE + 0x28 )


/* function */

/*
 * the function set the gpio dir to output
 * index is the io index , range ( 0..31 )
 *
 * This MUST stay in a header, as it checks for -DMODULE
 */
static inline int ckgpio_set_out(int index)
{
    /* check the io index */
    if ( index >= CKGPIO_MAX_IO )
    {
        return -1;
    }
    
    *(volatile unsigned int *)CKGPIO_DIR_OFF |= ( 1 << index );
    
    return 0;
}

/*
 * the function set the gpio dir to input
 * index is the io index , range ( 0..31 )
 *
 * This MUST stay in a header, as it checks for -DMODULE
 */
static inline int ckgpio_set_in(int index)
{
    /* check the io index */
    if ( index >= CKGPIO_MAX_IO )
    {
        return -1;
    }
    
    *(volatile unsigned int *)CKGPIO_DIR_OFF &= ~( 1 << index );
    
    return 0;
}

/*
 * the function read the gpio value
 *
 * This MUST stay in a header, as it checks for -DMODULE
 */
static inline unsigned int ckgpio_read(void)
{
    return ( *(volatile unsigned int *)CKGPIO_IN_OFF );
}

/*
 * the function read the gpio value by selected
 *
 * This MUST stay in a header, as it checks for -DMODULE
 */
static inline int ckgpio_chk_bit(int index)
{
    
    /* check the io index */
    if ( index >= CKGPIO_MAX_IO )
    {
        return -1;
    }
    
    if ( *(volatile unsigned int *)CKGPIO_IN_OFF & ( 1 << index ) )
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

/*
 * the function wrtie the gpio value
 *
 * This MUST stay in a header, as it checks for -DMODULE
 */
static inline void ckgpio_write(unsigned int value)
{
    *(volatile unsigned int *)CKGPIO_OUT_OFF = value;
}

/*
 * the function wrtie the gpio value by selected
 *
 * This MUST stay in a header, as it checks for -DMODULE
 */
static inline int ckgpio_write_n(int index, int value)
{
    /* check the io index */
    if ( index >= CKGPIO_MAX_IO )
    {
        return -1;
    }
    
    if ( 0 == value )
    {
        *(volatile unsigned int *)CKGPIO_CLR_OFF |= ( 1 << index );
    }
    else
    {
        *(volatile unsigned int *)CKGPIO_SET_OFF |= ( 1 << index );
    }
    
    return 0;
}
#define		CKGPIO_SWPORTA_DR	0x00
#define		CKGPIO_SWPORTA_DDR	0x01
#define		CKGPIO_SWPORTB_DR	0x03
#define		CKGPIO_SWPORTB_DDR	0x04
#define		CKGPIO_PORTB_CTL	0x05
#define		CKGPIO_INT_EN		0x0c
#define		CKGPIO_INT_MASK		0x0d
#define		CKGPIO_INT_TYPE_LEVEL	0x0e
#define		CKGPIO_INT_POLARITY	0x0f
#define		CKGPIO_INT_STATUS	0x10
#define		CKGPIO_RAWINT_STATUS	0x11
#define		CKGPIO_PORTA_EOI	0x13
#define		CKGPIO_EXT_PORTA	0x14
#define		CKGPIO_EXT_PORTB	0x15
#define		CKGPIO_LS_SYNC		0x18


/*
 *	Define the offset(Index) of the Programmable Interrupt Controller registers
 */


#endif //#if (defined(CONFIG_CK510EVB) || defined(CONFIG_CK1000EVB))
/****************************************************************************/
#endif /* #ifndef	ckgpio_h */
