/*
 *	ckpic.h -- CK510EVB or CK1000EVB Programmable Interrupt Controller support.
 *
 *  (C) Copyright 2004, Li Chunqiang (chunqiang_li@c-sky.com)
 */



/****************************************************************************/
#ifndef	_ckpic_h
#define	_ckpic_h
/****************************************************************************/

#include <linux/config.h>

/***************************************************************************/
#if (defined(CONFIG_CK510EVB) || defined(CONFIG_CK1000EVB))
/*
 *	Define the base address of the CKcore CK510-EVB Board interrupt controller
 */
#if defined(CONFIG_CK510EVB)
#define CKPIC_BASE              0x10007000
#elif defined(CONFIG_CK1000EVB)
#define CKPIC_BASE		0x10017000
#endif

/*
 *	Define the offset(Index) of the Programmable Interrupt Controller registers
 */
#define CKPIC_ICR              0x00           // PIC interrupt control register(High 16bits)
#define CKPIC_ISR              0x00           // PIC interrupt status register(Low 16bits)
#define CKPIC_IFR              0x02           // PIC interrupt force register
#define CKPIC_IPR              0x03           // PIC interrupt pending register
#define CKPIC_NIER             0x04           // PIC normal interrupt enable register
#define CKPIC_NIPR             0x05           // PIC normal interrupt pending register
#define CKPIC_FIER             0x06           // PIC fast interrupt enable register
#define CKPIC_FIPR             0x07           // PIC fast interrupt pending register

#define CKPIC_PR0              0x10           // PIC prior register 0(High-High 8 bit)
#define CKPIC_PR1              0x10           // PIC prior register 1(High-Low 8 bit)
#define CKPIC_PR2              0x10           // PIC prior register 2(Low-High 8 bit)
#define CKPIC_PR3              0x10           // PIC prior register 3(Low-Low 8 bit)
#define CKPIC_PR4              0x11           // PIC prior register 4(High-High 8 bit)
#define CKPIC_PR5              0x11           // PIC prior register 5(High-Low 8 bit)
#define CKPIC_PR6              0x11           // PIC prior register 6(Low-High 8 bit)
#define CKPIC_PR7              0x11           // PIC prior register 7(Low-Low 8 bit)
#define CKPIC_PR8              0x12           // PIC prior register 8(High-High 8 bit)
#define CKPIC_PR9              0x12           // PIC prior register 9(High-Low 8 bit)
#define CKPIC_PR10             0x12           // PIC prior register 10(Low-High 8 bit)
#define CKPIC_PR11             0x12           // PIC prior register 11(Low-Low 8 bit)
#define CKPIC_PR12             0x13           // PIC prior register 12(High-High 8 bit)
#define CKPIC_PR13             0x13           // PIC prior register 13(High-Low 8 bit)
#define CKPIC_PR14             0x13           // PIC prior register 14(Low-High 8 bit)
#define CKPIC_PR15             0x13           // PIC prior register 15(Low-Low 8 bit)
#define CKPIC_PR16             0x14           // PIC prior register 16(High-High 8 bit)
#define CKPIC_PR17             0x14           // PIC prior register 17(High-Low 8 bit)
#define CKPIC_PR18             0x14           // PIC prior register 18(Low-High 8 bit)
#define CKPIC_PR19             0x14           // PIC prior register 19(Low-Low 8 bit)
#define CKPIC_PR20             0x15           // PIC prior register 20(High-High 8 bit)
#define CKPIC_PR21             0x15           // PIC prior register 21(High-Low 8 bit)
#define CKPIC_PR22             0x15           // PIC prior register 22(Low-High 8 bit)
#define CKPIC_PR23             0x15           // PIC prior register 23(Low-Low 8 bit)
#define CKPIC_PR24             0x16           // PIC prior register 24(High-High 8 bit)
#define CKPIC_PR25             0x16           // PIC prior register 25(High-Low 8 bit)
#define CKPIC_PR26             0x16           // PIC prior register 26(Low-High 8 bit)
#define CKPIC_PR27             0x16           // PIC prior register 27(Low-Low 8 bit)
#define CKPIC_PR28             0x17           // PIC prior register 28(High-High 8 bit)
#define CKPIC_PR29             0x17           // PIC prior register 29(High-Low 8 bit)
#define CKPIC_PR30             0x17           // PIC prior register 30(Low-High 8 bit)
#define CKPIC_PR31             0x17           // PIC prior register 31(Low-Low 8 bit)

/*
 *  Bit Definition for the PIC Interrupt control register
 */
#define CKPIC_ICR_AVE     0x80000000     // Fast and normal autovectored interrupt requests enable
#define CKPIC_ICR_FVE     0x40000000     // Fast vectored interrupt requests to have vector numbers
										 // separate from normal vectored interrupt request enable
#define CKPIC_ICR_ME      0x20000000     // Interrupt masking enable
#define	CKPIC_ICR_MFI	  0x10000000	 // Masking of fast interrupt rquests enable

/*
 * Bit definition for the PIC Normal Interrup Enable register
 */
#define CKPIC_NIER_NIE31	0x80000000	// Prioity=31 normal interrupt enable bit
#define CKPIC_NIER_NIE30	0x40000000	// Prioity=30 normal interrupt enable bit
#define CKPIC_NIER_NIE29	0x20000000	// Prioity=29 normal interrupt enable bit
#define CKPIC_NIER_NIE28	0x10000000	// Prioity=28 normal interrupt enable bit
#define CKPIC_NIER_NIE27	0x08000000	// Prioity=27 normal interrupt enable bit
#define CKPIC_NIER_NIE26	0x04000000	// Prioity=26 normal interrupt enable bit
#define CKPIC_NIER_NIE25	0x02000000	// Prioity=25 normal interrupt enable bit
#define CKPIC_NIER_NIE24	0x01000000	// Prioity=24 normal interrupt enable bit
#define CKPIC_NIER_NIE23	0x00800000	// Prioity=23 normal interrupt enable bit
#define CKPIC_NIER_NIE22	0x00400000	// Prioity=22 normal interrupt enable bit
#define CKPIC_NIER_NIE21	0x00200000	// Prioity=21 normal interrupt enable bit
#define CKPIC_NIER_NIE20	0x00100000	// Prioity=20 normal interrupt enable bit
#define CKPIC_NIER_NIE19	0x00080000	// Prioity=19 normal interrupt enable bit
#define CKPIC_NIER_NIE18	0x00040000	// Prioity=18 normal interrupt enable bit
#define CKPIC_NIER_NIE17	0x00020000	// Prioity=17 normal interrupt enable bit
#define CKPIC_NIER_NIE16	0x00010000	// Prioity=16 normal interrupt enable bit
#define CKPIC_NIER_NIE15	0x00008000	// Prioity=15 normal interrupt enable bit
#define CKPIC_NIER_NIE14	0x00004000	// Prioity=14 normal interrupt enable bit
#define CKPIC_NIER_NIE13	0x00002000	// Prioity=13 normal interrupt enable bit
#define CKPIC_NIER_NIE12	0x00001000	// Prioity=12 normal interrupt enable bit
#define CKPIC_NIER_NIE11	0x00000800	// Prioity=11 normal interrupt enable bit
#define CKPIC_NIER_NIE10	0x00000400	// Prioity=10 normal interrupt enable bit
#define CKPIC_NIER_NIE9		0x00000200	// Prioity=9 normal interrupt enable bit
#define CKPIC_NIER_NIE8		0x00000100	// Prioity=8 normal interrupt enable bit
#define CKPIC_NIER_NIE7		0x00000080	// Prioity=7 normal interrupt enable bit
#define CKPIC_NIER_NIE6		0x00000040	// Prioity=6 normal interrupt enable bit
#define CKPIC_NIER_NIE5		0x00000020	// Prioity=5 normal interrupt enable bit
#define CKPIC_NIER_NIE4		0x00000010	// Prioity=4 normal interrupt enable bit
#define CKPIC_NIER_NIE3		0x00000008	// Prioity=3 normal interrupt enable bit
#define CKPIC_NIER_NIE2		0x00000004	// Prioity=2 normal interrupt enable bit
#define CKPIC_NIER_NIE1		0x00000002	// Prioity=1 normal interrupt enable bit
#define CKPIC_NIER_NIE0		0x00000001	// Prioity=0 normal interrupt enable bit

/*
 * Bit definition for the PIC Fast Interrup Enable register
 */
#define CKPIC_FIER_FIE31	0x80000000	// Prioity=31 Fast interrupt enable bit
#define CKPIC_FIER_FIE30	0x40000000	// Prioity=30 Fast interrupt enable bit
#define CKPIC_FIER_FIE29	0x20000000	// Prioity=29 Fast interrupt enable bit
#define CKPIC_FIER_FIE28	0x10000000	// Prioity=28 Fast interrupt enable bit
#define CKPIC_FIER_FIE27	0x08000000	// Prioity=27 Fast interrupt enable bit
#define CKPIC_FIER_FIE26	0x04000000	// Prioity=26 Fast interrupt enable bit
#define CKPIC_FIER_FIE25	0x02000000	// Prioity=25 Fast interrupt enable bit
#define CKPIC_FIER_FIE24	0x01000000	// Prioity=24 Fast interrupt enable bit
#define CKPIC_FIER_FIE23	0x00800000	// Prioity=23 Fast interrupt enable bit
#define CKPIC_FIER_FIE22	0x00400000	// Prioity=22 Fast interrupt enable bit
#define CKPIC_FIER_FIE21	0x00200000	// Prioity=21 Fast interrupt enable bit
#define CKPIC_FIER_FIE20	0x00100000	// Prioity=20 Fast interrupt enable bit
#define CKPIC_FIER_FIE19	0x00080000	// Prioity=19 Fast interrupt enable bit
#define CKPIC_FIER_FIE18	0x00040000	// Prioity=18 Fast interrupt enable bit
#define CKPIC_FIER_FIE17	0x00020000	// Prioity=17 Fast interrupt enable bit
#define CKPIC_FIER_FIE16	0x00010000	// Prioity=16 Fast interrupt enable bit
#define CKPIC_FIER_FIE15	0x00008000	// Prioity=15 Fast interrupt enable bit
#define CKPIC_FIER_FIE14	0x00004000	// Prioity=14 Fast interrupt enable bit
#define CKPIC_FIER_FIE13	0x00002000	// Prioity=13 Fast interrupt enable bit
#define CKPIC_FIER_FIE12	0x00001000	// Prioity=12 Fast interrupt enable bit
#define CKPIC_FIER_FIE11	0x00000800	// Prioity=11 Fast interrupt enable bit
#define CKPIC_FIER_FIE10	0x00000400	// Prioity=10 Fast interrupt enable bit
#define CKPIC_FIER_FIE9		0x00000200	// Prioity=9 Fast interrupt enable bit
#define CKPIC_FIER_FIE8		0x00000100	// Prioity=8 Fast interrupt enable bit
#define CKPIC_FIER_FIE7		0x00000080	// Prioity=7 Fast interrupt enable bit
#define CKPIC_FIER_FIE6		0x00000040	// Prioity=6 Fast interrupt enable bit
#define CKPIC_FIER_FIE5		0x00000020	// Prioity=5 Fast interrupt enable bit
#define CKPIC_FIER_FIE4		0x00000010	// Prioity=4 Fast interrupt enable bit
#define CKPIC_FIER_FIE3		0x00000008	// Prioity=3 Fast interrupt enable bit
#define CKPIC_FIER_FIE2		0x00000004	// Prioity=2 Fast interrupt enable bit
#define CKPIC_FIER_FIE1		0x00000002	// Prioity=1 Fast interrupt enable bit
#define CKPIC_FIER_FIE0		0x00000001	// Prioity=0 Fast interrupt enable bit

#define enable_normal_irq(irq_id)            \
        ((volatile unsigned long *)(CKPIC_BASE))[CKPIC_NIER] |= (1 << (irq_id - 32));

#define disable_normal_irq(irq_id)          \
        ((volatile unsigned long *)(CKPIC_BASE))[CKPIC_NIER] &= ~(1 << (irq_id - 32));

#define enable_fast_irq(irq_id)            \
        ((volatile unsigned long *)(CKPIC_BASE))[CKPIC_FIER] |= (1 << (irq_id - 32));

#define disable_fast_irq(irq_id)          \
        ((volatile unsigned long *)(CKPIC_BASE))[CKPIC_FIER] &= ~(1 << (irq_id - 32));

#ifndef __ASSEMBLY__
/*
 *	Definition for the interrupt auto-vectoring support.
 */
extern void	ckcore_autovector(unsigned int vec);

#endif /* __ASSEMBLY__ */

#endif //#if (defined(CONFIG_CK510EVB) || defined(CONFIG_CK1000EVB))
/****************************************************************************/
#endif /* #ifndef	ckpic_h */
