/*
 *      ckpm.h -- CK1000EVB Power Management support.
 *
 *  (C) Copyright 2004, Li Chunqiang (chunqiang_li@c-sky.com)
 */



/****************************************************************************/
#ifndef _ckpm_h
#define _ckpm_h
/****************************************************************************/

#include <linux/config.h>

/***************************************************************************/
#if  (defined(CONFIG_CK1000EVB) && defined(CONFIG_CK1000EVB_VERSION101))
/*
 *      Define the base address of the CKcore CK1000-EVB Board GPIO
 */
#define CKPM_BASE             0x10008000

#define         CKPM_LPCR       0x00         // Low Power Control Register
#define         CKPM_SMCR       0x01         // Stop Mode Control Register
#define         CKPM_PCR        0x02         // PLL Control Register
#define         CKPM_PLTR       0x03         // PLL Lock Time Wait register
#define         CKPM_CRCR       0x04         // Clock Ratio control Register
#define         CKPM_CGCR       0x05         // Clock Gate Control Register
#define         CKPM_CGSR       0x06         // Clock Gate Status Register
#define         CKPM_INTM       0x07         // Interrupt Source Mask Register
#define         CKPM_INTR       0x08         // Interrupt Source register
#define         CKPM_DCNT       0x09         // CPU Wake-up Delay Counter Register


/*
 *  Low Power Control Register (LPCR)
 */
#define        CKPM_LPCR_PME    4            // 1: Power Management Enable.
#define        CKPM_LPCR_LPME   3            // 1: Low Power Management Enable.
#define        CKPM_LPCR_STOP   2            // 1: System Enter into Stop Mode.
#define        CKPM_LPCR_DOZE   1            // 1: System Enter into Doze Mode.
#define        CKPM_LPCR_WAIT   0            // 1: System Enter into Wait Mode.


/*
 *  Stop Mode Control Register (SMCR)
 */
#define        CKPM_SMCR_FC     0            // 1: Stop-Frequency Conversion; 0: Stop Mode-Sleep Mode

/*
 * PLL Control Register (PCR)
 */
#define        CKPM_PCR_PLLPD   17           // 1: PLL Power Down; 0: PLL Working Normally
#define        CKPM_PCR_PLLK    16           // 
//#define      CKPM_PCR_PLLN    15-8
//#define      CKPM_PCR_PLLM    7-0


/*
 * PLL Lock time Wait Time Reigster (PLTR)
 */
//#define      CKPM_PLTR_COUNTER    15-0



/*
 * Clock Ratio Control Register (CRCR)
 */


/*
 *   Clock Gate Control Register (CGCR)
 */
#define        CKPM_CGCR_MAC    13          // MAC
#define        CKPM_CGCR_DMAC   12          // DMAC
#define        CKPM_CGCR_LCDC   11          // LCDC
#define        CKPM_CGCR_SCI    10          // SCI
#define        CKPM_CGCR_I2C     9          // I2C
#define        CKPM_CGCR_SSI     8          // SSI
#define        CKPM_CGCR_UART3   7          // UART3
#define        CKPM_CGCR_UART2   6          // UART2
#define        CKPM_CGCR_UART1   5          // UART1
#define        CKPM_CGCR_UART0   4          // UART0
#define        CKPM_CGCR_GPIO    3          // GPIO
#define        CKPM_CGCR_TIMER   2          // TIMER
#define        CKPM_CGCR_RTC     1          // RTC
#define        CKPM_CGCR_WDT     0          // WATCH DOG

/*
 * Clock Gate Status Register (CGSR)
 */
#define        CKPM_CGSR_AHBAPB 17          // AHB/APB
#define        CKPM_CGSR_MMC    16          // MMC
#define        CKPM_CGSR_INTC   15          // INTC
#define        CKPM_CGSR_SCI    14          // CPU
#define        CKPM_CGSR_MAC    13          // MAC
#define        CKPM_CGSR_DMAC   12          // DMAC
#define        CKPM_CGSR_LCDC   11          // LCDC
#define        CKPM_CGSR_SCI    10          // SCI
#define        CKPM_CGSR_I2C     9          // I2C
#define        CKPM_CGSR_SSI     8          // SSI
#define        CKPM_CGSR_UART3   7          // UART3
#define        CKPM_CGSR_UART2   6          // UART2
#define        CKPM_CGSR_UART1   5          // UART1
#define        CKPM_CGSR_UART0   4          // UART0
#define        CKPM_CGSR_GPIO    3          // GPIO
#define        CKPM_CGSR_TIMER   2          // TIMER
#define        CKPM_CGSR_RTC     1          // RTC
#define        CKPM_CGSR_WDT     0          // WATCH DOG



/*
 * Interrupt Source Mask Register (INTM)
 */
#define        CKPM_INTM_ERROR   2          // Error Low Power mask
#define        CKPM_INTM_CPULP   1          // CPU to LP Interrupt Mask
#define        CKPM_INTM_COUNTER 0          // Counter Interrupt Mask

/*
 * Interrupt Source Register (INTR)
 */
#define        CKPM_INTR_ERROR   2          // Error Low Power Mask
#define        CKPM_INTR_CPULP   1          // CPU to LP Interrupt
#define        CKPM_INTR_COUNTER 0          // Counter Interrupt Source.


/*
 * Low Power Mode
 */
#define        CKPM_LPMODE_DOZE  1          // Power Management Low Power Mode - DOZE Mode
#define        CKPM_LPMODE_SLEEP 2          // Sleep of Stop Mode
#define        CKPM_LPMODE_FC    3          // Frequency Conversion of Stop Mode
#define        CKPM_LPMODE_WAIT  4          // Wait Mode



#endif //#if  (defined(CONFIG_CK1000EVB) && defined(CONFIG_CK1000EVB_VERSION101))
/****************************************************************************/
#endif /* #ifndef       ckpm_h */
