 /****************************************************************************/

/*
 *	cksim.h -- CKcore System Integration Module support.
 *
 *      (C) Copyright 2004, Kang Sun (sunk@vlsi.zju.edu.cn)
 *	(C) Copyright 1999-2003, Greg Ungerer (gerg@snapgear.com)
 * 	(C) Copyright 2000, Lineo Inc. (www.lineo.com) 
 *      (C) Copyright 2004, Kang Sun  (sunk@vlsi.zju.edu.cn)
 */

/****************************************************************************/
#ifndef	cksim_h
#define	cksim_h
/****************************************************************************/

#include <linux/config.h>


/*
 *	Include ck510 specific addresses.
 */
#if defined(CONFIG_CK510)
//#include <asm/ck510sim.h>
#endif


#define	CKSIM_BASE		0x0		/* Base address of SIM */
/* 
 *      Define the base address of the CKcore DH2004 Board interrupt controller 
 */
#define CKSIM_PIC_BASE              0x70000000

/*
 *      Define the offset of the Program Interrupt Controller registers
 */
#define CKSIM_PIC_MODE              0x00           /* PIC mode register    */
#define CKSIM_PIC_POL                 0x01
#define CKSIM_PIC_MASK              0x02           /* PIC mask register    */
#define CKSIM_PIC_VEC                 0x03           /* PIC vector register  */
#define CKSIM_PIC_COW               0x04           /* PIC control register */
#define CKSIM_PIC_PRI0               0x05           /* PIC prior register 0 */
#define CKSIM_PIC_PRI1               0x06           /* PIC prior register 1 */
#define CKSIM_PIC_PRI2               0x07           /* PIC prior register 2 */
#define CKSIM_PIC_PRI3               0x08           /* PIC prior register 3 */
#define CKSIM_PIC_PRI4               0x09           /* PIC prior register 4 */
#define CKSIM_PIC_PRI5               0x0a           /* PIC prior register 5 */
#define CKSIM_PIC_PRI6               0x0b           /* PIC prior register 6 */
#define CKSIM_PIC_PRI7               0x0c           /* PIC prior register 7 */
#define CKSIM_PIC_COW1             0x0d          


#define CKSIM_PIC_EDGE0          0x0001           /* for or, Set interrupt  Edge triggered, bit 0 */
#define CKSIM_PIC_EDGE1          0x0002           /* bit 1 */
#define CKSIM_PIC_EDGE2          0x0004           /* bit 2 */
#define CKSIM_PIC_EDGE3          0x0008           /* bit 3 */
#define CKSIM_PIC_EDGE4          0x0010           /* bit 4 */
#define CKSIM_PIC_EDGE5          0x0020           /* bit 5 */
#define CKSIM_PIC_EDGE6          0x0040           /* bit 6 */
#define CKSIM_PIC_EDGE7          0x0080           /* bit 7 */
#define CKSIM_PIC_EDGE8          0x0100           /* bit 8 */
#define CKSIM_PIC_EDGE9          0x0200           /* bit 9 */
#define CKSIM_PIC_EDGE10         0x0400           /* bit 10 */
#define CKSIM_PIC_EDGE11         0x0800           /* bit 11 */
#define CKSIM_PIC_EDGE12         0x1000           /* bit 12 */
#define CKSIM_PIC_EDGE13         0x2000           /* bit 13 */
#define CKSIM_PIC_EDGE14         0x4000           /* bit 14 */
#define CKSIM_PIC_EDGE15         0x8000           /* bit 15 */
#define CKSIM_PIC_EDGE16          0x00010000           /* bit 16 */
#define CKSIM_PIC_EDGE17          0x00020000           /* bit 17 */
#define CKSIM_PIC_EDGE18          0x00040000           /* bit 18 */
#define CKSIM_PIC_EDGE19          0x00080000           /* bit 19 */
#define CKSIM_PIC_EDGE20          0x00100000           /* bit 20*/
#define CKSIM_PIC_EDGE21          0x00200000           /* bit 21 */
#define CKSIM_PIC_EDGE22          0x00400000           /* bit 22 */
#define CKSIM_PIC_EDGE23          0x00800000           /* bit 23*/
#define CKSIM_PIC_EDGE24          0x01000000           /* bit 24 */
#define CKSIM_PIC_EDGE25          0x02000000           /* bit 25 */
#define CKSIM_PIC_EDGE26         0x04000000           /* bit 26 */
#define CKSIM_PIC_EDGE27         0x08000000           /* bit 27 */
#define CKSIM_PIC_EDGE28         0x10000000           /* bit 28 */
#define CKSIM_PIC_EDGE29         0x20000000           /* bit 29 */
#define CKSIM_PIC_EDGE30         0x40000000           /* bit 30 */
#define CKSIM_PIC_EDGE31         0x80000000           /* bit 31 */


/*
 *     Bit Definition for the PIC Interrupt Trigger Mode register
 */
#define CKSIM_PIC_POS0           0x1          /* for or, Set interrupt  Pose edge/level sensitive, bit 0 */
#define CKSIM_PIC_POS1           0x2          /* bit 1 */
#define CKSIM_PIC_POS2           0x4          /* bit 2 */
#define CKSIM_PIC_POS3           0x8          /* bit 3 */
#define CKSIM_PIC_POS4           0x10         /* bit 4 */
#define CKSIM_PIC_POS5           0x20         /* bit 5 */
#define CKSIM_PIC_POS6           0x40         /* bit 6 */
#define CKSIM_PIC_POS7           0x80         /* bit 7 */
#define CKSIM_PIC_POS8           0x100         /* bit 8 */
#define CKSIM_PIC_POS9           0x200         /* bit 9 */
#define CKSIM_PIC_POS10          0x400         /* bit 10 */
#define CKSIM_PIC_POS11          0x800         /* bit 11 */
#define CKSIM_PIC_POS12          0x1000        /* bit 12 */
#define CKSIM_PIC_POS13          0x2000        /* bit 13 */
#define CKSIM_PIC_POS14          0x4000        /* bit 14 */
#define CKSIM_PIC_POS15          0x8000        /* bit 15 */
#define CKSIM_PIC_POS16           0x10000         /* bit 16 */
#define CKSIM_PIC_POS17           0x20000          /* bit 17 */
#define CKSIM_PIC_POS18           0x40000          /* bit 18 */
#define CKSIM_PIC_POS19           0x80000          /* bit 19*/
#define CKSIM_PIC_POS20           0x100000         /* bit 20 */
#define CKSIM_PIC_POS21           0x200000         /* bit 21*/
#define CKSIM_PIC_POS22           0x400000         /* bit 22 */
#define CKSIM_PIC_POS23           0x800000         /* bit 23 */
#define CKSIM_PIC_POS24           0x1000000         /* bit 24 */
#define CKSIM_PIC_POS25           0x2000000         /* bit 25 */
#define CKSIM_PIC_POS26          0x4000000         /* bit 26 */
#define CKSIM_PIC_POS27          0x8000000         /* bit 27 */
#define CKSIM_PIC_POS28          0x10000000        /* bit 28 */
#define CKSIM_PIC_POS29          0x20000000        /* bit 29 */
#define CKSIM_PIC_POS30          0x40000000        /* bit 30 */
#define CKSIM_PIC_POS31          0x80000000        /* bit 31 */


/*
 *     Bit Definition for the PIC Interrupt Mask register
 */
#define CKSIM_INT0_MASK          0x1           /* mask of CA Slave interrupt */
#define CKSIM_INT1_MASK          0x2           /* mask of MAC Slave interrupt */
#define CKSIM_INT2_MASK          0x4           /* mask of IDE interrupt */
#define CKSIM_INT3_MASK          0x8           /* mask of USB interrupt */
#define CKSIM_INT4_MASK          0x10           /* mask of timer0 interrupt */
#define CKSIM_INT5_MASK          0x20           /* mask of timer1 or timer0 and timer1 cascade interrupt */
#define CKSIM_INT6_MASK          0x40           /* mask of timer2 interrupt */
#define CKSIM_INT7_MASK          0x80           /* mask of timer3 interrupt or timer2 and timer3 cascade interrupt */
#define CKSIM_INT8_MASK          0x100           /* Reserved */ 
#define CKSIM_INT9_MASK          0x200           /* mask of Smart Card interrupt */  
#define CKSIM_INT10_MASK         0x400           /* mask of I2C interrupt */
#define CKSIM_INT11_MASK         0x800           /* mask of UART interrupt */
#define CKSIM_INT12_MASK         0x1000           /* mask of iRDA interrupt */
#define CKSIM_INT13_MASK         0x2000           /* mask of Keyboard interrupt */
#define CKSIM_INT14_MASK         0x4000           /* mask of GPIO0 interrupt */
#define CKSIM_INT15_MASK         0x8000           /* mask of GPIO1 interrupt */
#define CKSIM_INT16_MASK          0x10000           /*  */
#define CKSIM_INT17_MASK          0x20000           /* */
#define CKSIM_INT18_MASK          0x40000           /* */
#define CKSIM_INT19_MASK          0x80000           /*  */
#define CKSIM_INT20_MASK          0x100000           /*  */
#define CKSIM_INT21_MASK          0x200000           /* */
#define CKSIM_INT22_MASK          0x400000           /*  */
#define CKSIM_INT23_MASK          0x800000           /*  */
#define CKSIM_INT24_MASK          0x1000000           /*  */ 
#define CKSIM_INT25_MASK          0x2000000           /*  */  
#define CKSIM_INT26_MASK         0x4000000           /*  */
#define CKSIM_INT27_MASK         0x8000000           /*  */
#define CKSIM_INT28_MASK         0x10000000           /*  */
#define CKSIM_INT29_MASK         0x20000000           /*  */
#define CKSIM_INT30_MASK         0x40000000           /*  */
#define CKSIM_INT31_MASK         0x80000000           /*  */
#define CKSIM_PIC_MASKALL        0xffffffff           /* for or, mask all interrupt */


/*
 *     Bit Definition for the PIC Interrupt Control Register
 */
//#define CKSIM_COW_FLOW         0x10             /* Set num 0-4 as fast interrupt */
#define CKSIM_COW_FEOI          0x08             /* Endo of fast interrupt */
#define CKSIM_COW_EOI            0x04             /* for or, End of interrupt */ 
//#define CKSIM_COW_AVEC          0x02             /* for or, use autovectored */
//#define CKSIM_COW_PRO            0x01             /* for or, use custom interrupt priority */
#define CKSIM_COW_MD1            0x42             /**/
#define CKSIM_COW_MD2            0x12             /**/

#ifndef __ASSEMBLY__
/*
 *	Definition for the interrupt auto-vectoring support.
 */
extern void	ckcore_autovector(unsigned int vec);

#define ckcore_getimr()            \
        ((volatile unsigned long *)(CKSIM_PIC_BASE))[CKSIM_PIC_MASK]

#define ckcore_setimr(imr)          \
        ((volatile unsigned long *)(CKSIM_PIC_BASE))[CKSIM_PIC_MASK] |= (imr)
#endif /* __ASSEMBLY__ */
/****************************************************************************/
#endif	/* cksim_h */
