#ifndef M68KNOMMU_PCI_H
#define	M68KNOMMU_PCI_H

//#include <asm-m68k/pci.h>
#include <asm/types.h>
struct scatterlist {
	char		*address;	/* virtual address		 */
	struct page	*page;		/* buffer page			 */
	unsigned int	offset;		/* buffer address		 */
	dma_addr_t	dma_address;	/* dma address			 */
	unsigned int	length;		/* length			 */
};

#define pcibios_assign_all_busses()	0
#define pcibios_scan_all_fns()		0
/* Return the index of the PCI controller for device PDEV. */
#define pci_controller_num(PDEV)	(0)
#define PCI_DMA_BUS_IS_PHYS		(1)
/*
 * These macros should be used after a pci_map_sg call has been done
 * to get bus addresses of each of the SG entries and their lengths.
 * You should only work with the number of sg entries pci_map_sg
 * returns, or alternatively stop on the first sg_dma_len(sg) which
 * is 0.
 */
#define sg_dma_address(sg)      ((sg)->dma_address)
#define sg_dma_len(sg)          ((sg)->length)

#define ISA_DMA_THRESHOLD (0xffffffff)
/*
 *	These are pretty much arbitary with the CoMEM implementation.
 *	We have the whole address space to ourselves.
 */
#define PCIBIOS_MIN_IO		0x100
#define PCIBIOS_MIN_MEM		0x00100000

/* Free and unmap a consistent DMA buffer.
 * cpu_addr is what was returned from pci_alloc_consistent,
 * size must be the same as what as passed into pci_alloc_consistent,
 * and likewise dma_addr must be the same as what *dma_addrp was set to.
 *
 * References to the memory and mappings associated with cpu_addr/dma_addr
 * past this call are illegal.
 */
extern inline void
pci_free_consistent(struct pci_dev *hwdev, size_t size, void *vaddr,
		    dma_addr_t dma_handle)
{
	consistent_free(vaddr, size, dma_handle);
}
/*
 *  linux/include/asm-arm/mach/pci.h
 *
 *  Copyright (C) 2000 Russell King
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
struct hw_pci {
	/* Initialise the hardware */
	void		(*init)(void *);

	/* Setup bus resources */
	void		(*setup_resources)(struct resource **);

	/*
	 * This is the offset of PCI memory base registers
	 * to physical memory.
	 */
	unsigned long	mem_offset;

	/* IRQ swizzle */
	u8		(*swizzle)(struct pci_dev *dev, u8 *pin);

	/* IRQ mapping */
	int		(*map_irq)(struct pci_dev *dev, u8 slot, u8 pin);
};


/*
 * Return whether the given PCI device DMA address mask can
 * be supported properly.  For example, if your device can
 * only drive the low 24-bits during PCI bus mastering, then
 * you would pass 0x00ffffff as the mask to this function.
 */
static inline int pci_dma_supported(struct pci_dev *hwdev, u64 mask)
{
	/*
	 * we fall back to GFP_DMA when the mask isn't all 1s,
	 * so we can't guarantee allocations that must be
	 * within a tighter range than GFP_DMA..
	 */
#ifdef CONFIG_ISA
	if (mask < 0x00ffffff)
		return 0;
#endif

	return 1;
}
/* Map a single buffer of the indicated size for DMA in streaming mode.
 * The 32-bit bus address to use is returned.
 *
 * Once the device is given the dma address, the device owns this memory
 * until either pci_unmap_single or pci_dma_sync_single is performed.
 */
extern inline dma_addr_t
pci_map_single(struct pci_dev *hwdev, void *ptr, size_t size, int direction)
{
	consistent_sync(ptr, size, direction);
	return virt_to_bus(ptr);
	
}
/* Unmap a single streaming mode DMA translation.  The dma_addr and size
 * must match what was provided for in a previous pci_map_single call.  All
 * other usages are undefined.
 *
 * After this call, reads by the cpu to the buffer are guarenteed to see
 * whatever the device wrote there.
 */
extern inline void
pci_unmap_single(struct pci_dev *hwdev, dma_addr_t dma_addr, size_t size, int direction)
{
	/* nothing to do */
}
/* Map a set of buffers described by scatterlist in streaming
 * mode for DMA.  This is the scather-gather version of the
 * above pci_map_single interface.  Here the scatter gather list
 * elements are each tagged with the appropriate dma address
 * and length.  They are obtained via sg_dma_{address,length}(SG).
 *
 * NOTE: An implementation may be able to use a smaller number of
 *       DMA address/length pairs than there are SG table elements.
 *       (for example via virtual mapping capabilities)
 *       The routine returns the number of addr/length pairs actually
 *       used, at most nents.
 *
 * Device ownership issues as mentioned above for pci_map_single are
 * the same here.
 */
extern inline int
pci_map_sg(struct pci_dev *hwdev, struct scatterlist *sg, int nents, int direction)
{
	int i;

	for (i = 0; i < nents; i++, sg++) {
		sg->dma_address = virt_to_bus(sg->address);
	/*	if ((sg->page)&&(!sg->dma_address))  
		{
			sg->address = (char *)(page_address(sg->page));
			sg->dma_address = (dma_addr_t)(sg->address);
		}*/
	}

	return nents;
}

/* Unmap a set of streaming mode DMA translations.
 * Again, cpu read rules concerning calls here are the same as for
 * pci_unmap_single() above.
 */
extern inline void
pci_unmap_sg(struct pci_dev *hwdev, struct scatterlist *sg, int nents, int direction)
{
	/* nothing to do */
}
/* Make physical memory consistent for a single
 * streaming mode DMA translation after a transfer.
 *
 * If you perform a pci_map_single() but wish to interrogate the
 * buffer using the cpu, yet do not wish to teardown the PCI dma
 * mapping, you must call this function before doing so.  At the
 * next point you give the PCI dma address back to the card, the
 * device again owns the buffer.
 */
extern inline void
pci_dma_sync_single(struct pci_dev *hwdev, dma_addr_t dma_handle, size_t size, int direction)
{
}

/* Make physical memory consistent for a set of streaming
 * mode DMA translations after a transfer.
 *
 * The same as pci_dma_sync_single but for a scatter-gather list,
 * same rules and usage.
 */
extern inline void
pci_dma_sync_sg(struct pci_dev *hwdev, struct scatterlist *sg, int nelems, int direction)
{
	int i;

	for (i = 0; i < nelems; i++, sg++)
		;
}

/* This is always fine. */
#define pci_dac_dma_supported(pci_dev, mask)	(1)
# define machine_is_personal_server()	(machine_arch_type == MACH_TYPE_PERSONAL_SERVER)
#define MACH_TYPE_PERSONAL_SERVER      17


#endif
