#ifndef _M68KNOMMU_PGALLOC_H
#define _M68KNOMMU_PGALLOC_H

/*
 * Copyright (C) 2000 Lineo, David McCullough <davidm@lineo.com>
 * Copyright (C) 2001 Lineo, Greg Ungerer <gerg@snapgear.com>
 */

#include <asm/setup.h>
#include <asm/virtconvert.h>

/*
 * Cache handling functions
 */

extern inline void __flush_cache_all(void)
{
	register long __b;
 
	/* add by zxj 2009-10-12 */
	#if CONFIG_CK510_DATA_CACHE_WB
		__asm__ __volatile__ ("movi	%0, 0x33\n\t"
	#else
		//*(unsigned char *)(0x10015000) = 'a';
		__asm__ __volatile__ ("movi	%0, 0x13\n\t"
	#endif
                        "mtcr	%0, cr17"
                        : "=r" (__b)); 
}

/*
 * Instruction Cache handling functions
 */
static inline void __flush_icache(void)
{
  register long __b;
  __asm__ __volatile__ ("movi	%0, 0x11\n\t"
                        "mtcr	%0, cr17"
                        : "=r" (__b)); 
}

/*
 * Data Cache handling functions
 */
static inline void __flush_dcache(void)
{
	register long __b;
	
	/* add by zxj 2009-10-12 */
	#if CONFIG_CK510_DATA_CACHE_WB
		__asm__ __volatile__ ("movi	%0, 0x32\n\t"
	#else
		//*(unsigned char *)(0x10015000) = 'd';
		__asm__ __volatile__ ("movi	%0, 0x12\n\t"
	#endif
                        "mtcr	%0, cr17"
                        : "=r" (__b)); 
}
#define flush_cache_all()			__flush_cache_all()
#define flush_cache_mm(mm)			__flush_cache_all()
#define flush_cache_range(mm, start, end)	__flush_cache_all()
#define flush_cache_page(vma, vmaddr)		__flush_cache_all()
#define flush_page_to_ram(page)			__flush_cache_all()
#define flush_dcache_page(page)			__flush_dcache()
#define flush_icache_range(start, end)		__flush_icache()
#define flush_icache_user_range(vma,pg,adr,len) __flush_icache()
#define flush_icache_page(vma,pg)		__flush_icache()
#define flush_icache()				__flush_icache()

/*
 * DAVIDM - the rest of these are just so I can check where they happen
 */

/*
 * flush all user-space atc entries.
 */
static inline void __flush_tlb(void)
{
	BUG();
}

static inline void __flush_tlb_one(unsigned long addr)
{
	BUG();
}

#define flush_tlb() __flush_tlb()

/*
 * flush all atc entries (both kernel and user-space entries).
 */
static inline void flush_tlb_all(void)
{
	BUG();
}

static inline void flush_tlb_mm(struct mm_struct *mm)
{
	BUG();
}

static inline void flush_tlb_page(struct vm_area_struct *vma, unsigned long addr)
{
	BUG();
}

static inline void flush_tlb_range(struct mm_struct *mm,
				   unsigned long start, unsigned long end)
{
	BUG();
}

extern inline void flush_tlb_kernel_page(unsigned long addr)
{
	BUG();
}

extern inline void flush_tlb_pgtables(struct mm_struct *mm,
				      unsigned long start, unsigned long end)
{
	BUG();
}

#endif /* _M68KNOMMU_PGALLOC_H */
