#ifndef _CKCORENOMMU_SYSTEM_H
#define _CKCORENOMMU_SYSTEM_H

#include <linux/config.h> /* get configuration macros */
#include <linux/linkage.h>
#include <asm/segment.h>
#include <asm/entry.h>

#define prepare_to_switch()	do { } while(0)

/*
 * switch_to(n) should switch tasks to task ptr, first checking that
 * ptr isn't the current task, in which case it does nothing.  This
 * also clears the TS-flag if the task we switched to has used the
 * math co-processor latest.
 */
/*
 * switch_to() saves the extra registers, that are not saved
 * automatically by SAVE_SWITCH_STACK in resume(), ie. d0-d5 and
 * a0-a1. Some of these are used by schedule() and its predecessors
 * and so we might get see unexpected behaviors when a task returns
 * with unexpected register values.
 *
 * syscall stores these registers itself and none of them are used
 * by syscall after the function in the syscall has been called.
 *
 * Beware that resume now expects *next to be in d1 and the offset of
 * tss to be in a1. This saves a few instructions as we no longer have
 * to push them onto the stack and read them back right after.
 *
 * 02/17/96 - Jes Sorensen (jds@kom.auc.dk)
 *
 * Changed 96/09/19 by Andreas Schwab
 * pass prev in a0, next in a1, offset of tss in d1, and whether
 * the mm structures are shared in d2 (to avoid atc flushing).
 */

/* r7 savet the pointer to last task struct */
asmlinkage void resume(void);
#define switch_to(prev,next,last) { \
  register void *_prev __asm__ ("r2") = (prev);                                 \
  register void *_next __asm__ ("r3") = (next);                                 \
  register void *_last;								\
  __asm__ __volatile__(								\
			"jbsr " SYMBOL_NAME_STR(resume) "\n\t"           	\
			"mov	r7, %0\n\t"					\
		       : "=r" (_last)						\
		       : "r" (_prev),						\
			 "r" (_next)						\
		       : "r2", "r2", "r3");	                                \
  (last) = _last; 								\
}

#ifdef CONFIG_GDBSIM
 
#define __sti()                     \
        __asm__ __volatile__ (      \
	        "mfcr r1, psr\n\t"  \
	        "mtcr r1, psr"      \
	        : : : "r1"          \
        )

#define __cli()                     \
        __asm__ __volatile__ (      \
	        "mfcr r1, psr \n\t" \
	        "mtcr r1, psr \n\t" \
		: : : "r1"          \
        )

#define __save_flags(x)             \
        __asm__ __volatile__(       \
                "mfcr %0, psr"      \
                : "=r" (x)          \
        )

#define __restore_flags(x)          \
        __asm__ __volatile__(       \
                "mtcr %0, psr"      \
                : : "r" (x)          \
                )
#else


#if 0
#define __sti()                     \
        __asm__ __volatile__ (      \
                "mfcr r1, psr \n\t" \
                "bseti r1, 6  \n\t" \
                "bseti r1, 4  \n\t" \
                "mtcr r1, psr"      \
                : : : "r1"          \
        )

#define __cli()                     \
        __asm__ __volatile__ (      \
                "mfcr r1, psr\n\t"  \
                "bclri r1, 6\n\t"   \
                "bclri r1, 4\n\t"   \
                "mtcr r1, psr\n\t"  \
                : : : "r1"          \
        ) 

#define __save_flags(x)             \
        __asm__ __volatile__(       \
                "mfcr %0, psr"      \
                : "=r" (x)          \
                )


#define __restore_flags(x)          \
        __asm__ __volatile__(       \
                "mtcr %0, psr"      \
                : : "r" (x)         \
                )
#else

/* mdfy by zxj 2009-09-14 */
#define __sti()                     \
        __asm__ __volatile__ (      \
                "psrset ee, ie \n\t" \
                "psrset fe  \n\t" \
        )

#define __cli()                     \
        __asm__ __volatile__ (      \
                "psrclr ee, ie \n\t" \
                "psrclr fe  \n\t" \
        ) 

#define __save_flags(x)             \
        __asm__ __volatile__(       \
                "mfcr %0, psr"      \
                : "=r" (x)          \
                )


#define __restore_flags(x)          \
        __asm__ __volatile__(       \
                "mtcr %0, psr"      \
                : : "r" (x)         \
                )


#endif
#endif

#define	__save_and_cli(x) do { save_flags(x); cli(); } while(0) 
#define	__save_and_sti(x) do { save_flags(x); sti(); } while(0) 

#define iret() __asm__ __volatile__ ("rte": : :"memory", "sp", "cc")

/* For spinlocks etc */
#define local_irq_save(x)	__save_and_cli(x)
#define local_irq_set(x)	__save_and_sti(x)
#define local_irq_restore(x)	__restore_flags(x)
#define local_irq_disable()	__cli()
#define local_irq_enable()	__sti()

#define cli()			__cli()
#define sti()			__sti()
#define save_flags(x)		__save_flags(x)
#define restore_flags(x)	__restore_flags(x)
#define save_and_cli(x)	__save_and_cli(x)
#define save_and_set(x)	__save_and_sti(x)

/*
 * Force strict CPU ordering.
 * Not really required on m68k...
 */
#define nop()  asm volatile ("nop"::)
#define mb()   asm volatile (""   : : :"memory")
#define rmb()  asm volatile (""   : : :"memory")
#define wmb()  asm volatile (""   : : :"memory")
#define set_mb(var, value)     do { var = value; mb(); } while (0)
#define set_wmb(var, value)    do { var = value; wmb(); } while (0)

#ifdef CONFIG_SMP
#define smp_mb()	mb()
#define smp_rmb()	rmb()
#define smp_wmb()	wmb()
#else
#define smp_mb()	barrier()
#define smp_rmb()	barrier()
#define smp_wmb()	barrier()
#endif

#define xchg(ptr,x) ((__typeof__(*(ptr)))__xchg((unsigned long)(x),(ptr),sizeof(*(ptr))))
#define tas(ptr) (xchg((ptr),1))

struct __xchg_dummy { unsigned long a[100]; };
#define __xg(x) ((volatile struct __xchg_dummy *)(x))

static inline unsigned long __xchg(unsigned long x, volatile void * ptr, int size)
{
  unsigned long tmp, flags;

  save_flags(flags);
  cli();

  switch (size) {
  case 1:
    __asm__ __volatile__
    ("ldb %0, %2\n\t"
     "stb %1, %2"
     : "=&r" (tmp) : "r" (x), "m" (*__xg(ptr)) : "memory");
    break;
  case 2:
    __asm__ __volatile__
    ("ldh %0, %2\n\t"
     "sth %1, %2"
    : "=&r" (tmp) : "r" (x), "m" (*__xg(ptr)) : "memory");
    break;
  case 4:
    __asm__ __volatile__
    ("ldw %0, %2\n\t"
     "stw %1,%2"
    : "=&r" (tmp) : "r" (x), "m" (*__xg(ptr)) : "memory");
    break;
  }
  restore_flags(flags);
  return tmp;
}


#define HARD_RESET_NOW()


#endif /* _CKCORENOMMU_SYSTEM_H */
