/*
 * include/linux/debug.h
 *
 * (C) Copyright 2004 to 2004 ZHEJIANG DAHUA INFORMATION TECHNOLOGY STOCK 
 * CO.,LTD.
 *
 * Jul 14, 2004	Tim Yu File created.
 *
 * Debug header file.
 */

#ifndef	_DEBUG_H_
#define	_DEBUG_H_

#include <linux/config.h>
#if defined(MODVERSIONS)
#include <linux/modversions.h>
#endif
#include <linux/kernel.h>

/************************************************************************
 * Basic type defines
 ************************************************************************/
#define	DEBUG_ENABLE		1

#if (0)
typedef	unsigned char		tU1;
typedef	unsigned short int	tU2;
typedef	unsigned long  int	tU4;
typedef	unsigned long  long	tU8;
typedef	unsigned int		tUi;
typedef	signed	 char		tS1;
typedef	signed	 short int	tS2;
typedef	signed	 long  int	tS4;
typedef	signed	 long  long	tS8;
typedef	signed	 int		tSi;
#endif

/************************************************************************
 * Address label for debugging
 ************************************************************************/
#define	HERE(x)		\
__asm__ __volatile__(__FUNCTION__ "_HERE_" #x ": .global " __FUNCTION__ "_HERE_" #x)

/************************************************************************
 * Debugging macros
 ************************************************************************/
#if	(DEBUG_ENABLE && MODULE_DEBUG)
#define	PINFO(x)	do { printk x ; } while (0)
#define	PDBUG(x)	do { printk("%s%s%s: ",__FILE__, __FUNCTION__, \						__LINE__); printk x;	 } while (0)
#define	PENTER()	do { printk("%s: Enter\n",__FUNCTION__); } while (0)
#define	PIN()		do { printk("%s: Enter\n",__FUNCTION__); } while (0)
#define	POUT()		do { printk("%s: Out\n",__FUNCTION__);   } while (0)
#define	PFUNC(x)	do { ;					 } while (0)
#define	PERR(x)		do { printk("Err: "); printk x ;	 } while (0)
#else
#define	PINFO(x)	do ; while (0)
#define	PENTER()	do ; while (0)
#define	PDBUG(x)	do ; while (0)
#define	PIN()		do ; while (0)
#define	POUT()		do ; while (0)
#define	PFUNC(x)	do ; while (0)
#define	PERR(x)		do ; while (0)
#endif

/************************************************************************
 * the macros only for pnx1500 tmm programs
 ************************************************************************/
#ifdef	DPF
#undef	DPF
#endif
#ifdef	DBG_ASSERT 
#undef	DBG_ASSERT
#endif
#if	(DEBUG_ENABLE && MODULE_DEBUG)
#define DPF(x, y)	do { if(!x){ printk y ;}else ; } while (0)
#define DPRINTF(x)	do { printk x ; } while (0)
#define	DBG_ASSERT(x)	do { x; } while (0)
#else
#define	DPF(x, y)	do ; while (0)
#define DPRINTF(x)	do ; while (0)
#define	DBG_ASSERT(x)	do { x; } while (0)
#endif


/************************************************************************
 * Kernel warning messages
 ************************************************************************/
#if	(DEBUG_ENABLE && KERNEL_DEBUG)
#define	KINFO(x)	do { printk x ; } while (0)
#define	PCIINFO(x)	do { printk("$$$: "); printk x ; } while (0)
#define	KFUNC(x)	do { printk("%s: ",__FUNCTION__); printk x ; } while (0)
#else
#define	KINFO(x)	do ; while (0)
#define	KFUNC(x)	do ; while (0)
#endif

#endif	/* #ifndef _DEBUG_H_	*/
