/*
#
#  "$Id: ssl_thread_mutex.h $"
#
#  Copyright (c)1992-2007, ZheJiang Dahua Technology Stock CO.LTD.
#  All Rights Reserved.
#
#	Description:	 封装了普通锁和读写锁的操作,用C语言的方式
#	Revisions:		Year-Month-Day  SVN-Author  Modification
#					2014-8-21		 he_wei		Create
*/

#ifndef __SSL_THREAD_MUTEX_H__
#define __SSL_THREAD_MUTEX_H__

#include <pthread.h>
/*
	* 初期只支持少数几个平台，主要针对ST(sh4, 系统宏：_SH4_LINUX_)平台没有读写锁进行封装     2014-8-21
*/

#ifdef  __cplusplus
extern "C" {
#endif	//__cplusplus

/*
	* 普通锁，用于兼容不同平台的锁操作
*/
typedef struct ssl_thread_mutex{
	pthread_mutex_t mtx;
}ssl_thread_mutex;

int ssl_thread_mutex_init(ssl_thread_mutex*);
int ssl_thread_mutex_lock(ssl_thread_mutex*);
int ssl_thread_mutex_unlock(ssl_thread_mutex*);
int ssl_thread_mutex_destroy(ssl_thread_mutex*);

/*
	* 读写锁，用于兼容不同平台的读写锁，如果没有读写锁，则使用普通锁
*/

enum{
	SSL_READ_LOCK = 1,
	SSL_WRITE_LOCK = 2
};

typedef struct ssl_thread_rw_mutex{
#ifndef _NO_RWLOCK_LINUX_
	pthread_rwlock_t lock_rw;
#else
	pthread_mutex_t mtx;
#endif	//_NO_RWLOCK_LINUX_
}ssl_thread_rw_mutex;

int ssl_thread_rw_mutex_int(ssl_thread_rw_mutex*);
int ssl_thread_rw_mutex_lock(ssl_thread_rw_mutex*, int mode);
int ssl_thread_rw_mutex_unlock(ssl_thread_rw_mutex*);
int ssl_thread_rw_mutex_destroy(ssl_thread_rw_mutex*);

#ifdef  __cplusplus
}
#endif	//__cplusplus

#endif	//__SSL_THREAD_MUTEX_H__

